/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.writer.impl;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.io.compression.ChunkCompressorFactory;
import org.apache.pinot.segment.local.io.writer.impl.VarByteChunkWriter;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class VarByteChunkForwardIndexWriterV4
implements VarByteChunkWriter {
    public static final int VERSION = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(VarByteChunkForwardIndexWriterV4.class);
    private static final String DATA_BUFFER_SUFFIX = ".buf";
    private final File _dataBuffer;
    private final RandomAccessFile _output;
    private final FileChannel _dataChannel;
    private final ByteBuffer _chunkBuffer;
    private final ByteBuffer _compressionBuffer;
    private final ChunkCompressor _chunkCompressor;
    private int _docIdOffset = 0;
    private int _nextDocId = 0;
    private int _metadataSize = 0;
    private long _chunkOffset = 0L;

    public VarByteChunkForwardIndexWriterV4(File file, ChunkCompressionType compressionType, int chunkSize) throws IOException {
        this._dataBuffer = new File(file.getName() + DATA_BUFFER_SUFFIX);
        this._output = new RandomAccessFile(file, "rw");
        this._dataChannel = new RandomAccessFile(this._dataBuffer, "rw").getChannel();
        this._chunkCompressor = ChunkCompressorFactory.getCompressor(compressionType, true);
        this._chunkBuffer = ByteBuffer.allocateDirect(chunkSize).order(ByteOrder.LITTLE_ENDIAN);
        this._compressionBuffer = ByteBuffer.allocateDirect(this._chunkCompressor.maxCompressedSize(chunkSize)).order(ByteOrder.LITTLE_ENDIAN);
        this._chunkBuffer.position(4);
        this.writeHeader(this._chunkCompressor.compressionType(), chunkSize);
    }

    private void writeHeader(ChunkCompressionType compressionType, int targetDecompressedChunkSize) throws IOException {
        this._output.writeInt(4);
        this._output.writeInt(targetDecompressedChunkSize);
        this._output.writeInt(compressionType.getValue());
        this._output.writeInt(0);
        this._metadataSize += 16;
    }

    @Override
    public void putBigDecimal(BigDecimal bigDecimal) {
        this.putBytes(BigDecimalUtils.serialize((BigDecimal)bigDecimal));
    }

    @Override
    public void putString(String string) {
        this.putBytes(string.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public void putBytes(byte[] bytes) {
        Preconditions.checkState((this._chunkOffset < 0x100000000L ? 1 : 0) != 0, (Object)"exceeded 4GB of compressed chunks");
        int sizeRequired = 4 + bytes.length;
        if (this._chunkBuffer.position() > this._chunkBuffer.capacity() - sizeRequired) {
            this.flushChunk();
            if (sizeRequired > this._chunkBuffer.capacity() - 4) {
                this.writeHugeChunk(bytes);
                return;
            }
        }
        this._chunkBuffer.putInt(bytes.length);
        this._chunkBuffer.put(bytes);
        ++this._nextDocId;
    }

    @Override
    public void putStringMV(String[] values) {
        int headerSize;
        int size = headerSize = 4 + 4 * values.length;
        byte[][] stringBytes = new byte[values.length][];
        for (int i = 0; i < values.length; ++i) {
            stringBytes[i] = values[i].getBytes(StandardCharsets.UTF_8);
            size += stringBytes[i].length;
        }
        byte[] serializedBytes = new byte[size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(serializedBytes);
        byteBuffer.putInt(values.length);
        byteBuffer.position(headerSize);
        for (int i = 0; i < values.length; ++i) {
            byteBuffer.putInt((i + 1) * 4, stringBytes[i].length);
            byteBuffer.put(stringBytes[i]);
        }
        this.putBytes(serializedBytes);
    }

    @Override
    public void putBytesMV(byte[][] values) {
        int headerSize;
        int size = headerSize = 4 + 4 * values.length;
        for (byte[] value : values) {
            size += value.length;
        }
        byte[] serializedBytes = new byte[size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(serializedBytes);
        byteBuffer.putInt(values.length);
        byteBuffer.position(headerSize);
        for (int i = 0; i < values.length; ++i) {
            byteBuffer.putInt((i + 1) * 4, values[i].length);
            byteBuffer.put(values[i]);
        }
        this.putBytes(serializedBytes);
    }

    private void writeHugeChunk(byte[] bytes) {
        ByteBuffer buffer;
        if (this._chunkCompressor.compressionType() == ChunkCompressionType.SNAPPY || this._chunkCompressor.compressionType() == ChunkCompressionType.ZSTANDARD) {
            buffer = ByteBuffer.allocateDirect(bytes.length);
            buffer.put(bytes);
            buffer.flip();
        } else {
            buffer = ByteBuffer.wrap(bytes);
        }
        try {
            ++this._nextDocId;
            this.write(buffer, true);
        }
        finally {
            CleanerUtil.cleanQuietly((ByteBuffer)buffer);
        }
    }

    private void flushChunk() {
        if (this._nextDocId > this._docIdOffset) {
            this.writeChunk();
        }
    }

    private void writeChunk() {
        int numDocs = this._nextDocId - this._docIdOffset;
        this._chunkBuffer.putInt(0, numDocs);
        int[] offsets = new int[numDocs];
        int offset = 4;
        for (int i = 0; i < numDocs; ++i) {
            offsets[i] = offset;
            int size = this._chunkBuffer.getInt(offset);
            offset += size + 4;
        }
        int limit = this._chunkBuffer.position();
        int accumulatedOffset = 4;
        for (int i = numDocs - 2; i >= 0; --i) {
            int length = this._chunkBuffer.getInt(offsets[i]);
            ByteBuffer source = this._chunkBuffer.duplicate();
            int copyFrom = offsets[i] + 4;
            source.position(copyFrom).limit(copyFrom + length);
            this._chunkBuffer.position(copyFrom + accumulatedOffset);
            this._chunkBuffer.put(source);
            offsets[i + 1] = this._chunkBuffer.position();
            accumulatedOffset += 4;
        }
        offsets[0] = 4 * (numDocs + 1);
        this._chunkBuffer.position(4);
        this._chunkBuffer.asIntBuffer().put(offsets);
        this._chunkBuffer.position(0);
        this._chunkBuffer.limit(limit);
        this.write(this._chunkBuffer, false);
        this.clearChunkBuffer();
    }

    private void write(ByteBuffer buffer, boolean huge) {
        block10: {
            block9: {
                ByteBuffer mapped = null;
                try {
                    int compressedSize;
                    if (huge) {
                        int maxCompressedSize = this._chunkCompressor.maxCompressedSize(buffer.limit());
                        mapped = this._dataChannel.map(FileChannel.MapMode.READ_WRITE, this._chunkOffset, maxCompressedSize).order(ByteOrder.LITTLE_ENDIAN);
                        compressedSize = this._chunkCompressor.compress(buffer, mapped);
                        this._dataChannel.position(this._chunkOffset + (long)compressedSize);
                    } else {
                        compressedSize = this._chunkCompressor.compress(buffer, this._compressionBuffer);
                        for (int written = 0; written < compressedSize; written += this._dataChannel.write(this._compressionBuffer)) {
                        }
                    }
                    this._output.writeInt(Integer.reverseBytes(this._docIdOffset | (huge ? Integer.MIN_VALUE : 0)));
                    this._output.writeInt(Integer.reverseBytes((int)(this._chunkOffset & 0xFFFFFFFFL)));
                    this._metadataSize += 8;
                    this._chunkOffset += (long)compressedSize;
                    this._docIdOffset = this._nextDocId;
                    if (mapped == null) break block9;
                }
                catch (IOException e) {
                    try {
                        LOGGER.error("Exception caught while compressing/writing data chunk", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        if (mapped != null) {
                            CleanerUtil.cleanQuietly(mapped);
                        } else {
                            this._compressionBuffer.clear();
                        }
                        throw throwable;
                    }
                }
                CleanerUtil.cleanQuietly((ByteBuffer)mapped);
                break block10;
            }
            this._compressionBuffer.clear();
        }
    }

    private void clearChunkBuffer() {
        this._chunkBuffer.clear();
        this._chunkBuffer.position(4);
    }

    @Override
    public void close() throws IOException {
        this.flushChunk();
        this._output.seek(12L);
        this._output.writeInt(this._metadataSize);
        this._output.seek(this._metadataSize);
        this._dataChannel.truncate(this._chunkOffset);
        this._output.setLength((long)this._metadataSize + this._chunkOffset);
        long total = this._chunkOffset;
        long position = 0L;
        while (total > 0L) {
            long transferred = this._dataChannel.transferTo(position, total, this._output.getChannel());
            total -= transferred;
            position += transferred;
        }
        this._dataChannel.close();
        this._output.close();
        CleanerUtil.cleanQuietly((ByteBuffer)this._compressionBuffer);
        CleanerUtil.cleanQuietly((ByteBuffer)this._chunkBuffer);
        FileUtils.deleteQuietly((File)this._dataBuffer);
    }
}

