/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public class ValueReaderComparisons {
    private ValueReaderComparisons() {
    }

    private static int mismatch(PinotDataBuffer dataBuffer, long startOffset, int length, ByteBuffer buffer) {
        int i;
        boolean littleEndian;
        boolean bl = littleEndian = dataBuffer.order() == ByteOrder.LITTLE_ENDIAN;
        if (littleEndian) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        int limit = Math.min(length, buffer.limit());
        int loopBound = limit & 0xFFFFFFF8;
        for (i = 0; i < loopBound; i += 8) {
            long theirs;
            long ours = dataBuffer.getLong(startOffset + (long)i);
            if (ours == (theirs = buffer.getLong(i))) continue;
            long difference = ours ^ theirs;
            return i + ((littleEndian ? Long.numberOfTrailingZeros(difference) : Long.numberOfLeadingZeros(difference)) >>> 3);
        }
        while (i < limit) {
            byte theirs;
            byte ours = dataBuffer.getByte(startOffset + (long)i);
            if (ours != (theirs = buffer.get(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    static int compareBytes(PinotDataBuffer dataBuffer, long startOffset, int length, byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int mismatchPosition = ValueReaderComparisons.mismatch(dataBuffer, startOffset, length, buffer);
        if (mismatchPosition == -1) {
            return length - bytes.length;
        }
        return (dataBuffer.getByte(startOffset + (long)mismatchPosition) & 0xFF) - (bytes[mismatchPosition] & 0xFF);
    }

    static int compareUtf8Bytes(PinotDataBuffer dataBuffer, long startOffset, int length, boolean padded, byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        int mismatchPosition = ValueReaderComparisons.mismatch(dataBuffer, startOffset, length, buffer);
        if (mismatchPosition == -1) {
            if (padded && bytes.length < length) {
                return dataBuffer.getByte(startOffset + (long)bytes.length) == 0 ? 0 : 1;
            }
            return length - bytes.length;
        }
        return ValueReaderComparisons.compareUtf8(dataBuffer, startOffset, buffer, mismatchPosition);
    }

    private static int compareUtf8(PinotDataBuffer ourBuffer, long ourStartOffset, ByteBuffer theirBuffer, int mismatchPosition) {
        char ours1 = '\ufffd';
        char ours2 = '\ufffd';
        char theirs1 = '\ufffd';
        char theirs2 = '\ufffd';
        while (mismatchPosition > 0 && ValueReaderComparisons.isUtf8Continuation(theirBuffer.get(mismatchPosition))) {
            --mismatchPosition;
        }
        long position = ourStartOffset + (long)mismatchPosition;
        byte first = ourBuffer.getByte(position);
        int control = first & 0xF0;
        if (first >= 0) {
            ours1 = (char)(first & 0xFF);
        } else if (control < 224) {
            ours1 = ValueReaderComparisons.decode(first, ourBuffer.getByte(position + 1L));
        } else if (control == 224) {
            ours1 = ValueReaderComparisons.decode(first, ourBuffer.getByte(position + 1L), ourBuffer.getByte(position + 2L));
        } else {
            int codepoint = ValueReaderComparisons.decode(first, ourBuffer.getByte(position + 1L), ourBuffer.getByte(position + 2L), ourBuffer.getByte(position + 3L));
            if (Character.isValidCodePoint(codepoint)) {
                ours1 = Character.highSurrogate(codepoint);
                ours2 = Character.lowSurrogate(codepoint);
            }
        }
        byte first2 = theirBuffer.get(mismatchPosition);
        int control2 = first2 & 0xF0;
        if (first2 >= 0) {
            theirs1 = (char)(first2 & 0xFF);
        } else if (control2 < 224) {
            theirs1 = ValueReaderComparisons.decode(first2, theirBuffer.get(mismatchPosition + 1));
        } else if (control2 == 224) {
            theirs1 = ValueReaderComparisons.decode(first2, theirBuffer.get(mismatchPosition + 1), theirBuffer.get(mismatchPosition + 2));
        } else {
            int codepoint = ValueReaderComparisons.decode(first2, theirBuffer.get(mismatchPosition + 1), theirBuffer.get(mismatchPosition + 2), theirBuffer.get(mismatchPosition + 3));
            if (Character.isValidCodePoint(codepoint)) {
                theirs1 = Character.highSurrogate(codepoint);
                theirs2 = Character.lowSurrogate(codepoint);
            }
        }
        return ours1 == theirs1 ? Character.compare(ours2, theirs2) : Character.compare(ours1, theirs1);
    }

    private static char decode(int b1, int b2) {
        return (char)(b1 << 6 ^ b2 ^ 0xF80);
    }

    private static char decode(int b1, int b2, int b3) {
        return (char)(b1 << 12 ^ b2 << 6 ^ (b3 ^ 0xFFFE1F80));
    }

    private static int decode(int b1, int b2, int b3, int b4) {
        return b1 << 18 ^ b2 << 12 ^ b3 << 6 ^ (b4 ^ 0x381F80);
    }

    private static boolean isUtf8Continuation(byte value) {
        return (value & 0xC0) == 128;
    }
}

