/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.reader.impl;

import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public abstract class FixedBitIntReader {
    final PinotDataBuffer _dataBuffer;

    private FixedBitIntReader(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
    }

    public abstract int read(int var1);

    public abstract int readUnchecked(int var1);

    public abstract void read32(int var1, int[] var2, int var3);

    public static FixedBitIntReader getReader(PinotDataBuffer dataBuffer, int numBitsPerValue) {
        switch (numBitsPerValue) {
            case 1: {
                return new Bit1Reader(dataBuffer);
            }
            case 2: {
                return new Bit2Reader(dataBuffer);
            }
            case 3: {
                return new Bit3Reader(dataBuffer);
            }
            case 4: {
                return new Bit4Reader(dataBuffer);
            }
            case 5: {
                return new Bit5Reader(dataBuffer);
            }
            case 6: {
                return new Bit6Reader(dataBuffer);
            }
            case 7: {
                return new Bit7Reader(dataBuffer);
            }
            case 8: {
                return new Bit8Reader(dataBuffer);
            }
            case 9: {
                return new Bit9Reader(dataBuffer);
            }
            case 10: {
                return new Bit10Reader(dataBuffer);
            }
            case 11: {
                return new Bit11Reader(dataBuffer);
            }
            case 12: {
                return new Bit12Reader(dataBuffer);
            }
            case 13: {
                return new Bit13Reader(dataBuffer);
            }
            case 14: {
                return new Bit14Reader(dataBuffer);
            }
            case 15: {
                return new Bit15Reader(dataBuffer);
            }
            case 16: {
                return new Bit16Reader(dataBuffer);
            }
            case 17: {
                return new Bit17Reader(dataBuffer);
            }
            case 18: {
                return new Bit18Reader(dataBuffer);
            }
            case 19: {
                return new Bit19Reader(dataBuffer);
            }
            case 20: {
                return new Bit20Reader(dataBuffer);
            }
            case 21: {
                return new Bit21Reader(dataBuffer);
            }
            case 22: {
                return new Bit22Reader(dataBuffer);
            }
            case 23: {
                return new Bit23Reader(dataBuffer);
            }
            case 24: {
                return new Bit24Reader(dataBuffer);
            }
            case 25: {
                return new Bit25Reader(dataBuffer);
            }
            case 26: {
                return new Bit26Reader(dataBuffer);
            }
            case 27: {
                return new Bit27Reader(dataBuffer);
            }
            case 28: {
                return new Bit28Reader(dataBuffer);
            }
            case 29: {
                return new Bit29Reader(dataBuffer);
            }
            case 30: {
                return new Bit30Reader(dataBuffer);
            }
            case 31: {
                return new Bit31Reader(dataBuffer);
            }
        }
        throw new IllegalStateException();
    }

    private static class Bit31Reader
    extends FixedBitIntReader {
        private Bit31Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 31L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstInt = this._dataBuffer.getInt(offset) & -1 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 1;
            if (numBitsLeft <= 0) {
                return valueInFirstInt >>> -numBitsLeft;
            }
            return valueInFirstInt << numBitsLeft | (this._dataBuffer.getByte(offset + 4L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 31L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (int)(this._dataBuffer.getLong(offset) >>> 33 - bitOffsetInFirstByte) & Integer.MAX_VALUE;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 31L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            int i26 = this._dataBuffer.getInt(offset + 104L);
            int i27 = this._dataBuffer.getInt(offset + 108L);
            int i28 = this._dataBuffer.getInt(offset + 112L);
            int i29 = this._dataBuffer.getInt(offset + 116L);
            int i30 = this._dataBuffer.getInt(offset + 120L);
            out[outPos] = i0 >>> 1;
            out[outPos + 1] = (i0 & 1) << 30 | i1 >>> 2;
            out[outPos + 2] = (i1 & 3) << 29 | i2 >>> 3;
            out[outPos + 3] = (i2 & 7) << 28 | i3 >>> 4;
            out[outPos + 4] = (i3 & 0xF) << 27 | i4 >>> 5;
            out[outPos + 5] = (i4 & 0x1F) << 26 | i5 >>> 6;
            out[outPos + 6] = (i5 & 0x3F) << 25 | i6 >>> 7;
            out[outPos + 7] = (i6 & 0x7F) << 24 | i7 >>> 8;
            out[outPos + 8] = (i7 & 0xFF) << 23 | i8 >>> 9;
            out[outPos + 9] = (i8 & 0x1FF) << 22 | i9 >>> 10;
            out[outPos + 10] = (i9 & 0x3FF) << 21 | i10 >>> 11;
            out[outPos + 11] = (i10 & 0x7FF) << 20 | i11 >>> 12;
            out[outPos + 12] = (i11 & 0xFFF) << 19 | i12 >>> 13;
            out[outPos + 13] = (i12 & 0x1FFF) << 18 | i13 >>> 14;
            out[outPos + 14] = (i13 & 0x3FFF) << 17 | i14 >>> 15;
            out[outPos + 15] = (i14 & Short.MAX_VALUE) << 16 | i15 >>> 16;
            out[outPos + 16] = (i15 & 0xFFFF) << 15 | i16 >>> 17;
            out[outPos + 17] = (i16 & 0x1FFFF) << 14 | i17 >>> 18;
            out[outPos + 18] = (i17 & 0x3FFFF) << 13 | i18 >>> 19;
            out[outPos + 19] = (i18 & 0x7FFFF) << 12 | i19 >>> 20;
            out[outPos + 20] = (i19 & 0xFFFFF) << 11 | i20 >>> 21;
            out[outPos + 21] = (i20 & 0x1FFFFF) << 10 | i21 >>> 22;
            out[outPos + 22] = (i21 & 0x3FFFFF) << 9 | i22 >>> 23;
            out[outPos + 23] = (i22 & 0x7FFFFF) << 8 | i23 >>> 24;
            out[outPos + 24] = (i23 & 0xFFFFFF) << 7 | i24 >>> 25;
            out[outPos + 25] = (i24 & 0x1FFFFFF) << 6 | i25 >>> 26;
            out[outPos + 26] = (i25 & 0x3FFFFFF) << 5 | i26 >>> 27;
            out[outPos + 27] = (i26 & 0x7FFFFFF) << 4 | i27 >>> 28;
            out[outPos + 28] = (i27 & 0xFFFFFFF) << 3 | i28 >>> 29;
            out[outPos + 29] = (i28 & 0x1FFFFFFF) << 2 | i29 >>> 30;
            out[outPos + 30] = (i29 & 0x3FFFFFFF) << 1 | i30 >>> 31;
            out[outPos + 31] = i30 & Integer.MAX_VALUE;
        }
    }

    private static class Bit30Reader
    extends FixedBitIntReader {
        private Bit30Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 30L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstInt = this._dataBuffer.getInt(offset) & -1 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 2;
            if (numBitsLeft <= 0) {
                return valueInFirstInt >>> -numBitsLeft;
            }
            return valueInFirstInt << numBitsLeft | (this._dataBuffer.getByte(offset + 4L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 30L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (int)(this._dataBuffer.getLong(offset) >>> 34 - bitOffsetInFirstByte) & 0x3FFFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 30L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            int i26 = this._dataBuffer.getInt(offset + 104L);
            int i27 = this._dataBuffer.getInt(offset + 108L);
            int i28 = this._dataBuffer.getInt(offset + 112L);
            int i29 = this._dataBuffer.getInt(offset + 116L);
            out[outPos] = i0 >>> 2;
            out[outPos + 1] = (i0 & 3) << 28 | i1 >>> 4;
            out[outPos + 2] = (i1 & 0xF) << 26 | i2 >>> 6;
            out[outPos + 3] = (i2 & 0x3F) << 24 | i3 >>> 8;
            out[outPos + 4] = (i3 & 0xFF) << 22 | i4 >>> 10;
            out[outPos + 5] = (i4 & 0x3FF) << 20 | i5 >>> 12;
            out[outPos + 6] = (i5 & 0xFFF) << 18 | i6 >>> 14;
            out[outPos + 7] = (i6 & 0x3FFF) << 16 | i7 >>> 16;
            out[outPos + 8] = (i7 & 0xFFFF) << 14 | i8 >>> 18;
            out[outPos + 9] = (i8 & 0x3FFFF) << 12 | i9 >>> 20;
            out[outPos + 10] = (i9 & 0xFFFFF) << 10 | i10 >>> 22;
            out[outPos + 11] = (i10 & 0x3FFFFF) << 8 | i11 >>> 24;
            out[outPos + 12] = (i11 & 0xFFFFFF) << 6 | i12 >>> 26;
            out[outPos + 13] = (i12 & 0x3FFFFFF) << 4 | i13 >>> 28;
            out[outPos + 14] = (i13 & 0xFFFFFFF) << 2 | i14 >>> 30;
            out[outPos + 15] = i14 & 0x3FFFFFFF;
            out[outPos + 16] = i15 >>> 2;
            out[outPos + 17] = (i15 & 3) << 28 | i16 >>> 4;
            out[outPos + 18] = (i16 & 0xF) << 26 | i17 >>> 6;
            out[outPos + 19] = (i17 & 0x3F) << 24 | i18 >>> 8;
            out[outPos + 20] = (i18 & 0xFF) << 22 | i19 >>> 10;
            out[outPos + 21] = (i19 & 0x3FF) << 20 | i20 >>> 12;
            out[outPos + 22] = (i20 & 0xFFF) << 18 | i21 >>> 14;
            out[outPos + 23] = (i21 & 0x3FFF) << 16 | i22 >>> 16;
            out[outPos + 24] = (i22 & 0xFFFF) << 14 | i23 >>> 18;
            out[outPos + 25] = (i23 & 0x3FFFF) << 12 | i24 >>> 20;
            out[outPos + 26] = (i24 & 0xFFFFF) << 10 | i25 >>> 22;
            out[outPos + 27] = (i25 & 0x3FFFFF) << 8 | i26 >>> 24;
            out[outPos + 28] = (i26 & 0xFFFFFF) << 6 | i27 >>> 26;
            out[outPos + 29] = (i27 & 0x3FFFFFF) << 4 | i28 >>> 28;
            out[outPos + 30] = (i28 & 0xFFFFFFF) << 2 | i29 >>> 30;
            out[outPos + 31] = i29 & 0x3FFFFFFF;
        }
    }

    private static class Bit29Reader
    extends FixedBitIntReader {
        private Bit29Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 29L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstInt = this._dataBuffer.getInt(offset) & -1 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 3;
            if (numBitsLeft <= 0) {
                return valueInFirstInt >>> -numBitsLeft;
            }
            return valueInFirstInt << numBitsLeft | (this._dataBuffer.getByte(offset + 4L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 29L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (int)(this._dataBuffer.getLong(offset) >>> 35 - bitOffsetInFirstByte) & 0x1FFFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 29L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            int i26 = this._dataBuffer.getInt(offset + 104L);
            int i27 = this._dataBuffer.getInt(offset + 108L);
            int i28 = this._dataBuffer.getInt(offset + 112L);
            out[outPos] = i0 >>> 3;
            out[outPos + 1] = (i0 & 7) << 26 | i1 >>> 6;
            out[outPos + 2] = (i1 & 0x3F) << 23 | i2 >>> 9;
            out[outPos + 3] = (i2 & 0x1FF) << 20 | i3 >>> 12;
            out[outPos + 4] = (i3 & 0xFFF) << 17 | i4 >>> 15;
            out[outPos + 5] = (i4 & Short.MAX_VALUE) << 14 | i5 >>> 18;
            out[outPos + 6] = (i5 & 0x3FFFF) << 11 | i6 >>> 21;
            out[outPos + 7] = (i6 & 0x1FFFFF) << 8 | i7 >>> 24;
            out[outPos + 8] = (i7 & 0xFFFFFF) << 5 | i8 >>> 27;
            out[outPos + 9] = (i8 & 0x7FFFFFF) << 2 | i9 >>> 30;
            out[outPos + 10] = i9 >>> 1 & 0x1FFFFFFF;
            out[outPos + 11] = (i9 & 1) << 28 | i10 >>> 4;
            out[outPos + 12] = (i10 & 0xF) << 25 | i11 >>> 7;
            out[outPos + 13] = (i11 & 0x7F) << 22 | i12 >>> 10;
            out[outPos + 14] = (i12 & 0x3FF) << 19 | i13 >>> 13;
            out[outPos + 15] = (i13 & 0x1FFF) << 16 | i14 >>> 16;
            out[outPos + 16] = (i14 & 0xFFFF) << 13 | i15 >>> 19;
            out[outPos + 17] = (i15 & 0x7FFFF) << 10 | i16 >>> 22;
            out[outPos + 18] = (i16 & 0x3FFFFF) << 7 | i17 >>> 25;
            out[outPos + 19] = (i17 & 0x1FFFFFF) << 4 | i18 >>> 28;
            out[outPos + 20] = (i18 & 0xFFFFFFF) << 1 | i19 >>> 31;
            out[outPos + 21] = i19 >>> 2 & 0x1FFFFFFF;
            out[outPos + 22] = (i19 & 3) << 27 | i20 >>> 5;
            out[outPos + 23] = (i20 & 0x1F) << 24 | i21 >>> 8;
            out[outPos + 24] = (i21 & 0xFF) << 21 | i22 >>> 11;
            out[outPos + 25] = (i22 & 0x7FF) << 18 | i23 >>> 14;
            out[outPos + 26] = (i23 & 0x3FFF) << 15 | i24 >>> 17;
            out[outPos + 27] = (i24 & 0x1FFFF) << 12 | i25 >>> 20;
            out[outPos + 28] = (i25 & 0xFFFFF) << 9 | i26 >>> 23;
            out[outPos + 29] = (i26 & 0x7FFFFF) << 6 | i27 >>> 26;
            out[outPos + 30] = (i27 & 0x3FFFFFF) << 3 | i28 >>> 29;
            out[outPos + 31] = i28 & 0x1FFFFFFF;
        }
    }

    private static class Bit28Reader
    extends FixedBitIntReader {
        private Bit28Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 28L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 4 - bitOffsetInFirstByte & 0xFFFFFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 28L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 4 - bitOffsetInFirstByte & 0xFFFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 28L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            int i26 = this._dataBuffer.getInt(offset + 104L);
            int i27 = this._dataBuffer.getInt(offset + 108L);
            out[outPos] = i0 >>> 4;
            out[outPos + 1] = (i0 & 0xF) << 24 | i1 >>> 8;
            out[outPos + 2] = (i1 & 0xFF) << 20 | i2 >>> 12;
            out[outPos + 3] = (i2 & 0xFFF) << 16 | i3 >>> 16;
            out[outPos + 4] = (i3 & 0xFFFF) << 12 | i4 >>> 20;
            out[outPos + 5] = (i4 & 0xFFFFF) << 8 | i5 >>> 24;
            out[outPos + 6] = (i5 & 0xFFFFFF) << 4 | i6 >>> 28;
            out[outPos + 7] = i6 & 0xFFFFFFF;
            out[outPos + 8] = i7 >>> 4;
            out[outPos + 9] = (i7 & 0xF) << 24 | i8 >>> 8;
            out[outPos + 10] = (i8 & 0xFF) << 20 | i9 >>> 12;
            out[outPos + 11] = (i9 & 0xFFF) << 16 | i10 >>> 16;
            out[outPos + 12] = (i10 & 0xFFFF) << 12 | i11 >>> 20;
            out[outPos + 13] = (i11 & 0xFFFFF) << 8 | i12 >>> 24;
            out[outPos + 14] = (i12 & 0xFFFFFF) << 4 | i13 >>> 28;
            out[outPos + 15] = i13 & 0xFFFFFFF;
            out[outPos + 16] = i14 >>> 4;
            out[outPos + 17] = (i14 & 0xF) << 24 | i15 >>> 8;
            out[outPos + 18] = (i15 & 0xFF) << 20 | i16 >>> 12;
            out[outPos + 19] = (i16 & 0xFFF) << 16 | i17 >>> 16;
            out[outPos + 20] = (i17 & 0xFFFF) << 12 | i18 >>> 20;
            out[outPos + 21] = (i18 & 0xFFFFF) << 8 | i19 >>> 24;
            out[outPos + 22] = (i19 & 0xFFFFFF) << 4 | i20 >>> 28;
            out[outPos + 23] = i20 & 0xFFFFFFF;
            out[outPos + 24] = i21 >>> 4;
            out[outPos + 25] = (i21 & 0xF) << 24 | i22 >>> 8;
            out[outPos + 26] = (i22 & 0xFF) << 20 | i23 >>> 12;
            out[outPos + 27] = (i23 & 0xFFF) << 16 | i24 >>> 16;
            out[outPos + 28] = (i24 & 0xFFFF) << 12 | i25 >>> 20;
            out[outPos + 29] = (i25 & 0xFFFFF) << 8 | i26 >>> 24;
            out[outPos + 30] = (i26 & 0xFFFFFF) << 4 | i27 >>> 28;
            out[outPos + 31] = i27 & 0xFFFFFFF;
        }
    }

    private static class Bit27Reader
    extends FixedBitIntReader {
        private Bit27Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 27L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstInt = this._dataBuffer.getInt(offset) & -1 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 5;
            if (numBitsLeft <= 0) {
                return valueInFirstInt >>> -numBitsLeft;
            }
            return valueInFirstInt << numBitsLeft | (this._dataBuffer.getByte(offset + 4L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 27L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (int)(this._dataBuffer.getLong(offset) >>> 37 - bitOffsetInFirstByte) & 0x7FFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 27L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            int i26 = this._dataBuffer.getInt(offset + 104L);
            out[outPos] = i0 >>> 5;
            out[outPos + 1] = (i0 & 0x1F) << 22 | i1 >>> 10;
            out[outPos + 2] = (i1 & 0x3FF) << 17 | i2 >>> 15;
            out[outPos + 3] = (i2 & Short.MAX_VALUE) << 12 | i3 >>> 20;
            out[outPos + 4] = (i3 & 0xFFFFF) << 7 | i4 >>> 25;
            out[outPos + 5] = (i4 & 0x1FFFFFF) << 2 | i5 >>> 30;
            out[outPos + 6] = i5 >>> 3 & 0x7FFFFFF;
            out[outPos + 7] = (i5 & 7) << 24 | i6 >>> 8;
            out[outPos + 8] = (i6 & 0xFF) << 19 | i7 >>> 13;
            out[outPos + 9] = (i7 & 0x1FFF) << 14 | i8 >>> 18;
            out[outPos + 10] = (i8 & 0x3FFFF) << 9 | i9 >>> 23;
            out[outPos + 11] = (i9 & 0x7FFFFF) << 4 | i10 >>> 28;
            out[outPos + 12] = i10 >>> 1 & 0x7FFFFFF;
            out[outPos + 13] = (i10 & 1) << 26 | i11 >>> 6;
            out[outPos + 14] = (i11 & 0x3F) << 21 | i12 >>> 11;
            out[outPos + 15] = (i12 & 0x7FF) << 16 | i13 >>> 16;
            out[outPos + 16] = (i13 & 0xFFFF) << 11 | i14 >>> 21;
            out[outPos + 17] = (i14 & 0x1FFFFF) << 6 | i15 >>> 26;
            out[outPos + 18] = (i15 & 0x3FFFFFF) << 1 | i16 >>> 31;
            out[outPos + 19] = i16 >>> 4 & 0x7FFFFFF;
            out[outPos + 20] = (i16 & 0xF) << 23 | i17 >>> 9;
            out[outPos + 21] = (i17 & 0x1FF) << 18 | i18 >>> 14;
            out[outPos + 22] = (i18 & 0x3FFF) << 13 | i19 >>> 19;
            out[outPos + 23] = (i19 & 0x7FFFF) << 8 | i20 >>> 24;
            out[outPos + 24] = (i20 & 0xFFFFFF) << 3 | i21 >>> 29;
            out[outPos + 25] = i21 >>> 2 & 0x7FFFFFF;
            out[outPos + 26] = (i21 & 3) << 25 | i22 >>> 7;
            out[outPos + 27] = (i22 & 0x7F) << 20 | i23 >>> 12;
            out[outPos + 28] = (i23 & 0xFFF) << 15 | i24 >>> 17;
            out[outPos + 29] = (i24 & 0x1FFFF) << 10 | i25 >>> 22;
            out[outPos + 30] = (i25 & 0x3FFFFF) << 5 | i26 >>> 27;
            out[outPos + 31] = i26 & 0x7FFFFFF;
        }
    }

    private static class Bit26Reader
    extends FixedBitIntReader {
        private Bit26Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 26L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 6 - bitOffsetInFirstByte & 0x3FFFFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 26L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 6 - bitOffsetInFirstByte & 0x3FFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 26L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            int i25 = this._dataBuffer.getInt(offset + 100L);
            out[outPos] = i0 >>> 6;
            out[outPos + 1] = (i0 & 0x3F) << 20 | i1 >>> 12;
            out[outPos + 2] = (i1 & 0xFFF) << 14 | i2 >>> 18;
            out[outPos + 3] = (i2 & 0x3FFFF) << 8 | i3 >>> 24;
            out[outPos + 4] = (i3 & 0xFFFFFF) << 2 | i4 >>> 30;
            out[outPos + 5] = i4 >>> 4 & 0x3FFFFFF;
            out[outPos + 6] = (i4 & 0xF) << 22 | i5 >>> 10;
            out[outPos + 7] = (i5 & 0x3FF) << 16 | i6 >>> 16;
            out[outPos + 8] = (i6 & 0xFFFF) << 10 | i7 >>> 22;
            out[outPos + 9] = (i7 & 0x3FFFFF) << 4 | i8 >>> 28;
            out[outPos + 10] = i8 >>> 2 & 0x3FFFFFF;
            out[outPos + 11] = (i8 & 3) << 24 | i9 >>> 8;
            out[outPos + 12] = (i9 & 0xFF) << 18 | i10 >>> 14;
            out[outPos + 13] = (i10 & 0x3FFF) << 12 | i11 >>> 20;
            out[outPos + 14] = (i11 & 0xFFFFF) << 6 | i12 >>> 26;
            out[outPos + 15] = i12 & 0x3FFFFFF;
            out[outPos + 16] = i13 >>> 6;
            out[outPos + 17] = (i13 & 0x3F) << 20 | i14 >>> 12;
            out[outPos + 18] = (i14 & 0xFFF) << 14 | i15 >>> 18;
            out[outPos + 19] = (i15 & 0x3FFFF) << 8 | i16 >>> 24;
            out[outPos + 20] = (i16 & 0xFFFFFF) << 2 | i17 >>> 30;
            out[outPos + 21] = i17 >>> 4 & 0x3FFFFFF;
            out[outPos + 22] = (i17 & 0xF) << 22 | i18 >>> 10;
            out[outPos + 23] = (i18 & 0x3FF) << 16 | i19 >>> 16;
            out[outPos + 24] = (i19 & 0xFFFF) << 10 | i20 >>> 22;
            out[outPos + 25] = (i20 & 0x3FFFFF) << 4 | i21 >>> 28;
            out[outPos + 26] = i21 >>> 2 & 0x3FFFFFF;
            out[outPos + 27] = (i21 & 3) << 24 | i22 >>> 8;
            out[outPos + 28] = (i22 & 0xFF) << 18 | i23 >>> 14;
            out[outPos + 29] = (i23 & 0x3FFF) << 12 | i24 >>> 20;
            out[outPos + 30] = (i24 & 0xFFFFF) << 6 | i25 >>> 26;
            out[outPos + 31] = i25 & 0x3FFFFFF;
        }
    }

    private static class Bit25Reader
    extends FixedBitIntReader {
        private Bit25Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 25L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 7 - bitOffsetInFirstByte & 0x1FFFFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 25L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 7 - bitOffsetInFirstByte & 0x1FFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 25L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            int i24 = this._dataBuffer.getInt(offset + 96L);
            out[outPos] = i0 >>> 7;
            out[outPos + 1] = (i0 & 0x7F) << 18 | i1 >>> 14;
            out[outPos + 2] = (i1 & 0x3FFF) << 11 | i2 >>> 21;
            out[outPos + 3] = (i2 & 0x1FFFFF) << 4 | i3 >>> 28;
            out[outPos + 4] = i3 >>> 3 & 0x1FFFFFF;
            out[outPos + 5] = (i3 & 7) << 22 | i4 >>> 10;
            out[outPos + 6] = (i4 & 0x3FF) << 15 | i5 >>> 17;
            out[outPos + 7] = (i5 & 0x1FFFF) << 8 | i6 >>> 24;
            out[outPos + 8] = (i6 & 0xFFFFFF) << 1 | i7 >>> 31;
            out[outPos + 9] = i7 >>> 6 & 0x1FFFFFF;
            out[outPos + 10] = (i7 & 0x3F) << 19 | i8 >>> 13;
            out[outPos + 11] = (i8 & 0x1FFF) << 12 | i9 >>> 20;
            out[outPos + 12] = (i9 & 0xFFFFF) << 5 | i10 >>> 27;
            out[outPos + 13] = i10 >>> 2 & 0x1FFFFFF;
            out[outPos + 14] = (i10 & 3) << 23 | i11 >>> 9;
            out[outPos + 15] = (i11 & 0x1FF) << 16 | i12 >>> 16;
            out[outPos + 16] = (i12 & 0xFFFF) << 9 | i13 >>> 23;
            out[outPos + 17] = (i13 & 0x7FFFFF) << 2 | i14 >>> 30;
            out[outPos + 18] = i14 >>> 5 & 0x1FFFFFF;
            out[outPos + 19] = (i14 & 0x1F) << 20 | i15 >>> 12;
            out[outPos + 20] = (i15 & 0xFFF) << 13 | i16 >>> 19;
            out[outPos + 21] = (i16 & 0x7FFFF) << 6 | i17 >>> 26;
            out[outPos + 22] = i17 >>> 1 & 0x1FFFFFF;
            out[outPos + 23] = (i17 & 1) << 24 | i18 >>> 8;
            out[outPos + 24] = (i18 & 0xFF) << 17 | i19 >>> 15;
            out[outPos + 25] = (i19 & Short.MAX_VALUE) << 10 | i20 >>> 22;
            out[outPos + 26] = (i20 & 0x3FFFFF) << 3 | i21 >>> 29;
            out[outPos + 27] = i21 >>> 4 & 0x1FFFFFF;
            out[outPos + 28] = (i21 & 0xF) << 21 | i22 >>> 11;
            out[outPos + 29] = (i22 & 0x7FF) << 14 | i23 >>> 18;
            out[outPos + 30] = (i23 & 0x3FFFF) << 7 | i24 >>> 25;
            out[outPos + 31] = i24 & 0x1FFFFFF;
        }
    }

    private static class Bit24Reader
    extends FixedBitIntReader {
        private Bit24Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long offset = (long)index * 3L;
            return (this._dataBuffer.getShort(offset) & 0xFFFF) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF;
        }

        @Override
        public int readUnchecked(int index) {
            long offset = (long)index * 3L;
            return this._dataBuffer.getInt(offset) >>> 8;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)index * 3L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            int i23 = this._dataBuffer.getInt(offset + 92L);
            out[outPos] = i0 >>> 8;
            out[outPos + 1] = (i0 & 0xFF) << 16 | i1 >>> 16;
            out[outPos + 2] = (i1 & 0xFFFF) << 8 | i2 >>> 24;
            out[outPos + 3] = i2 & 0xFFFFFF;
            out[outPos + 4] = i3 >>> 8;
            out[outPos + 5] = (i3 & 0xFF) << 16 | i4 >>> 16;
            out[outPos + 6] = (i4 & 0xFFFF) << 8 | i5 >>> 24;
            out[outPos + 7] = i5 & 0xFFFFFF;
            out[outPos + 8] = i6 >>> 8;
            out[outPos + 9] = (i6 & 0xFF) << 16 | i7 >>> 16;
            out[outPos + 10] = (i7 & 0xFFFF) << 8 | i8 >>> 24;
            out[outPos + 11] = i8 & 0xFFFFFF;
            out[outPos + 12] = i9 >>> 8;
            out[outPos + 13] = (i9 & 0xFF) << 16 | i10 >>> 16;
            out[outPos + 14] = (i10 & 0xFFFF) << 8 | i11 >>> 24;
            out[outPos + 15] = i11 & 0xFFFFFF;
            out[outPos + 16] = i12 >>> 8;
            out[outPos + 17] = (i12 & 0xFF) << 16 | i13 >>> 16;
            out[outPos + 18] = (i13 & 0xFFFF) << 8 | i14 >>> 24;
            out[outPos + 19] = i14 & 0xFFFFFF;
            out[outPos + 20] = i15 >>> 8;
            out[outPos + 21] = (i15 & 0xFF) << 16 | i16 >>> 16;
            out[outPos + 22] = (i16 & 0xFFFF) << 8 | i17 >>> 24;
            out[outPos + 23] = i17 & 0xFFFFFF;
            out[outPos + 24] = i18 >>> 8;
            out[outPos + 25] = (i18 & 0xFF) << 16 | i19 >>> 16;
            out[outPos + 26] = (i19 & 0xFFFF) << 8 | i20 >>> 24;
            out[outPos + 27] = i20 & 0xFFFFFF;
            out[outPos + 28] = i21 >>> 8;
            out[outPos + 29] = (i21 & 0xFF) << 16 | i22 >>> 16;
            out[outPos + 30] = (i22 & 0xFFFF) << 8 | i23 >>> 24;
            out[outPos + 31] = i23 & 0xFFFFFF;
        }
    }

    private static class Bit23Reader
    extends FixedBitIntReader {
        private Bit23Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 23L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirst3Bytes = (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) & 0xFFFFFF >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 1;
            if (numBitsLeft <= 0) {
                return valueInFirst3Bytes >>> -numBitsLeft;
            }
            return valueInFirst3Bytes << numBitsLeft | (this._dataBuffer.getByte(offset + 3L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 23L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 9 - bitOffsetInFirstByte & 0x7FFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 23L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            int i22 = this._dataBuffer.getInt(offset + 88L);
            out[outPos] = i0 >>> 9;
            out[outPos + 1] = (i0 & 0x1FF) << 14 | i1 >>> 18;
            out[outPos + 2] = (i1 & 0x3FFFF) << 5 | i2 >>> 27;
            out[outPos + 3] = i2 >>> 4 & 0x7FFFFF;
            out[outPos + 4] = (i2 & 0xF) << 19 | i3 >>> 13;
            out[outPos + 5] = (i3 & 0x1FFF) << 10 | i4 >>> 22;
            out[outPos + 6] = (i4 & 0x3FFFFF) << 1 | i5 >>> 31;
            out[outPos + 7] = i5 >>> 8 & 0x7FFFFF;
            out[outPos + 8] = (i5 & 0xFF) << 15 | i6 >>> 17;
            out[outPos + 9] = (i6 & 0x1FFFF) << 6 | i7 >>> 26;
            out[outPos + 10] = i7 >>> 3 & 0x7FFFFF;
            out[outPos + 11] = (i7 & 7) << 20 | i8 >>> 12;
            out[outPos + 12] = (i8 & 0xFFF) << 11 | i9 >>> 21;
            out[outPos + 13] = (i9 & 0x1FFFFF) << 2 | i10 >>> 30;
            out[outPos + 14] = i10 >>> 7 & 0x7FFFFF;
            out[outPos + 15] = (i10 & 0x7F) << 16 | i11 >>> 16;
            out[outPos + 16] = (i11 & 0xFFFF) << 7 | i12 >>> 25;
            out[outPos + 17] = i12 >>> 2 & 0x7FFFFF;
            out[outPos + 18] = (i12 & 3) << 21 | i13 >>> 11;
            out[outPos + 19] = (i13 & 0x7FF) << 12 | i14 >>> 20;
            out[outPos + 20] = (i14 & 0xFFFFF) << 3 | i15 >>> 29;
            out[outPos + 21] = i15 >>> 6 & 0x7FFFFF;
            out[outPos + 22] = (i15 & 0x3F) << 17 | i16 >>> 15;
            out[outPos + 23] = (i16 & Short.MAX_VALUE) << 8 | i17 >>> 24;
            out[outPos + 24] = i17 >>> 1 & 0x7FFFFF;
            out[outPos + 25] = (i17 & 1) << 22 | i18 >>> 10;
            out[outPos + 26] = (i18 & 0x3FF) << 13 | i19 >>> 19;
            out[outPos + 27] = (i19 & 0x7FFFF) << 4 | i20 >>> 28;
            out[outPos + 28] = i20 >>> 5 & 0x7FFFFF;
            out[outPos + 29] = (i20 & 0x1F) << 18 | i21 >>> 14;
            out[outPos + 30] = (i21 & 0x3FFF) << 9 | i22 >>> 23;
            out[outPos + 31] = i22 & 0x7FFFFF;
        }
    }

    private static class Bit22Reader
    extends FixedBitIntReader {
        private Bit22Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 22L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirst3Bytes = (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) & 0xFFFFFF >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 2;
            if (numBitsLeft <= 0) {
                return valueInFirst3Bytes >>> -numBitsLeft;
            }
            return valueInFirst3Bytes << numBitsLeft | (this._dataBuffer.getByte(offset + 3L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 22L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 10 - bitOffsetInFirstByte & 0x3FFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 22L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            int i21 = this._dataBuffer.getInt(offset + 84L);
            out[outPos] = i0 >>> 10;
            out[outPos + 1] = (i0 & 0x3FF) << 12 | i1 >>> 20;
            out[outPos + 2] = (i1 & 0xFFFFF) << 2 | i2 >>> 30;
            out[outPos + 3] = i2 >>> 8 & 0x3FFFFF;
            out[outPos + 4] = (i2 & 0xFF) << 14 | i3 >>> 18;
            out[outPos + 5] = (i3 & 0x3FFFF) << 4 | i4 >>> 28;
            out[outPos + 6] = i4 >>> 6 & 0x3FFFFF;
            out[outPos + 7] = (i4 & 0x3F) << 16 | i5 >>> 16;
            out[outPos + 8] = (i5 & 0xFFFF) << 6 | i6 >>> 26;
            out[outPos + 9] = i6 >>> 4 & 0x3FFFFF;
            out[outPos + 10] = (i6 & 0xF) << 18 | i7 >>> 14;
            out[outPos + 11] = (i7 & 0x3FFF) << 8 | i8 >>> 24;
            out[outPos + 12] = i8 >>> 2 & 0x3FFFFF;
            out[outPos + 13] = (i8 & 3) << 20 | i9 >>> 12;
            out[outPos + 14] = (i9 & 0xFFF) << 10 | i10 >>> 22;
            out[outPos + 15] = i10 & 0x3FFFFF;
            out[outPos + 16] = i11 >>> 10;
            out[outPos + 17] = (i11 & 0x3FF) << 12 | i12 >>> 20;
            out[outPos + 18] = (i12 & 0xFFFFF) << 2 | i13 >>> 30;
            out[outPos + 19] = i13 >>> 8 & 0x3FFFFF;
            out[outPos + 20] = (i13 & 0xFF) << 14 | i14 >>> 18;
            out[outPos + 21] = (i14 & 0x3FFFF) << 4 | i15 >>> 28;
            out[outPos + 22] = i15 >>> 6 & 0x3FFFFF;
            out[outPos + 23] = (i15 & 0x3F) << 16 | i16 >>> 16;
            out[outPos + 24] = (i16 & 0xFFFF) << 6 | i17 >>> 26;
            out[outPos + 25] = i17 >>> 4 & 0x3FFFFF;
            out[outPos + 26] = (i17 & 0xF) << 18 | i18 >>> 14;
            out[outPos + 27] = (i18 & 0x3FFF) << 8 | i19 >>> 24;
            out[outPos + 28] = i19 >>> 2 & 0x3FFFFF;
            out[outPos + 29] = (i19 & 3) << 20 | i20 >>> 12;
            out[outPos + 30] = (i20 & 0xFFF) << 10 | i21 >>> 22;
            out[outPos + 31] = i21 & 0x3FFFFF;
        }
    }

    private static class Bit21Reader
    extends FixedBitIntReader {
        private Bit21Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 21L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirst3Bytes = (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) & 0xFFFFFF >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 3;
            if (numBitsLeft <= 0) {
                return valueInFirst3Bytes >>> -numBitsLeft;
            }
            return valueInFirst3Bytes << numBitsLeft | (this._dataBuffer.getByte(offset + 3L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 21L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 11 - bitOffsetInFirstByte & 0x1FFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 21L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            int i20 = this._dataBuffer.getInt(offset + 80L);
            out[outPos] = i0 >>> 11;
            out[outPos + 1] = (i0 & 0x7FF) << 10 | i1 >>> 22;
            out[outPos + 2] = i1 >>> 1 & 0x1FFFFF;
            out[outPos + 3] = (i1 & 1) << 20 | i2 >>> 12;
            out[outPos + 4] = (i2 & 0xFFF) << 9 | i3 >>> 23;
            out[outPos + 5] = i3 >>> 2 & 0x1FFFFF;
            out[outPos + 6] = (i3 & 3) << 19 | i4 >>> 13;
            out[outPos + 7] = (i4 & 0x1FFF) << 8 | i5 >>> 24;
            out[outPos + 8] = i5 >>> 3 & 0x1FFFFF;
            out[outPos + 9] = (i5 & 7) << 18 | i6 >>> 14;
            out[outPos + 10] = (i6 & 0x3FFF) << 7 | i7 >>> 25;
            out[outPos + 11] = i7 >>> 4 & 0x1FFFFF;
            out[outPos + 12] = (i7 & 0xF) << 17 | i8 >>> 15;
            out[outPos + 13] = (i8 & Short.MAX_VALUE) << 6 | i9 >>> 26;
            out[outPos + 14] = i9 >>> 5 & 0x1FFFFF;
            out[outPos + 15] = (i9 & 0x1F) << 16 | i10 >>> 16;
            out[outPos + 16] = (i10 & 0xFFFF) << 5 | i11 >>> 27;
            out[outPos + 17] = i11 >>> 6 & 0x1FFFFF;
            out[outPos + 18] = (i11 & 0x3F) << 15 | i12 >>> 17;
            out[outPos + 19] = (i12 & 0x1FFFF) << 4 | i13 >>> 28;
            out[outPos + 20] = i13 >>> 7 & 0x1FFFFF;
            out[outPos + 21] = (i13 & 0x7F) << 14 | i14 >>> 18;
            out[outPos + 22] = (i14 & 0x3FFFF) << 3 | i15 >>> 29;
            out[outPos + 23] = i15 >>> 8 & 0x1FFFFF;
            out[outPos + 24] = (i15 & 0xFF) << 13 | i16 >>> 19;
            out[outPos + 25] = (i16 & 0x7FFFF) << 2 | i17 >>> 30;
            out[outPos + 26] = i17 >>> 9 & 0x1FFFFF;
            out[outPos + 27] = (i17 & 0x1FF) << 12 | i18 >>> 20;
            out[outPos + 28] = (i18 & 0xFFFFF) << 1 | i19 >>> 31;
            out[outPos + 29] = i19 >>> 10 & 0x1FFFFF;
            out[outPos + 30] = (i19 & 0x3FF) << 11 | i20 >>> 21;
            out[outPos + 31] = i20 & 0x1FFFFF;
        }
    }

    private static class Bit20Reader
    extends FixedBitIntReader {
        private Bit20Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 20L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 4 - bitOffsetInFirstByte & 0xFFFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 20L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 12 - bitOffsetInFirstByte & 0xFFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 20L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            int i19 = this._dataBuffer.getInt(offset + 76L);
            out[outPos] = i0 >>> 12;
            out[outPos + 1] = (i0 & 0xFFF) << 8 | i1 >>> 24;
            out[outPos + 2] = i1 >>> 4 & 0xFFFFF;
            out[outPos + 3] = (i1 & 0xF) << 16 | i2 >>> 16;
            out[outPos + 4] = (i2 & 0xFFFF) << 4 | i3 >>> 28;
            out[outPos + 5] = i3 >>> 8 & 0xFFFFF;
            out[outPos + 6] = (i3 & 0xFF) << 12 | i4 >>> 20;
            out[outPos + 7] = i4 & 0xFFFFF;
            out[outPos + 8] = i5 >>> 12;
            out[outPos + 9] = (i5 & 0xFFF) << 8 | i6 >>> 24;
            out[outPos + 10] = i6 >>> 4 & 0xFFFFF;
            out[outPos + 11] = (i6 & 0xF) << 16 | i7 >>> 16;
            out[outPos + 12] = (i7 & 0xFFFF) << 4 | i8 >>> 28;
            out[outPos + 13] = i8 >>> 8 & 0xFFFFF;
            out[outPos + 14] = (i8 & 0xFF) << 12 | i9 >>> 20;
            out[outPos + 15] = i9 & 0xFFFFF;
            out[outPos + 16] = i10 >>> 12;
            out[outPos + 17] = (i10 & 0xFFF) << 8 | i11 >>> 24;
            out[outPos + 18] = i11 >>> 4 & 0xFFFFF;
            out[outPos + 19] = (i11 & 0xF) << 16 | i12 >>> 16;
            out[outPos + 20] = (i12 & 0xFFFF) << 4 | i13 >>> 28;
            out[outPos + 21] = i13 >>> 8 & 0xFFFFF;
            out[outPos + 22] = (i13 & 0xFF) << 12 | i14 >>> 20;
            out[outPos + 23] = i14 & 0xFFFFF;
            out[outPos + 24] = i15 >>> 12;
            out[outPos + 25] = (i15 & 0xFFF) << 8 | i16 >>> 24;
            out[outPos + 26] = i16 >>> 4 & 0xFFFFF;
            out[outPos + 27] = (i16 & 0xF) << 16 | i17 >>> 16;
            out[outPos + 28] = (i17 & 0xFFFF) << 4 | i18 >>> 28;
            out[outPos + 29] = i18 >>> 8 & 0xFFFFF;
            out[outPos + 30] = (i18 & 0xFF) << 12 | i19 >>> 20;
            out[outPos + 31] = i19 & 0xFFFFF;
        }
    }

    private static class Bit19Reader
    extends FixedBitIntReader {
        private Bit19Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 19L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirst3Bytes = (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) & 0xFFFFFF >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 5;
            if (numBitsLeft <= 0) {
                return valueInFirst3Bytes >>> -numBitsLeft;
            }
            return valueInFirst3Bytes << numBitsLeft | (this._dataBuffer.getByte(offset + 3L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 19L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 13 - bitOffsetInFirstByte & 0x7FFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 19L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            int i18 = this._dataBuffer.getInt(offset + 72L);
            out[outPos] = i0 >>> 13;
            out[outPos + 1] = (i0 & 0x1FFF) << 6 | i1 >>> 26;
            out[outPos + 2] = i1 >>> 7 & 0x7FFFF;
            out[outPos + 3] = (i1 & 0x7F) << 12 | i2 >>> 20;
            out[outPos + 4] = i2 >>> 1 & 0x7FFFF;
            out[outPos + 5] = (i2 & 1) << 18 | i3 >>> 14;
            out[outPos + 6] = (i3 & 0x3FFF) << 5 | i4 >>> 27;
            out[outPos + 7] = i4 >>> 8 & 0x7FFFF;
            out[outPos + 8] = (i4 & 0xFF) << 11 | i5 >>> 21;
            out[outPos + 9] = i5 >>> 2 & 0x7FFFF;
            out[outPos + 10] = (i5 & 3) << 17 | i6 >>> 15;
            out[outPos + 11] = (i6 & Short.MAX_VALUE) << 4 | i7 >>> 28;
            out[outPos + 12] = i7 >>> 9 & 0x7FFFF;
            out[outPos + 13] = (i7 & 0x1FF) << 10 | i8 >>> 22;
            out[outPos + 14] = i8 >>> 3 & 0x7FFFF;
            out[outPos + 15] = (i8 & 7) << 16 | i9 >>> 16;
            out[outPos + 16] = (i9 & 0xFFFF) << 3 | i10 >>> 29;
            out[outPos + 17] = i10 >>> 10 & 0x7FFFF;
            out[outPos + 18] = (i10 & 0x3FF) << 9 | i11 >>> 23;
            out[outPos + 19] = i11 >>> 4 & 0x7FFFF;
            out[outPos + 20] = (i11 & 0xF) << 15 | i12 >>> 17;
            out[outPos + 21] = (i12 & 0x1FFFF) << 2 | i13 >>> 30;
            out[outPos + 22] = i13 >>> 11 & 0x7FFFF;
            out[outPos + 23] = (i13 & 0x7FF) << 8 | i14 >>> 24;
            out[outPos + 24] = i14 >>> 5 & 0x7FFFF;
            out[outPos + 25] = (i14 & 0x1F) << 14 | i15 >>> 18;
            out[outPos + 26] = (i15 & 0x3FFFF) << 1 | i16 >>> 31;
            out[outPos + 27] = i16 >>> 12 & 0x7FFFF;
            out[outPos + 28] = (i16 & 0xFFF) << 7 | i17 >>> 25;
            out[outPos + 29] = i17 >>> 6 & 0x7FFFF;
            out[outPos + 30] = (i17 & 0x3F) << 13 | i18 >>> 19;
            out[outPos + 31] = i18 & 0x7FFFF;
        }
    }

    private static class Bit18Reader
    extends FixedBitIntReader {
        private Bit18Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 18L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 6 - bitOffsetInFirstByte & 0x3FFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 18L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 14 - bitOffsetInFirstByte & 0x3FFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 18L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            int i17 = this._dataBuffer.getInt(offset + 68L);
            out[outPos] = i0 >>> 14;
            out[outPos + 1] = (i0 & 0x3FFF) << 4 | i1 >>> 28;
            out[outPos + 2] = i1 >>> 10 & 0x3FFFF;
            out[outPos + 3] = (i1 & 0x3FF) << 8 | i2 >>> 24;
            out[outPos + 4] = i2 >>> 6 & 0x3FFFF;
            out[outPos + 5] = (i2 & 0x3F) << 12 | i3 >>> 20;
            out[outPos + 6] = i3 >>> 2 & 0x3FFFF;
            out[outPos + 7] = (i3 & 3) << 16 | i4 >>> 16;
            out[outPos + 8] = (i4 & 0xFFFF) << 2 | i5 >>> 30;
            out[outPos + 9] = i5 >>> 12 & 0x3FFFF;
            out[outPos + 10] = (i5 & 0xFFF) << 6 | i6 >>> 26;
            out[outPos + 11] = i6 >>> 8 & 0x3FFFF;
            out[outPos + 12] = (i6 & 0xFF) << 10 | i7 >>> 22;
            out[outPos + 13] = i7 >>> 4 & 0x3FFFF;
            out[outPos + 14] = (i7 & 0xF) << 14 | i8 >>> 18;
            out[outPos + 15] = i8 & 0x3FFFF;
            out[outPos + 16] = i9 >>> 14;
            out[outPos + 17] = (i9 & 0x3FFF) << 4 | i10 >>> 28;
            out[outPos + 18] = i10 >>> 10 & 0x3FFFF;
            out[outPos + 19] = (i10 & 0x3FF) << 8 | i11 >>> 24;
            out[outPos + 20] = i11 >>> 6 & 0x3FFFF;
            out[outPos + 21] = (i11 & 0x3F) << 12 | i12 >>> 20;
            out[outPos + 22] = i12 >>> 2 & 0x3FFFF;
            out[outPos + 23] = (i12 & 3) << 16 | i13 >>> 16;
            out[outPos + 24] = (i13 & 0xFFFF) << 2 | i14 >>> 30;
            out[outPos + 25] = i14 >>> 12 & 0x3FFFF;
            out[outPos + 26] = (i14 & 0xFFF) << 6 | i15 >>> 26;
            out[outPos + 27] = i15 >>> 8 & 0x3FFFF;
            out[outPos + 28] = (i15 & 0xFF) << 10 | i16 >>> 22;
            out[outPos + 29] = i16 >>> 4 & 0x3FFFF;
            out[outPos + 30] = (i16 & 0xF) << 14 | i17 >>> 18;
            out[outPos + 31] = i17 & 0x3FFFF;
        }
    }

    private static class Bit17Reader
    extends FixedBitIntReader {
        private Bit17Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 17L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return (this._dataBuffer.getShort(offset) << 8 | this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 7 - bitOffsetInFirstByte & 0x1FFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 17L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 15 - bitOffsetInFirstByte & 0x1FFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 17L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            int i16 = this._dataBuffer.getInt(offset + 64L);
            out[outPos] = i0 >>> 15;
            out[outPos + 1] = (i0 & Short.MAX_VALUE) << 2 | i1 >>> 30;
            out[outPos + 2] = i1 >>> 13 & 0x1FFFF;
            out[outPos + 3] = (i1 & 0x1FFF) << 4 | i2 >>> 28;
            out[outPos + 4] = i2 >>> 11 & 0x1FFFF;
            out[outPos + 5] = (i2 & 0x7FF) << 6 | i3 >>> 26;
            out[outPos + 6] = i3 >>> 9 & 0x1FFFF;
            out[outPos + 7] = (i3 & 0x1FF) << 8 | i4 >>> 24;
            out[outPos + 8] = i4 >>> 7 & 0x1FFFF;
            out[outPos + 9] = (i4 & 0x7F) << 10 | i5 >>> 22;
            out[outPos + 10] = i5 >>> 5 & 0x1FFFF;
            out[outPos + 11] = (i5 & 0x1F) << 12 | i6 >>> 20;
            out[outPos + 12] = i6 >>> 3 & 0x1FFFF;
            out[outPos + 13] = (i6 & 7) << 14 | i7 >>> 18;
            out[outPos + 14] = i7 >>> 1 & 0x1FFFF;
            out[outPos + 15] = (i7 & 1) << 16 | i8 >>> 16;
            out[outPos + 16] = (i8 & 0xFFFF) << 1 | i9 >>> 31;
            out[outPos + 17] = i9 >>> 14 & 0x1FFFF;
            out[outPos + 18] = (i9 & 0x3FFF) << 3 | i10 >>> 29;
            out[outPos + 19] = i10 >>> 12 & 0x1FFFF;
            out[outPos + 20] = (i10 & 0xFFF) << 5 | i11 >>> 27;
            out[outPos + 21] = i11 >>> 10 & 0x1FFFF;
            out[outPos + 22] = (i11 & 0x3FF) << 7 | i12 >>> 25;
            out[outPos + 23] = i12 >>> 8 & 0x1FFFF;
            out[outPos + 24] = (i12 & 0xFF) << 9 | i13 >>> 23;
            out[outPos + 25] = i13 >>> 6 & 0x1FFFF;
            out[outPos + 26] = (i13 & 0x3F) << 11 | i14 >>> 21;
            out[outPos + 27] = i14 >>> 4 & 0x1FFFF;
            out[outPos + 28] = (i14 & 0xF) << 13 | i15 >>> 19;
            out[outPos + 29] = i15 >>> 2 & 0x1FFFF;
            out[outPos + 30] = (i15 & 3) << 15 | i16 >>> 17;
            out[outPos + 31] = i16 & 0x1FFFF;
        }
    }

    private static class Bit16Reader
    extends FixedBitIntReader {
        private Bit16Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            return this._dataBuffer.getShort((long)index << 1) & 0xFFFF;
        }

        @Override
        public int readUnchecked(int index) {
            return this._dataBuffer.getShort((long)index << 1) & 0xFFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)index << 1;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            int i15 = this._dataBuffer.getInt(offset + 60L);
            out[outPos] = i0 >>> 16;
            out[outPos + 1] = i0 & 0xFFFF;
            out[outPos + 2] = i1 >>> 16;
            out[outPos + 3] = i1 & 0xFFFF;
            out[outPos + 4] = i2 >>> 16;
            out[outPos + 5] = i2 & 0xFFFF;
            out[outPos + 6] = i3 >>> 16;
            out[outPos + 7] = i3 & 0xFFFF;
            out[outPos + 8] = i4 >>> 16;
            out[outPos + 9] = i4 & 0xFFFF;
            out[outPos + 10] = i5 >>> 16;
            out[outPos + 11] = i5 & 0xFFFF;
            out[outPos + 12] = i6 >>> 16;
            out[outPos + 13] = i6 & 0xFFFF;
            out[outPos + 14] = i7 >>> 16;
            out[outPos + 15] = i7 & 0xFFFF;
            out[outPos + 16] = i8 >>> 16;
            out[outPos + 17] = i8 & 0xFFFF;
            out[outPos + 18] = i9 >>> 16;
            out[outPos + 19] = i9 & 0xFFFF;
            out[outPos + 20] = i10 >>> 16;
            out[outPos + 21] = i10 & 0xFFFF;
            out[outPos + 22] = i11 >>> 16;
            out[outPos + 23] = i11 & 0xFFFF;
            out[outPos + 24] = i12 >>> 16;
            out[outPos + 25] = i12 & 0xFFFF;
            out[outPos + 26] = i13 >>> 16;
            out[outPos + 27] = i13 & 0xFFFF;
            out[outPos + 28] = i14 >>> 16;
            out[outPos + 29] = i14 & 0xFFFF;
            out[outPos + 30] = i15 >>> 16;
            out[outPos + 31] = i15 & 0xFFFF;
        }
    }

    private static class Bit15Reader
    extends FixedBitIntReader {
        private Bit15Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 15L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstShort = this._dataBuffer.getShort(offset) & 65535 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 1;
            if (numBitsLeft <= 0) {
                return valueInFirstShort >>> -numBitsLeft;
            }
            return valueInFirstShort << numBitsLeft | (this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 15L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 17 - bitOffsetInFirstByte & Short.MAX_VALUE;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 15L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            int i14 = this._dataBuffer.getInt(offset + 56L);
            out[outPos] = i0 >>> 17;
            out[outPos + 1] = i0 >>> 2 & Short.MAX_VALUE;
            out[outPos + 2] = (i0 & 3) << 13 | i1 >>> 19;
            out[outPos + 3] = i1 >>> 4 & Short.MAX_VALUE;
            out[outPos + 4] = (i1 & 0xF) << 11 | i2 >>> 21;
            out[outPos + 5] = i2 >>> 6 & Short.MAX_VALUE;
            out[outPos + 6] = (i2 & 0x3F) << 9 | i3 >>> 23;
            out[outPos + 7] = i3 >>> 8 & Short.MAX_VALUE;
            out[outPos + 8] = (i3 & 0xFF) << 7 | i4 >>> 25;
            out[outPos + 9] = i4 >>> 10 & Short.MAX_VALUE;
            out[outPos + 10] = (i4 & 0x3FF) << 5 | i5 >>> 27;
            out[outPos + 11] = i5 >>> 12 & Short.MAX_VALUE;
            out[outPos + 12] = (i5 & 0xFFF) << 3 | i6 >>> 29;
            out[outPos + 13] = i6 >>> 14 & Short.MAX_VALUE;
            out[outPos + 14] = (i6 & 0x3FFF) << 1 | i7 >>> 31;
            out[outPos + 15] = i7 >>> 16 & Short.MAX_VALUE;
            out[outPos + 16] = i7 >>> 1 & Short.MAX_VALUE;
            out[outPos + 17] = (i7 & 1) << 14 | i8 >>> 18;
            out[outPos + 18] = i8 >>> 3 & Short.MAX_VALUE;
            out[outPos + 19] = (i8 & 7) << 12 | i9 >>> 20;
            out[outPos + 20] = i9 >>> 5 & Short.MAX_VALUE;
            out[outPos + 21] = (i9 & 0x1F) << 10 | i10 >>> 22;
            out[outPos + 22] = i10 >>> 7 & Short.MAX_VALUE;
            out[outPos + 23] = (i10 & 0x7F) << 8 | i11 >>> 24;
            out[outPos + 24] = i11 >>> 9 & Short.MAX_VALUE;
            out[outPos + 25] = (i11 & 0x1FF) << 6 | i12 >>> 26;
            out[outPos + 26] = i12 >>> 11 & Short.MAX_VALUE;
            out[outPos + 27] = (i12 & 0x7FF) << 4 | i13 >>> 28;
            out[outPos + 28] = i13 >>> 13 & Short.MAX_VALUE;
            out[outPos + 29] = (i13 & 0x1FFF) << 2 | i14 >>> 30;
            out[outPos + 30] = i14 >>> 15 & Short.MAX_VALUE;
            out[outPos + 31] = i14 & Short.MAX_VALUE;
        }
    }

    private static class Bit14Reader
    extends FixedBitIntReader {
        private Bit14Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 14L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstShort = this._dataBuffer.getShort(offset) & 65535 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 2;
            if (numBitsLeft <= 0) {
                return valueInFirstShort >>> -numBitsLeft;
            }
            return valueInFirstShort << numBitsLeft | (this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 14L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 18 - bitOffsetInFirstByte & 0x3FFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 14L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            int i13 = this._dataBuffer.getInt(offset + 52L);
            out[outPos] = i0 >>> 18;
            out[outPos + 1] = i0 >>> 4 & 0x3FFF;
            out[outPos + 2] = (i0 & 0xF) << 10 | i1 >>> 22;
            out[outPos + 3] = i1 >>> 8 & 0x3FFF;
            out[outPos + 4] = (i1 & 0xFF) << 6 | i2 >>> 26;
            out[outPos + 5] = i2 >>> 12 & 0x3FFF;
            out[outPos + 6] = (i2 & 0xFFF) << 2 | i3 >>> 30;
            out[outPos + 7] = i3 >>> 16 & 0x3FFF;
            out[outPos + 8] = i3 >>> 2 & 0x3FFF;
            out[outPos + 9] = (i3 & 3) << 12 | i4 >>> 20;
            out[outPos + 10] = i4 >>> 6 & 0x3FFF;
            out[outPos + 11] = (i4 & 0x3F) << 8 | i5 >>> 24;
            out[outPos + 12] = i5 >>> 10 & 0x3FFF;
            out[outPos + 13] = (i5 & 0x3FF) << 4 | i6 >>> 28;
            out[outPos + 14] = i6 >>> 14 & 0x3FFF;
            out[outPos + 15] = i6 & 0x3FFF;
            out[outPos + 16] = i7 >>> 18;
            out[outPos + 17] = i7 >>> 4 & 0x3FFF;
            out[outPos + 18] = (i7 & 0xF) << 10 | i8 >>> 22;
            out[outPos + 19] = i8 >>> 8 & 0x3FFF;
            out[outPos + 20] = (i8 & 0xFF) << 6 | i9 >>> 26;
            out[outPos + 21] = i9 >>> 12 & 0x3FFF;
            out[outPos + 22] = (i9 & 0xFFF) << 2 | i10 >>> 30;
            out[outPos + 23] = i10 >>> 16 & 0x3FFF;
            out[outPos + 24] = i10 >>> 2 & 0x3FFF;
            out[outPos + 25] = (i10 & 3) << 12 | i11 >>> 20;
            out[outPos + 26] = i11 >>> 6 & 0x3FFF;
            out[outPos + 27] = (i11 & 0x3F) << 8 | i12 >>> 24;
            out[outPos + 28] = i12 >>> 10 & 0x3FFF;
            out[outPos + 29] = (i12 & 0x3FF) << 4 | i13 >>> 28;
            out[outPos + 30] = i13 >>> 14 & 0x3FFF;
            out[outPos + 31] = i13 & 0x3FFF;
        }
    }

    private static class Bit13Reader
    extends FixedBitIntReader {
        private Bit13Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 13L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstShort = this._dataBuffer.getShort(offset) & 65535 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 3;
            if (numBitsLeft <= 0) {
                return valueInFirstShort >>> -numBitsLeft;
            }
            return valueInFirstShort << numBitsLeft | (this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 13L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 19 - bitOffsetInFirstByte & 0x1FFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 13L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            int i12 = this._dataBuffer.getInt(offset + 48L);
            out[outPos] = i0 >>> 19;
            out[outPos + 1] = i0 >>> 6 & 0x1FFF;
            out[outPos + 2] = (i0 & 0x3F) << 7 | i1 >>> 25;
            out[outPos + 3] = i1 >>> 12 & 0x1FFF;
            out[outPos + 4] = (i1 & 0xFFF) << 1 | i2 >>> 31;
            out[outPos + 5] = i2 >>> 18 & 0x1FFF;
            out[outPos + 6] = i2 >>> 5 & 0x1FFF;
            out[outPos + 7] = (i2 & 0x1F) << 8 | i3 >>> 24;
            out[outPos + 8] = i3 >>> 11 & 0x1FFF;
            out[outPos + 9] = (i3 & 0x7FF) << 2 | i4 >>> 30;
            out[outPos + 10] = i4 >>> 17 & 0x1FFF;
            out[outPos + 11] = i4 >>> 4 & 0x1FFF;
            out[outPos + 12] = (i4 & 0xF) << 9 | i5 >>> 23;
            out[outPos + 13] = i5 >>> 10 & 0x1FFF;
            out[outPos + 14] = (i5 & 0x3FF) << 3 | i6 >>> 29;
            out[outPos + 15] = i6 >>> 16 & 0x1FFF;
            out[outPos + 16] = i6 >>> 3 & 0x1FFF;
            out[outPos + 17] = (i6 & 7) << 10 | i7 >>> 22;
            out[outPos + 18] = i7 >>> 9 & 0x1FFF;
            out[outPos + 19] = (i7 & 0x1FF) << 4 | i8 >>> 28;
            out[outPos + 20] = i8 >>> 15 & 0x1FFF;
            out[outPos + 21] = i8 >>> 2 & 0x1FFF;
            out[outPos + 22] = (i8 & 3) << 11 | i9 >>> 21;
            out[outPos + 23] = i9 >>> 8 & 0x1FFF;
            out[outPos + 24] = (i9 & 0xFF) << 5 | i10 >>> 27;
            out[outPos + 25] = i10 >>> 14 & 0x1FFF;
            out[outPos + 26] = i10 >>> 1 & 0x1FFF;
            out[outPos + 27] = (i10 & 1) << 12 | i11 >>> 20;
            out[outPos + 28] = i11 >>> 7 & 0x1FFF;
            out[outPos + 29] = (i11 & 0x7F) << 6 | i12 >>> 26;
            out[outPos + 30] = i12 >>> 13 & 0x1FFF;
            out[outPos + 31] = i12 & 0x1FFF;
        }
    }

    private static class Bit12Reader
    extends FixedBitIntReader {
        private Bit12Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 12L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 4 - bitOffsetInFirstByte & 0xFFF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 12L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 4 - bitOffsetInFirstByte & 0xFFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 12L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            int i11 = this._dataBuffer.getInt(offset + 44L);
            out[outPos] = i0 >>> 20;
            out[outPos + 1] = i0 >>> 8 & 0xFFF;
            out[outPos + 2] = (i0 & 0xFF) << 4 | i1 >>> 28;
            out[outPos + 3] = i1 >>> 16 & 0xFFF;
            out[outPos + 4] = i1 >>> 4 & 0xFFF;
            out[outPos + 5] = (i1 & 0xF) << 8 | i2 >>> 24;
            out[outPos + 6] = i2 >>> 12 & 0xFFF;
            out[outPos + 7] = i2 & 0xFFF;
            out[outPos + 8] = i3 >>> 20;
            out[outPos + 9] = i3 >>> 8 & 0xFFF;
            out[outPos + 10] = (i3 & 0xFF) << 4 | i4 >>> 28;
            out[outPos + 11] = i4 >>> 16 & 0xFFF;
            out[outPos + 12] = i4 >>> 4 & 0xFFF;
            out[outPos + 13] = (i4 & 0xF) << 8 | i5 >>> 24;
            out[outPos + 14] = i5 >>> 12 & 0xFFF;
            out[outPos + 15] = i5 & 0xFFF;
            out[outPos + 16] = i6 >>> 20;
            out[outPos + 17] = i6 >>> 8 & 0xFFF;
            out[outPos + 18] = (i6 & 0xFF) << 4 | i7 >>> 28;
            out[outPos + 19] = i7 >>> 16 & 0xFFF;
            out[outPos + 20] = i7 >>> 4 & 0xFFF;
            out[outPos + 21] = (i7 & 0xF) << 8 | i8 >>> 24;
            out[outPos + 22] = i8 >>> 12 & 0xFFF;
            out[outPos + 23] = i8 & 0xFFF;
            out[outPos + 24] = i9 >>> 20;
            out[outPos + 25] = i9 >>> 8 & 0xFFF;
            out[outPos + 26] = (i9 & 0xFF) << 4 | i10 >>> 28;
            out[outPos + 27] = i10 >>> 16 & 0xFFF;
            out[outPos + 28] = i10 >>> 4 & 0xFFF;
            out[outPos + 29] = (i10 & 0xF) << 8 | i11 >>> 24;
            out[outPos + 30] = i11 >>> 12 & 0xFFF;
            out[outPos + 31] = i11 & 0xFFF;
        }
    }

    private static class Bit11Reader
    extends FixedBitIntReader {
        private Bit11Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 11L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstShort = this._dataBuffer.getShort(offset) & 65535 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 5;
            if (numBitsLeft <= 0) {
                return valueInFirstShort >>> -numBitsLeft;
            }
            return valueInFirstShort << numBitsLeft | (this._dataBuffer.getByte(offset + 2L) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 11L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getInt(offset) >>> 21 - bitOffsetInFirstByte & 0x7FF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 11L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            int i10 = this._dataBuffer.getInt(offset + 40L);
            out[outPos] = i0 >>> 21;
            out[outPos + 1] = i0 >>> 10 & 0x7FF;
            out[outPos + 2] = (i0 & 0x3FF) << 1 | i1 >>> 31;
            out[outPos + 3] = i1 >>> 20 & 0x7FF;
            out[outPos + 4] = i1 >>> 9 & 0x7FF;
            out[outPos + 5] = (i1 & 0x1FF) << 2 | i2 >>> 30;
            out[outPos + 6] = i2 >>> 19 & 0x7FF;
            out[outPos + 7] = i2 >>> 8 & 0x7FF;
            out[outPos + 8] = (i2 & 0xFF) << 3 | i3 >>> 29;
            out[outPos + 9] = i3 >>> 18 & 0x7FF;
            out[outPos + 10] = i3 >>> 7 & 0x7FF;
            out[outPos + 11] = (i3 & 0x7F) << 4 | i4 >>> 28;
            out[outPos + 12] = i4 >>> 17 & 0x7FF;
            out[outPos + 13] = i4 >>> 6 & 0x7FF;
            out[outPos + 14] = (i4 & 0x3F) << 5 | i5 >>> 27;
            out[outPos + 15] = i5 >>> 16 & 0x7FF;
            out[outPos + 16] = i5 >>> 5 & 0x7FF;
            out[outPos + 17] = (i5 & 0x1F) << 6 | i6 >>> 26;
            out[outPos + 18] = i6 >>> 15 & 0x7FF;
            out[outPos + 19] = i6 >>> 4 & 0x7FF;
            out[outPos + 20] = (i6 & 0xF) << 7 | i7 >>> 25;
            out[outPos + 21] = i7 >>> 14 & 0x7FF;
            out[outPos + 22] = i7 >>> 3 & 0x7FF;
            out[outPos + 23] = (i7 & 7) << 8 | i8 >>> 24;
            out[outPos + 24] = i8 >>> 13 & 0x7FF;
            out[outPos + 25] = i8 >>> 2 & 0x7FF;
            out[outPos + 26] = (i8 & 3) << 9 | i9 >>> 23;
            out[outPos + 27] = i9 >>> 12 & 0x7FF;
            out[outPos + 28] = i9 >>> 1 & 0x7FF;
            out[outPos + 29] = (i9 & 1) << 10 | i10 >>> 22;
            out[outPos + 30] = i10 >>> 11 & 0x7FF;
            out[outPos + 31] = i10 & 0x7FF;
        }
    }

    private static class Bit10Reader
    extends FixedBitIntReader {
        private Bit10Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 10L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 6 - bitOffsetInFirstByte & 0x3FF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 10L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 6 - bitOffsetInFirstByte & 0x3FF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 10L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            int i9 = this._dataBuffer.getInt(offset + 36L);
            out[outPos] = i0 >>> 22;
            out[outPos + 1] = i0 >>> 12 & 0x3FF;
            out[outPos + 2] = i0 >>> 2 & 0x3FF;
            out[outPos + 3] = (i0 & 3) << 8 | i1 >>> 24;
            out[outPos + 4] = i1 >>> 14 & 0x3FF;
            out[outPos + 5] = i1 >>> 4 & 0x3FF;
            out[outPos + 6] = (i1 & 0xF) << 6 | i2 >>> 26;
            out[outPos + 7] = i2 >>> 16 & 0x3FF;
            out[outPos + 8] = i2 >>> 6 & 0x3FF;
            out[outPos + 9] = (i2 & 0x3F) << 4 | i3 >>> 28;
            out[outPos + 10] = i3 >>> 18 & 0x3FF;
            out[outPos + 11] = i3 >>> 8 & 0x3FF;
            out[outPos + 12] = (i3 & 0xFF) << 2 | i4 >>> 30;
            out[outPos + 13] = i4 >>> 20 & 0x3FF;
            out[outPos + 14] = i4 >>> 10 & 0x3FF;
            out[outPos + 15] = i4 & 0x3FF;
            out[outPos + 16] = i5 >>> 22;
            out[outPos + 17] = i5 >>> 12 & 0x3FF;
            out[outPos + 18] = i5 >>> 2 & 0x3FF;
            out[outPos + 19] = (i5 & 3) << 8 | i6 >>> 24;
            out[outPos + 20] = i6 >>> 14 & 0x3FF;
            out[outPos + 21] = i6 >>> 4 & 0x3FF;
            out[outPos + 22] = (i6 & 0xF) << 6 | i7 >>> 26;
            out[outPos + 23] = i7 >>> 16 & 0x3FF;
            out[outPos + 24] = i7 >>> 6 & 0x3FF;
            out[outPos + 25] = (i7 & 0x3F) << 4 | i8 >>> 28;
            out[outPos + 26] = i8 >>> 18 & 0x3FF;
            out[outPos + 27] = i8 >>> 8 & 0x3FF;
            out[outPos + 28] = (i8 & 0xFF) << 2 | i9 >>> 30;
            out[outPos + 29] = i9 >>> 20 & 0x3FF;
            out[outPos + 30] = i9 >>> 10 & 0x3FF;
            out[outPos + 31] = i9 & 0x3FF;
        }
    }

    private static class Bit9Reader
    extends FixedBitIntReader {
        private Bit9Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 9L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 7 - bitOffsetInFirstByte & 0x1FF;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 9L;
            long offset = bitOffset >>> 3;
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 7 - bitOffsetInFirstByte & 0x1FF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            long offset = (long)(index >>> 3) * 9L;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4L);
            int i2 = this._dataBuffer.getInt(offset + 8L);
            int i3 = this._dataBuffer.getInt(offset + 12L);
            int i4 = this._dataBuffer.getInt(offset + 16L);
            int i5 = this._dataBuffer.getInt(offset + 20L);
            int i6 = this._dataBuffer.getInt(offset + 24L);
            int i7 = this._dataBuffer.getInt(offset + 28L);
            int i8 = this._dataBuffer.getInt(offset + 32L);
            out[outPos] = i0 >>> 23;
            out[outPos + 1] = i0 >>> 14 & 0x1FF;
            out[outPos + 2] = i0 >>> 5 & 0x1FF;
            out[outPos + 3] = (i0 & 0x1F) << 4 | i1 >>> 28;
            out[outPos + 4] = i1 >>> 19 & 0x1FF;
            out[outPos + 5] = i1 >>> 10 & 0x1FF;
            out[outPos + 6] = i1 >>> 1 & 0x1FF;
            out[outPos + 7] = (i1 & 1) << 8 | i2 >>> 24;
            out[outPos + 8] = i2 >>> 15 & 0x1FF;
            out[outPos + 9] = i2 >>> 6 & 0x1FF;
            out[outPos + 10] = (i2 & 0x3F) << 3 | i3 >>> 29;
            out[outPos + 11] = i3 >>> 20 & 0x1FF;
            out[outPos + 12] = i3 >>> 11 & 0x1FF;
            out[outPos + 13] = i3 >>> 2 & 0x1FF;
            out[outPos + 14] = (i3 & 3) << 7 | i4 >>> 25;
            out[outPos + 15] = i4 >>> 16 & 0x1FF;
            out[outPos + 16] = i4 >>> 7 & 0x1FF;
            out[outPos + 17] = (i4 & 0x7F) << 2 | i5 >>> 30;
            out[outPos + 18] = i5 >>> 21 & 0x1FF;
            out[outPos + 19] = i5 >>> 12 & 0x1FF;
            out[outPos + 20] = i5 >>> 3 & 0x1FF;
            out[outPos + 21] = (i5 & 7) << 6 | i6 >>> 26;
            out[outPos + 22] = i6 >>> 17 & 0x1FF;
            out[outPos + 23] = i6 >>> 8 & 0x1FF;
            out[outPos + 24] = (i6 & 0xFF) << 1 | i7 >>> 31;
            out[outPos + 25] = i7 >>> 22 & 0x1FF;
            out[outPos + 26] = i7 >>> 13 & 0x1FF;
            out[outPos + 27] = i7 >>> 4 & 0x1FF;
            out[outPos + 28] = (i7 & 0xF) << 5 | i8 >>> 27;
            out[outPos + 29] = i8 >>> 18 & 0x1FF;
            out[outPos + 30] = i8 >>> 9 & 0x1FF;
            out[outPos + 31] = i8 & 0x1FF;
        }
    }

    private static class Bit8Reader
    extends FixedBitIntReader {
        private Bit8Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            return this._dataBuffer.getByte(index) & 0xFF;
        }

        @Override
        public int readUnchecked(int index) {
            return this._dataBuffer.getByte(index) & 0xFF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int i0 = this._dataBuffer.getInt(index);
            int i1 = this._dataBuffer.getInt(index + 4);
            int i2 = this._dataBuffer.getInt(index + 8);
            int i3 = this._dataBuffer.getInt(index + 12);
            int i4 = this._dataBuffer.getInt(index + 16);
            int i5 = this._dataBuffer.getInt(index + 20);
            int i6 = this._dataBuffer.getInt(index + 24);
            int i7 = this._dataBuffer.getInt(index + 28);
            out[outPos] = i0 >>> 24;
            out[outPos + 1] = i0 >>> 16 & 0xFF;
            out[outPos + 2] = i0 >>> 8 & 0xFF;
            out[outPos + 3] = i0 & 0xFF;
            out[outPos + 4] = i1 >>> 24;
            out[outPos + 5] = i1 >>> 16 & 0xFF;
            out[outPos + 6] = i1 >>> 8 & 0xFF;
            out[outPos + 7] = i1 & 0xFF;
            out[outPos + 8] = i2 >>> 24;
            out[outPos + 9] = i2 >>> 16 & 0xFF;
            out[outPos + 10] = i2 >>> 8 & 0xFF;
            out[outPos + 11] = i2 & 0xFF;
            out[outPos + 12] = i3 >>> 24;
            out[outPos + 13] = i3 >>> 16 & 0xFF;
            out[outPos + 14] = i3 >>> 8 & 0xFF;
            out[outPos + 15] = i3 & 0xFF;
            out[outPos + 16] = i4 >>> 24;
            out[outPos + 17] = i4 >>> 16 & 0xFF;
            out[outPos + 18] = i4 >>> 8 & 0xFF;
            out[outPos + 19] = i4 & 0xFF;
            out[outPos + 20] = i5 >>> 24;
            out[outPos + 21] = i5 >>> 16 & 0xFF;
            out[outPos + 22] = i5 >>> 8 & 0xFF;
            out[outPos + 23] = i5 & 0xFF;
            out[outPos + 24] = i6 >>> 24;
            out[outPos + 25] = i6 >>> 16 & 0xFF;
            out[outPos + 26] = i6 >>> 8 & 0xFF;
            out[outPos + 27] = i6 & 0xFF;
            out[outPos + 28] = i7 >>> 24;
            out[outPos + 29] = i7 >>> 16 & 0xFF;
            out[outPos + 30] = i7 >>> 8 & 0xFF;
            out[outPos + 31] = i7 & 0xFF;
        }
    }

    private static class Bit7Reader
    extends FixedBitIntReader {
        private Bit7Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 7L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstByte = this._dataBuffer.getByte(offset) & 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 1;
            if (numBitsLeft <= 0) {
                return valueInFirstByte >>> -numBitsLeft;
            }
            return valueInFirstByte << numBitsLeft | (this._dataBuffer.getByte(offset + 1) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 7L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 9 - bitOffsetInFirstByte & 0x7F;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = (index >>> 3) * 7;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            int i2 = this._dataBuffer.getInt(offset + 8);
            int i3 = this._dataBuffer.getInt(offset + 12);
            int i4 = this._dataBuffer.getInt(offset + 16);
            int i5 = this._dataBuffer.getInt(offset + 20);
            int i6 = this._dataBuffer.getInt(offset + 24);
            out[outPos] = i0 >>> 25 & 0x7F;
            out[outPos + 1] = i0 >>> 18 & 0x7F;
            out[outPos + 2] = i0 >>> 11 & 0x7F;
            out[outPos + 3] = i0 >>> 4 & 0x7F;
            out[outPos + 4] = (i0 & 0xF) << 3 | i1 >>> 29;
            out[outPos + 5] = i1 >>> 22 & 0x7F;
            out[outPos + 6] = i1 >>> 15 & 0x7F;
            out[outPos + 7] = i1 >>> 8 & 0x7F;
            out[outPos + 8] = i1 >>> 1 & 0x7F;
            out[outPos + 9] = (i1 & 1) << 6 | i2 >>> 26;
            out[outPos + 10] = i2 >>> 19 & 0x7F;
            out[outPos + 11] = i2 >>> 12 & 0x7F;
            out[outPos + 12] = i2 >>> 5 & 0x7F;
            out[outPos + 13] = (i2 & 0x1F) << 2 | i3 >>> 30;
            out[outPos + 14] = i3 >>> 23 & 0x7F;
            out[outPos + 15] = i3 >>> 16 & 0x7F;
            out[outPos + 16] = i3 >>> 9 & 0x7F;
            out[outPos + 17] = i3 >>> 2 & 0x7F;
            out[outPos + 18] = (i3 & 3) << 5 | i4 >>> 27;
            out[outPos + 19] = i4 >>> 20 & 0x7F;
            out[outPos + 20] = i4 >>> 13 & 0x7F;
            out[outPos + 21] = i4 >>> 6 & 0x7F;
            out[outPos + 22] = (i4 & 0x3F) << 1 | i5 >>> 31;
            out[outPos + 23] = i5 >>> 24 & 0x7F;
            out[outPos + 24] = i5 >>> 17 & 0x7F;
            out[outPos + 25] = i5 >>> 10 & 0x7F;
            out[outPos + 26] = i5 >>> 3 & 0x7F;
            out[outPos + 27] = (i5 & 7) << 4 | i6 >>> 28;
            out[outPos + 28] = i6 >>> 21 & 0x7F;
            out[outPos + 29] = i6 >>> 14 & 0x7F;
            out[outPos + 30] = i6 >>> 7 & 0x7F;
            out[outPos + 31] = i6 & 0x7F;
        }
    }

    private static class Bit6Reader
    extends FixedBitIntReader {
        private Bit6Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 6L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstByte = this._dataBuffer.getByte(offset) & 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 2;
            if (numBitsLeft <= 0) {
                return valueInFirstByte >>> -numBitsLeft;
            }
            return valueInFirstByte << numBitsLeft | (this._dataBuffer.getByte(offset + 1) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 6L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 10 - bitOffsetInFirstByte & 0x3F;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = (index >>> 3) * 6;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            int i2 = this._dataBuffer.getInt(offset + 8);
            int i3 = this._dataBuffer.getInt(offset + 12);
            int i4 = this._dataBuffer.getInt(offset + 16);
            int i5 = this._dataBuffer.getInt(offset + 20);
            out[outPos] = i0 >>> 26 & 0x3F;
            out[outPos + 1] = i0 >>> 20 & 0x3F;
            out[outPos + 2] = i0 >>> 14 & 0x3F;
            out[outPos + 3] = i0 >>> 8 & 0x3F;
            out[outPos + 4] = i0 >>> 2 & 0x3F;
            out[outPos + 5] = (i0 & 3) << 4 | i1 >>> 28;
            out[outPos + 6] = i1 >>> 22 & 0x3F;
            out[outPos + 7] = i1 >>> 16 & 0x3F;
            out[outPos + 8] = i1 >>> 10 & 0x3F;
            out[outPos + 9] = i1 >>> 4 & 0x3F;
            out[outPos + 10] = (i1 & 0xF) << 2 | i2 >>> 30;
            out[outPos + 11] = i2 >>> 24 & 0x3F;
            out[outPos + 12] = i2 >>> 18 & 0x3F;
            out[outPos + 13] = i2 >>> 12 & 0x3F;
            out[outPos + 14] = i2 >>> 6 & 0x3F;
            out[outPos + 15] = i2 & 0x3F;
            out[outPos + 16] = i3 >>> 26 & 0x3F;
            out[outPos + 17] = i3 >>> 20 & 0x3F;
            out[outPos + 18] = i3 >>> 14 & 0x3F;
            out[outPos + 19] = i3 >>> 8 & 0x3F;
            out[outPos + 20] = i3 >>> 2 & 0x3F;
            out[outPos + 21] = (i3 & 3) << 4 | i4 >>> 28;
            out[outPos + 22] = i4 >>> 22 & 0x3F;
            out[outPos + 23] = i4 >>> 16 & 0x3F;
            out[outPos + 24] = i4 >>> 10 & 0x3F;
            out[outPos + 25] = i4 >>> 4 & 0x3F;
            out[outPos + 26] = (i4 & 0xF) << 2 | i5 >>> 30;
            out[outPos + 27] = i5 >>> 24 & 0x3F;
            out[outPos + 28] = i5 >>> 18 & 0x3F;
            out[outPos + 29] = i5 >>> 12 & 0x3F;
            out[outPos + 30] = i5 >>> 6 & 0x3F;
            out[outPos + 31] = i5 & 0x3F;
        }
    }

    private static class Bit5Reader
    extends FixedBitIntReader {
        private Bit5Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 5L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstByte = this._dataBuffer.getByte(offset) & 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 3;
            if (numBitsLeft <= 0) {
                return valueInFirstByte >>> -numBitsLeft;
            }
            return valueInFirstByte << numBitsLeft | (this._dataBuffer.getByte(offset + 1) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 5L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 11 - bitOffsetInFirstByte & 0x1F;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = (index >>> 3) * 5;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            int i2 = this._dataBuffer.getInt(offset + 8);
            int i3 = this._dataBuffer.getInt(offset + 12);
            int i4 = this._dataBuffer.getInt(offset + 16);
            out[outPos] = i0 >>> 27;
            out[outPos + 1] = i0 >>> 22 & 0x1F;
            out[outPos + 2] = i0 >>> 17 & 0x1F;
            out[outPos + 3] = i0 >>> 12 & 0x1F;
            out[outPos + 4] = i0 >>> 7 & 0x1F;
            out[outPos + 5] = i0 >>> 2 & 0x1F;
            out[outPos + 6] = (i0 & 3) << 3 | i1 >>> 29;
            out[outPos + 7] = i1 >>> 24 & 0x1F;
            out[outPos + 8] = i1 >>> 19 & 0x1F;
            out[outPos + 9] = i1 >>> 14 & 0x1F;
            out[outPos + 10] = i1 >>> 9 & 0x1F;
            out[outPos + 11] = i1 >>> 4 & 0x1F;
            out[outPos + 12] = (i1 & 0xF) << 1 | i2 >>> 31;
            out[outPos + 13] = i2 >>> 26 & 0x1F;
            out[outPos + 14] = i2 >>> 21 & 0x1F;
            out[outPos + 15] = i2 >>> 16 & 0x1F;
            out[outPos + 16] = i2 >>> 11 & 0x1F;
            out[outPos + 17] = i2 >>> 6 & 0x1F;
            out[outPos + 18] = i2 >>> 1 & 0x1F;
            out[outPos + 19] = (i2 & 1) << 4 | i3 >>> 28;
            out[outPos + 20] = i3 >>> 23 & 0x1F;
            out[outPos + 21] = i3 >>> 18 & 0x1F;
            out[outPos + 22] = i3 >>> 13 & 0x1F;
            out[outPos + 23] = i3 >>> 8 & 0x1F;
            out[outPos + 24] = i3 >>> 3 & 0x1F;
            out[outPos + 25] = (i3 & 7) << 2 | i4 >>> 30;
            out[outPos + 26] = i4 >>> 25 & 0x1F;
            out[outPos + 27] = i4 >>> 20 & 0x1F;
            out[outPos + 28] = i4 >>> 15 & 0x1F;
            out[outPos + 29] = i4 >>> 10 & 0x1F;
            out[outPos + 30] = i4 >>> 5 & 0x1F;
            out[outPos + 31] = i4 & 0x1F;
        }
    }

    private static class Bit4Reader
    extends FixedBitIntReader {
        private Bit4Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            int offset = index >>> 1;
            int bitOffsetInByte = index << 2 & 7;
            return this._dataBuffer.getByte(offset) >>> 4 - bitOffsetInByte & 0xF;
        }

        @Override
        public int readUnchecked(int index) {
            int offset = index >>> 1;
            int bitOffsetInByte = index << 2 & 7;
            return this._dataBuffer.getByte(offset) >>> 4 - bitOffsetInByte & 0xF;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = index >>> 1;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            int i2 = this._dataBuffer.getInt(offset + 8);
            int i3 = this._dataBuffer.getInt(offset + 12);
            out[outPos] = i0 >>> 28;
            out[outPos + 1] = i0 >>> 24 & 0xF;
            out[outPos + 2] = i0 >>> 20 & 0xF;
            out[outPos + 3] = i0 >>> 16 & 0xF;
            out[outPos + 4] = i0 >>> 12 & 0xF;
            out[outPos + 5] = i0 >>> 8 & 0xF;
            out[outPos + 6] = i0 >>> 4 & 0xF;
            out[outPos + 7] = i0 & 0xF;
            out[outPos + 8] = i1 >>> 28;
            out[outPos + 9] = i1 >>> 24 & 0xF;
            out[outPos + 10] = i1 >>> 20 & 0xF;
            out[outPos + 11] = i1 >>> 16 & 0xF;
            out[outPos + 12] = i1 >>> 12 & 0xF;
            out[outPos + 13] = i1 >>> 8 & 0xF;
            out[outPos + 14] = i1 >>> 4 & 0xF;
            out[outPos + 15] = i1 & 0xF;
            out[outPos + 16] = i2 >>> 28;
            out[outPos + 17] = i2 >>> 24 & 0xF;
            out[outPos + 18] = i2 >>> 20 & 0xF;
            out[outPos + 19] = i2 >>> 16 & 0xF;
            out[outPos + 20] = i2 >>> 12 & 0xF;
            out[outPos + 21] = i2 >>> 8 & 0xF;
            out[outPos + 22] = i2 >>> 4 & 0xF;
            out[outPos + 23] = i2 & 0xF;
            out[outPos + 24] = i3 >>> 28;
            out[outPos + 25] = i3 >>> 24 & 0xF;
            out[outPos + 26] = i3 >>> 20 & 0xF;
            out[outPos + 27] = i3 >>> 16 & 0xF;
            out[outPos + 28] = i3 >>> 12 & 0xF;
            out[outPos + 29] = i3 >>> 8 & 0xF;
            out[outPos + 30] = i3 >>> 4 & 0xF;
            out[outPos + 31] = i3 & 0xF;
        }
    }

    private static class Bit3Reader
    extends FixedBitIntReader {
        private Bit3Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            long bitOffset = (long)index * 3L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            int valueInFirstByte = this._dataBuffer.getByte(offset) & 255 >>> bitOffsetInFirstByte;
            int numBitsLeft = bitOffsetInFirstByte - 5;
            if (numBitsLeft <= 0) {
                return valueInFirstByte >>> -numBitsLeft;
            }
            return valueInFirstByte << numBitsLeft | (this._dataBuffer.getByte(offset + 1) & 0xFF) >>> 8 - numBitsLeft;
        }

        @Override
        public int readUnchecked(int index) {
            long bitOffset = (long)index * 3L;
            int offset = (int)(bitOffset >>> 3);
            int bitOffsetInFirstByte = (int)bitOffset & 7;
            return this._dataBuffer.getShort(offset) >>> 13 - bitOffsetInFirstByte & 7;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = (index >>> 3) * 3;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            int i2 = this._dataBuffer.getInt(offset + 8);
            out[outPos] = i0 >>> 29;
            out[outPos + 1] = i0 >>> 26 & 7;
            out[outPos + 2] = i0 >>> 23 & 7;
            out[outPos + 3] = i0 >>> 20 & 7;
            out[outPos + 4] = i0 >>> 17 & 7;
            out[outPos + 5] = i0 >>> 14 & 7;
            out[outPos + 6] = i0 >>> 11 & 7;
            out[outPos + 7] = i0 >>> 8 & 7;
            out[outPos + 8] = i0 >>> 5 & 7;
            out[outPos + 9] = i0 >>> 2 & 7;
            out[outPos + 10] = (i0 & 3) << 1 | i1 >>> 31;
            out[outPos + 11] = i1 >>> 28 & 7;
            out[outPos + 12] = i1 >>> 25 & 7;
            out[outPos + 13] = i1 >>> 22 & 7;
            out[outPos + 14] = i1 >>> 19 & 7;
            out[outPos + 15] = i1 >>> 16 & 7;
            out[outPos + 16] = i1 >>> 13 & 7;
            out[outPos + 17] = i1 >>> 10 & 7;
            out[outPos + 18] = i1 >>> 7 & 7;
            out[outPos + 19] = i1 >>> 4 & 7;
            out[outPos + 20] = i1 >>> 1 & 7;
            out[outPos + 21] = (i1 & 1) << 2 | i2 >>> 30;
            out[outPos + 22] = i2 >>> 27 & 7;
            out[outPos + 23] = i2 >>> 24 & 7;
            out[outPos + 24] = i2 >>> 21 & 7;
            out[outPos + 25] = i2 >>> 18 & 7;
            out[outPos + 26] = i2 >>> 15 & 7;
            out[outPos + 27] = i2 >>> 12 & 7;
            out[outPos + 28] = i2 >>> 9 & 7;
            out[outPos + 29] = i2 >>> 6 & 7;
            out[outPos + 30] = i2 >>> 3 & 7;
            out[outPos + 31] = i2 & 7;
        }
    }

    private static class Bit2Reader
    extends FixedBitIntReader {
        private Bit2Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            int offset = index >>> 2;
            int bitOffsetInByte = index << 1 & 7;
            return this._dataBuffer.getByte(offset) >>> 6 - bitOffsetInByte & 3;
        }

        @Override
        public int readUnchecked(int index) {
            int offset = index >>> 2;
            int bitOffsetInByte = index << 1 & 7;
            return this._dataBuffer.getByte(offset) >>> 6 - bitOffsetInByte & 3;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = index >>> 2;
            int i0 = this._dataBuffer.getInt(offset);
            int i1 = this._dataBuffer.getInt(offset + 4);
            out[outPos] = i0 >>> 30;
            out[outPos + 1] = i0 >>> 28 & 3;
            out[outPos + 2] = i0 >>> 26 & 3;
            out[outPos + 3] = i0 >>> 24 & 3;
            out[outPos + 4] = i0 >>> 22 & 3;
            out[outPos + 5] = i0 >>> 20 & 3;
            out[outPos + 6] = i0 >>> 18 & 3;
            out[outPos + 7] = i0 >>> 16 & 3;
            out[outPos + 8] = i0 >>> 14 & 3;
            out[outPos + 9] = i0 >>> 12 & 3;
            out[outPos + 10] = i0 >>> 10 & 3;
            out[outPos + 11] = i0 >>> 8 & 3;
            out[outPos + 12] = i0 >>> 6 & 3;
            out[outPos + 13] = i0 >>> 4 & 3;
            out[outPos + 14] = i0 >>> 2 & 3;
            out[outPos + 15] = i0 & 3;
            out[outPos + 16] = i1 >>> 30;
            out[outPos + 17] = i1 >>> 28 & 3;
            out[outPos + 18] = i1 >>> 26 & 3;
            out[outPos + 19] = i1 >>> 24 & 3;
            out[outPos + 20] = i1 >>> 22 & 3;
            out[outPos + 21] = i1 >>> 20 & 3;
            out[outPos + 22] = i1 >>> 18 & 3;
            out[outPos + 23] = i1 >>> 16 & 3;
            out[outPos + 24] = i1 >>> 14 & 3;
            out[outPos + 25] = i1 >>> 12 & 3;
            out[outPos + 26] = i1 >>> 10 & 3;
            out[outPos + 27] = i1 >>> 8 & 3;
            out[outPos + 28] = i1 >>> 6 & 3;
            out[outPos + 29] = i1 >>> 4 & 3;
            out[outPos + 30] = i1 >>> 2 & 3;
            out[outPos + 31] = i1 & 3;
        }
    }

    private static class Bit1Reader
    extends FixedBitIntReader {
        private Bit1Reader(PinotDataBuffer dataBuffer) {
            super(dataBuffer);
        }

        @Override
        public int read(int index) {
            int offset = index >>> 3;
            int bitOffsetInByte = index & 7;
            return this._dataBuffer.getByte(offset) >>> 7 - bitOffsetInByte & 1;
        }

        @Override
        public int readUnchecked(int index) {
            int offset = index >>> 3;
            int bitOffsetInByte = index & 7;
            return this._dataBuffer.getByte(offset) >>> 7 - bitOffsetInByte & 1;
        }

        @Override
        public void read32(int index, int[] out, int outPos) {
            assert (index % 32 == 0);
            int offset = index >>> 3;
            int i0 = this._dataBuffer.getInt(offset);
            out[outPos] = i0 >>> 31;
            out[outPos + 1] = i0 >>> 30 & 1;
            out[outPos + 2] = i0 >>> 29 & 1;
            out[outPos + 3] = i0 >>> 28 & 1;
            out[outPos + 4] = i0 >>> 27 & 1;
            out[outPos + 5] = i0 >>> 26 & 1;
            out[outPos + 6] = i0 >>> 25 & 1;
            out[outPos + 7] = i0 >>> 24 & 1;
            out[outPos + 8] = i0 >>> 23 & 1;
            out[outPos + 9] = i0 >>> 22 & 1;
            out[outPos + 10] = i0 >>> 21 & 1;
            out[outPos + 11] = i0 >>> 20 & 1;
            out[outPos + 12] = i0 >>> 19 & 1;
            out[outPos + 13] = i0 >>> 18 & 1;
            out[outPos + 14] = i0 >>> 17 & 1;
            out[outPos + 15] = i0 >>> 16 & 1;
            out[outPos + 16] = i0 >>> 15 & 1;
            out[outPos + 17] = i0 >>> 14 & 1;
            out[outPos + 18] = i0 >>> 13 & 1;
            out[outPos + 19] = i0 >>> 12 & 1;
            out[outPos + 20] = i0 >>> 11 & 1;
            out[outPos + 21] = i0 >>> 10 & 1;
            out[outPos + 22] = i0 >>> 9 & 1;
            out[outPos + 23] = i0 >>> 8 & 1;
            out[outPos + 24] = i0 >>> 7 & 1;
            out[outPos + 25] = i0 >>> 6 & 1;
            out[outPos + 26] = i0 >>> 5 & 1;
            out[outPos + 27] = i0 >>> 4 & 1;
            out[outPos + 28] = i0 >>> 3 & 1;
            out[outPos + 29] = i0 >>> 2 & 1;
            out[outPos + 30] = i0 >>> 1 & 1;
            out[outPos + 31] = i0 & 1;
        }
    }
}

