/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.xerial.snappy.Snappy;

class SnappyCompressor
implements ChunkCompressor {
    static final SnappyCompressor INSTANCE = new SnappyCompressor();

    private SnappyCompressor() {
    }

    public int compress(ByteBuffer inDecompressed, ByteBuffer outCompressed) throws IOException {
        return Snappy.compress((ByteBuffer)inDecompressed, (ByteBuffer)outCompressed);
    }

    public int maxCompressedSize(int uncompressedSize) {
        return Snappy.maxCompressedLength((int)uncompressedSize);
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.SNAPPY;
    }
}

