/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.data.manager;

import com.google.common.cache.LoadingCache;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.helix.HelixManager;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.restlet.resources.SegmentErrorInfo;
import org.apache.pinot.segment.local.data.manager.SegmentDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.ImmutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

@ThreadSafe
public interface TableDataManager {
    public void init(InstanceDataManagerConfig var1, TableConfig var2, HelixManager var3, @Nullable ExecutorService var4, @Nullable LoadingCache<Pair<String, String>, SegmentErrorInfo> var5);

    public String getInstanceId();

    public InstanceDataManagerConfig getInstanceDataManagerConfig();

    public void start();

    public void shutDown();

    public boolean isShutDown();

    public void addSegment(ImmutableSegment var1);

    public void addSegment(File var1, IndexLoadingConfig var2) throws Exception;

    public void addSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3) throws Exception;

    public void reloadSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3, SegmentMetadata var4, @Nullable Schema var5, boolean var6) throws Exception;

    public void addOrReplaceSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3, @Nullable SegmentMetadata var4) throws Exception;

    public void removeSegment(String var1);

    public boolean tryLoadExistingSegment(String var1, IndexLoadingConfig var2, SegmentZKMetadata var3);

    public File getSegmentDataDir(String var1, @Nullable String var2, TableConfig var3);

    public boolean isSegmentDeletedRecently(String var1);

    public List<SegmentDataManager> acquireAllSegments();

    public List<SegmentDataManager> acquireSegments(List<String> var1, List<String> var2);

    default public List<SegmentDataManager> acquireSegments(List<String> segmentNames, @Nullable List<String> optionalSegmentNames, List<String> missingSegments) {
        return this.acquireSegments(segmentNames, missingSegments);
    }

    @Nullable
    public SegmentDataManager acquireSegment(String var1);

    public void releaseSegment(SegmentDataManager var1);

    public int getNumSegments();

    public String getTableName();

    public File getTableDataDir();

    public void addSegmentError(String var1, SegmentErrorInfo var2);

    public Map<String, SegmentErrorInfo> getSegmentErrors();

    default public void onConsumingToDropped(String segmentNameStr) {
    }

    default public void onConsumingToOnline(String segmentNameStr) {
    }
}

