/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nonnull;
import org.apache.datasketches.theta.SetOperationBuilder;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Union;

public class ThetaSketchAccumulator {
    private ArrayList<Sketch> _accumulator;
    private SetOperationBuilder _setOperationBuilder = new SetOperationBuilder();
    private Union _union;
    private int _threshold;
    private int _numInputs = 0;

    public ThetaSketchAccumulator() {
    }

    public ThetaSketchAccumulator(SetOperationBuilder setOperationBuilder, int threshold) {
        this._setOperationBuilder = setOperationBuilder;
        this._threshold = threshold;
    }

    public void setSetOperationBuilder(SetOperationBuilder setOperationBuilder) {
        this._setOperationBuilder = setOperationBuilder;
    }

    public void setThreshold(int threshold) {
        this._threshold = threshold;
    }

    public boolean isEmpty() {
        return this._numInputs == 0;
    }

    @Nonnull
    public Sketch getResult() {
        return this.unionAll();
    }

    public void apply(Sketch sketch) {
        this.internalAdd(sketch);
    }

    public void merge(ThetaSketchAccumulator thetaUnion) {
        if (thetaUnion.isEmpty()) {
            return;
        }
        Sketch sketch = thetaUnion.getResult();
        this.internalAdd(sketch);
    }

    private void internalAdd(Sketch sketch) {
        if (sketch.isEmpty()) {
            return;
        }
        if (this._accumulator == null) {
            this._accumulator = new ArrayList(this._threshold);
        }
        this._accumulator.add(sketch);
        ++this._numInputs;
        if (this._accumulator.size() >= this._threshold) {
            this.unionAll();
        }
    }

    private Sketch unionAll() {
        if (this._union == null) {
            this._union = this._setOperationBuilder.buildUnion();
        }
        if (this.isEmpty()) {
            return this._union.getResult(false, null);
        }
        if (this._numInputs == 1) {
            return this._accumulator.get(0);
        }
        this._accumulator.sort(Comparator.comparingDouble(Sketch::getTheta));
        for (Sketch accumulatedSketch : this._accumulator) {
            this._union.union(accumulatedSketch);
        }
        this._accumulator.clear();
        return this._union.getResult(false, null);
    }
}

