/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.Union;
import org.apache.datasketches.tuple.aninteger.IntegerSummary;
import org.apache.datasketches.tuple.aninteger.IntegerSummarySetOperations;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class IntegerTupleSketchValueAggregator
implements ValueAggregator<byte[], Sketch<IntegerSummary>> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private int _maxByteSize;
    private final IntegerSummary.Mode _mode;

    public IntegerTupleSketchValueAggregator(IntegerSummary.Mode mode) {
        this._mode = mode;
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTTUPLESKETCH;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    private Sketch<IntegerSummary> union(Sketch<IntegerSummary> a, Sketch<IntegerSummary> b) {
        return new Union((SummarySetOperations)new IntegerSummarySetOperations(this._mode, this._mode)).union(a, b);
    }

    @Override
    public Sketch<IntegerSummary> getInitialAggregatedValue(byte[] rawValue) {
        Sketch<IntegerSummary> initialValue = this.deserializeAggregatedValue(rawValue);
        this._maxByteSize = Math.max(this._maxByteSize, rawValue.length);
        return initialValue;
    }

    @Override
    public Sketch<IntegerSummary> applyRawValue(Sketch<IntegerSummary> value, byte[] rawValue) {
        Sketch<IntegerSummary> right = this.deserializeAggregatedValue(rawValue);
        CompactSketch result = this.union(value, right).compact();
        this._maxByteSize = Math.max(this._maxByteSize, result.toByteArray().length);
        return result;
    }

    @Override
    public Sketch<IntegerSummary> applyAggregatedValue(Sketch<IntegerSummary> value, Sketch<IntegerSummary> aggregatedValue) {
        Sketch<IntegerSummary> result = this.union(value, aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, result.toByteArray().length);
        return result;
    }

    @Override
    public Sketch<IntegerSummary> cloneAggregatedValue(Sketch<IntegerSummary> value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(Sketch<IntegerSummary> value) {
        return CustomSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.serialize(value);
    }

    @Override
    public Sketch<IntegerSummary> deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.DATA_SKETCH_INT_TUPLE_SER_DE.deserialize(bytes);
    }
}

