/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.apache.datasketches.theta.CompactSketch;
import org.apache.datasketches.theta.Sketch;
import org.apache.datasketches.theta.Sketches;
import org.apache.datasketches.theta.Union;
import org.apache.datasketches.theta.UpdateSketch;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountThetaSketchValueAggregator
implements ValueAggregator<Object, Sketch> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final Union _union = Union.builder().setNominalEntries(16384).buildUnion();
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTTHETASKETCH;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    private Sketch singleItemSketch(Object rawValue) {
        UpdateSketch sketch = Sketches.updateSketchBuilder().setNominalEntries(16384).build();
        if (rawValue instanceof String) {
            sketch.update((String)rawValue);
        } else if (rawValue instanceof Integer) {
            sketch.update((long)((Integer)rawValue).intValue());
        } else if (rawValue instanceof Long) {
            sketch.update(((Long)rawValue).longValue());
        } else if (rawValue instanceof Double) {
            sketch.update(((Double)rawValue).doubleValue());
        } else if (rawValue instanceof Float) {
            sketch.update((double)((Float)rawValue).floatValue());
        } else if (rawValue instanceof Object[]) {
            this.addObjectsToSketch((Object[])rawValue, sketch);
        } else {
            throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + rawValue.getClass().getSimpleName());
        }
        return sketch.compact();
    }

    private void addObjectsToSketch(Object[] rawValues, UpdateSketch updateSketch) {
        if (rawValues instanceof String[]) {
            for (String s : (String[])rawValues) {
                updateSketch.update(s);
            }
        } else if (rawValues instanceof Integer[]) {
            for (Integer i : (Integer[])rawValues) {
                updateSketch.update((long)i.intValue());
            }
        } else if (rawValues instanceof Long[]) {
            for (Long l : (Long[])rawValues) {
                updateSketch.update(l.longValue());
            }
        } else if (rawValues instanceof Double[]) {
            for (Double d : (Double[])rawValues) {
                updateSketch.update(d.doubleValue());
            }
        } else if (rawValues instanceof Float[]) {
            for (Float f : (Float[])rawValues) {
                updateSketch.update((double)f.floatValue());
            }
        } else {
            throw new IllegalStateException("Unsupported data type for Theta Sketch aggregation: " + rawValues.getClass().getSimpleName());
        }
    }

    private Sketch union(Sketch left, Sketch right) {
        return this._union.union(left, right);
    }

    private Sketch empty() {
        return Sketches.updateSketchBuilder().setNominalEntries(16384).build().compact();
    }

    @Override
    public Sketch getInitialAggregatedValue(Object rawValue) {
        Sketch initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else if (rawValue instanceof byte[][]) {
            byte[][] serializedSketches = (byte[][])rawValue;
            initialValue = StreamSupport.stream(Arrays.stream(serializedSketches).spliterator(), false).map(this::deserializeAggregatedValue).reduce(this::union).orElseGet(this::empty);
            this._maxByteSize = Math.max(this._maxByteSize, initialValue.getCurrentBytes());
        } else {
            initialValue = this.singleItemSketch(rawValue);
            this._maxByteSize = Math.max(this._maxByteSize, initialValue.getCurrentBytes());
        }
        return initialValue;
    }

    @Override
    public Sketch applyRawValue(Sketch value, Object rawValue) {
        Sketch right = rawValue instanceof byte[] ? this.deserializeAggregatedValue((byte[])rawValue) : this.singleItemSketch(rawValue);
        CompactSketch result = this.union(value, right).compact();
        this._maxByteSize = Math.max(this._maxByteSize, result.getCurrentBytes());
        return result;
    }

    @Override
    public Sketch applyAggregatedValue(Sketch value, Sketch aggregatedValue) {
        Sketch result = this.union(value, aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, result.getCurrentBytes());
        return result;
    }

    @Override
    public Sketch cloneAggregatedValue(Sketch value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(Sketch value) {
        return CustomSerDeUtils.DATA_SKETCH_THETA_SER_DE.serialize(value);
    }

    @Override
    public Sketch deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.DATA_SKETCH_THETA_SER_DE.deserialize(bytes);
    }
}

