/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import java.util.List;
import org.apache.datasketches.cpc.CpcSketch;
import org.apache.datasketches.cpc.CpcUnion;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class DistinctCountCPCSketchValueAggregator
implements ValueAggregator<Object, CpcSketch> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    private final int _lgK;
    private int _maxByteSize;

    public DistinctCountCPCSketchValueAggregator(List<ExpressionContext> arguments) {
        this._lgK = arguments.size() <= 1 ? 12 : arguments.get(1).getLiteral().getIntValue();
    }

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.DISTINCTCOUNTCPCSKETCH;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public CpcSketch getInitialAggregatedValue(Object rawValue) {
        CpcSketch initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else if (rawValue instanceof byte[][]) {
            byte[][] serializedSketches = (byte[][])rawValue;
            CpcUnion union = new CpcUnion(this._lgK);
            for (byte[] bytes : serializedSketches) {
                union.update(this.deserializeAggregatedValue(bytes));
            }
            initialValue = union.getResult();
            this.updateMaxByteSize(initialValue);
        } else {
            initialValue = this.empty();
            this.addObjectToSketch(rawValue, initialValue);
            this.updateMaxByteSize(initialValue);
        }
        return initialValue;
    }

    @Override
    public CpcSketch applyRawValue(CpcSketch value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            CpcSketch sketch = this.union(value, this.deserializeAggregatedValue(bytes));
            this.updateMaxByteSize(sketch);
            return sketch;
        }
        this.addObjectToSketch(rawValue, value);
        this.updateMaxByteSize(value);
        return value;
    }

    @Override
    public CpcSketch applyAggregatedValue(CpcSketch value, CpcSketch aggregatedValue) {
        CpcSketch result = this.union(value, aggregatedValue);
        this.updateMaxByteSize(result);
        return result;
    }

    @Override
    public CpcSketch cloneAggregatedValue(CpcSketch value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize > 0 ? this._maxByteSize : CpcSketch.getMaxSerializedBytes((int)this._lgK);
    }

    @Override
    public byte[] serializeAggregatedValue(CpcSketch value) {
        return CustomSerDeUtils.DATA_SKETCH_CPC_SER_DE.serialize(value);
    }

    @Override
    public CpcSketch deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.DATA_SKETCH_CPC_SER_DE.deserialize(bytes);
    }

    private CpcSketch union(CpcSketch left, CpcSketch right) {
        if (left == null && right == null) {
            return this.empty();
        }
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        CpcUnion union = new CpcUnion(this._lgK);
        union.update(left);
        union.update(right);
        return union.getResult();
    }

    private void addObjectToSketch(Object rawValue, CpcSketch sketch) {
        if (rawValue instanceof String) {
            sketch.update((String)rawValue);
        } else if (rawValue instanceof Integer) {
            sketch.update((long)((Integer)rawValue).intValue());
        } else if (rawValue instanceof Long) {
            sketch.update(((Long)rawValue).longValue());
        } else if (rawValue instanceof Double) {
            sketch.update(((Double)rawValue).doubleValue());
        } else if (rawValue instanceof Float) {
            sketch.update((double)((Float)rawValue).floatValue());
        } else if (rawValue instanceof Object[]) {
            this.addObjectsToSketch((Object[])rawValue, sketch);
        } else {
            throw new IllegalStateException("Unsupported data type for CPC Sketch aggregation: " + rawValue.getClass().getSimpleName());
        }
    }

    private void addObjectsToSketch(Object[] rawValues, CpcSketch sketch) {
        if (rawValues instanceof String[]) {
            for (String s : (String[])rawValues) {
                sketch.update(s);
            }
        } else if (rawValues instanceof Integer[]) {
            for (Integer i : (Integer[])rawValues) {
                sketch.update((long)i.intValue());
            }
        } else if (rawValues instanceof Long[]) {
            for (Long l : (Long[])rawValues) {
                sketch.update(l.longValue());
            }
        } else if (rawValues instanceof Double[]) {
            for (Double d : (Double[])rawValues) {
                sketch.update(d.doubleValue());
            }
        } else if (rawValues instanceof Float[]) {
            for (Float f : (Float[])rawValues) {
                sketch.update((double)f.floatValue());
            }
        } else {
            throw new IllegalStateException("Unsupported data type for CPC Sketch aggregation: " + rawValues.getClass().getSimpleName());
        }
    }

    private void updateMaxByteSize(CpcSketch sketch) {
        if (sketch != null) {
            this._maxByteSize = Math.max(this._maxByteSize, sketch.toByteArray().length);
        }
    }

    private CpcSketch empty() {
        return new CpcSketch(this._lgK);
    }
}

