/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.utils;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.CharacterRunAutomaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.RegExp;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableArc;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFST;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableState;
import org.roaringbitmap.IntConsumer;

public class RealTimeRegexpMatcher {
    private final String _regexQuery;
    private final MutableFST _fst;
    private final Automaton _automaton;
    private final IntConsumer _dest;

    public RealTimeRegexpMatcher(String regexQuery, MutableFST fst, IntConsumer dest) {
        this._regexQuery = regexQuery;
        this._fst = fst;
        this._dest = dest;
        this._automaton = new RegExp(this._regexQuery).toAutomaton();
    }

    public static void regexMatch(String regexQuery, MutableFST fst, IntConsumer dest) {
        RealTimeRegexpMatcher matcher = new RealTimeRegexpMatcher(regexQuery, fst, dest);
        matcher.regexMatchOnFST();
    }

    public boolean match(String input) {
        CharacterRunAutomaton characterRunAutomaton = new CharacterRunAutomaton(this._automaton);
        return characterRunAutomaton.run(input);
    }

    public void regexMatchOnFST() {
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        if (this._automaton.getNumberOfStates() == 0) {
            return;
        }
        queue.add(new Path(this._automaton.getInitialState(), this._fst.getStartState(), null, new ArrayList<Character>()));
        Set<State> acceptStates = this._automaton.getAcceptStates();
        while (!queue.isEmpty()) {
            Path path = (Path)queue.remove();
            if (acceptStates.contains(path._state) && path._node.isTerminal()) {
                this._dest.accept(path._fstArc.getOutputSymbol());
            }
            Set<Transition> stateTransitions = path._state.getTransitionSet();
            for (Transition t : stateTransitions) {
                char min = t._min;
                char max = t._max;
                if (min == max) {
                    MutableArc arc = this.getArcForLabel(path._node, t._min);
                    if (arc == null) continue;
                    queue.add(new Path(t._to, arc.getNextState(), arc, path._pathState));
                    continue;
                }
                List<MutableArc> arcs = path._node.getArcs();
                for (MutableArc arc : arcs) {
                    char label = arc.getNextState().getLabel();
                    if (label < min || label > max) continue;
                    queue.add(new Path(t._to, arc.getNextState(), arc, path._pathState));
                }
            }
        }
    }

    private MutableArc getArcForLabel(MutableState mutableState, char label) {
        List<MutableArc> arcs = mutableState.getArcs();
        for (MutableArc arc : arcs) {
            if (arc.getNextState().getLabel() != label) continue;
            return arc;
        }
        return null;
    }

    public final class Path {
        public final State _state;
        public final MutableState _node;
        public final MutableArc _fstArc;
        public List<Character> _pathState;

        public Path(State state, MutableState node, MutableArc fstArc, List<Character> pathState) {
            this._state = state;
            this._node = node;
            this._fstArc = fstArc;
            this._pathState = pathState;
            this._pathState.add(Character.valueOf(node.getLabel()));
        }
    }
}

