/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.mutablefst.utils;

import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableArc;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFST;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableState;
import org.apache.pinot.segment.local.utils.nativefst.utils.RealTimeRegexpMatcher;
import org.roaringbitmap.RoaringBitmapWriter;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class MutableFSTUtils {
    private MutableFSTUtils() {
    }

    public static boolean fstEquals(Object thisFstObj, Object thatFstObj) {
        if (thisFstObj == thatFstObj) {
            return true;
        }
        if (thisFstObj instanceof MutableFST && thatFstObj instanceof MutableFST) {
            MutableFST thisFST = (MutableFST)thisFstObj;
            MutableFST thatFST = (MutableFST)thatFstObj;
            return thisFST.getStartState().getLabel() == thatFST.getStartState().getLabel() && thisFST.getStartState().getArcs().size() == thatFST.getStartState().getArcs().size();
        }
        return false;
    }

    public static boolean arcEquals(Object thisArcObj, Object thatArcObj) {
        if (thisArcObj == thatArcObj) {
            return true;
        }
        if (thisArcObj instanceof MutableArc && thatArcObj instanceof MutableArc) {
            MutableArc thisArc = (MutableArc)thisArcObj;
            MutableArc thatArc = (MutableArc)thatArcObj;
            return thisArc.getNextState().getLabel() == thatArc.getNextState().getLabel() && thisArc.getNextState().getArcs().size() == thatArc.getNextState().getArcs().size();
        }
        return false;
    }

    public static boolean stateEquals(Object thisStateObj, Object thatStateObj) {
        if (thisStateObj == thatStateObj) {
            return true;
        }
        if (thisStateObj instanceof MutableState && thatStateObj instanceof MutableState) {
            MutableState thisState = (MutableState)thisStateObj;
            MutableState thatState = (MutableState)thatStateObj;
            return thisState.getLabel() == thatState.getLabel() && thisState.getArcs().size() == thatState.getArcs().size();
        }
        return false;
    }

    public static long regexQueryNrHitsForRealTimeFST(String regex, MutableFST fst) {
        RoaringBitmapWriter writer = RoaringBitmapWriter.bufferWriter().get();
        RealTimeRegexpMatcher.regexMatch(regex, fst, arg_0 -> ((RoaringBitmapWriter)writer).add(arg_0));
        return ((MutableRoaringBitmap)writer.get()).getCardinality();
    }
}

