/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Automaton;
import org.apache.pinot.segment.local.utils.nativefst.automaton.BasicAutomata;
import org.apache.pinot.segment.local.utils.nativefst.automaton.State;
import org.apache.pinot.segment.local.utils.nativefst.automaton.StatePair;
import org.apache.pinot.segment.local.utils.nativefst.automaton.Transition;

public final class SpecialOperations {
    private SpecialOperations() {
    }

    public static Set<State> reverse(Automaton a) {
        HashMap m = new HashMap();
        Set<State> states = a.getStates();
        Set<State> accept = a.getAcceptStates();
        for (State r : states) {
            m.put(r, new HashSet());
            r._accept = false;
        }
        for (State r : states) {
            for (Transition t : r.getTransitionSet()) {
                ((HashSet)m.get(t._to)).add(new Transition(t._min, t._max, r));
            }
        }
        for (State r : states) {
            r._transitionSet = (Set)m.get(r);
        }
        a._initial._accept = true;
        a._initial = new State();
        for (State r : accept) {
            a._initial.addEpsilon(r);
        }
        a._deterministic = false;
        return accept;
    }

    public static Automaton overlap(Automaton a1, Automaton a2) {
        Automaton b1 = a1.cloneExpanded();
        b1.determinize();
        SpecialOperations.acceptToAccept(b1);
        Automaton b2 = a2.cloneExpanded();
        SpecialOperations.reverse(b2);
        b2.determinize();
        SpecialOperations.acceptToAccept(b2);
        SpecialOperations.reverse(b2);
        b2.determinize();
        return b1.intersection(b2).minus(BasicAutomata.makeEmptyString());
    }

    private static void acceptToAccept(Automaton a) {
        State s = new State();
        for (State r : a.getAcceptStates()) {
            s.addEpsilon(r);
        }
        a._initial = s;
        a._deterministic = false;
    }

    public static Automaton trim(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        State f = new State();
        SpecialOperations.addSetTransitions(f, set, f);
        f._accept = true;
        for (State s : a.getStates()) {
            State r = s.step(c);
            if (r != null) {
                State q = new State();
                SpecialOperations.addSetTransitions(q, set, q);
                SpecialOperations.addSetTransitions(s, set, q);
                q.addEpsilon(r);
            }
            if (!s._accept) continue;
            s.addEpsilon(f);
        }
        State p = new State();
        SpecialOperations.addSetTransitions(p, set, p);
        p.addEpsilon(a._initial);
        a._initial = p;
        a._deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    private static void addSetTransitions(State s, String set, State p) {
        for (int n = 0; n < set.length(); ++n) {
            s._transitionSet.add(new Transition(set.charAt(n), p));
        }
    }

    public static Automaton compress(Automaton a, String set, char c) {
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            State r = s.step(c);
            if (r == null) continue;
            State q = new State();
            SpecialOperations.addSetTransitions(q, set, q);
            SpecialOperations.addSetTransitions(s, set, q);
            q.addEpsilon(r);
        }
        a._deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static Automaton subst(Automaton a, Map<Character, Set<Character>> map) {
        if (map.isEmpty()) {
            return a.cloneIfRequired();
        }
        TreeSet<Character> ckeys = new TreeSet<Character>(map.keySet());
        char[] keys = new char[ckeys.size()];
        int j = 0;
        for (Character c : ckeys) {
            keys[j++] = c.charValue();
        }
        a = a.cloneExpandedIfRequired();
        for (State s : a.getStates()) {
            Set<Transition> st = s._transitionSet;
            s.resetTransitions();
            block2: for (Transition t : st) {
                int index = SpecialOperations.findIndex(t._min, keys);
                while (t._min <= t._max) {
                    if (keys[index] > t._min) {
                        char m = (char)(keys[index] - '\u0001');
                        if (t._max < m) {
                            m = t._max;
                        }
                        s._transitionSet.add(new Transition(t._min, m, t._to));
                        if (m + '\u0001' > 65535) continue block2;
                        t._min = (char)(m + '\u0001');
                        continue;
                    }
                    if (keys[index] < t._min) {
                        char m = index + 1 < keys.length ? (char)(keys[++index] - '\u0001') : (char)'\uffff';
                        if (t._max < m) {
                            m = t._max;
                        }
                        s._transitionSet.add(new Transition(t._min, m, t._to));
                        if (m + '\u0001' > 65535) continue block2;
                        t._min = (char)(m + '\u0001');
                        continue;
                    }
                    for (Character c : map.get(Character.valueOf(t._min))) {
                        s._transitionSet.add(new Transition(c.charValue(), t._to));
                    }
                    if (t._min + '\u0001' > 65535) continue block2;
                    t._min = (char)(t._min + '\u0001');
                    if (index + 1 >= keys.length || keys[index + 1] != t._min) continue;
                    ++index;
                }
            }
        }
        a._deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    static int findIndex(char c, char[] points) {
        int a = 0;
        int b = points.length;
        while (b - a > 1) {
            int d = a + b >>> 1;
            if (points[d] > c) {
                b = d;
                continue;
            }
            if (points[d] < c) {
                a = d;
                continue;
            }
            return d;
        }
        return a;
    }

    public static Automaton subst(Automaton a, char c, String s) {
        a = a.cloneExpandedIfRequired();
        HashSet<StatePair> epsilons = new HashSet<StatePair>();
        for (State p : a.getStates()) {
            Set<Transition> st = p._transitionSet;
            p.resetTransitions();
            for (Transition t : st) {
                if (t._max < c || t._min > c) {
                    p._transitionSet.add(t);
                    continue;
                }
                if (t._min < c) {
                    p._transitionSet.add(new Transition(t._min, (char)(c - '\u0001'), t._to));
                }
                if (t._max > c) {
                    p._transitionSet.add(new Transition((char)(c + '\u0001'), t._max, t._to));
                }
                if (s.length() == 0) {
                    epsilons.add(new StatePair(p, t._to));
                    continue;
                }
                State q = p;
                for (int i = 0; i < s.length(); ++i) {
                    State r = i + 1 == s.length() ? t._to : new State();
                    q._transitionSet.add(new Transition(s.charAt(i), r));
                    q = r;
                }
            }
        }
        a.addEpsilons(epsilons);
        a._deterministic = false;
        a.removeDeadTransitions();
        a.checkMinimizeAlways();
        return a;
    }

    public static boolean isFinite(Automaton a) {
        if (a.isSingleton()) {
            return true;
        }
        return SpecialOperations.isFinite(a._initial, new HashSet<State>(), new HashSet<State>());
    }

    private static boolean isFinite(State s, HashSet<State> path, HashSet<State> visited) {
        path.add(s);
        for (Transition t : s._transitionSet) {
            if (!path.contains(t._to) && (visited.contains(t._to) || SpecialOperations.isFinite(t._to, path, visited))) continue;
            return false;
        }
        path.remove(s);
        visited.add(s);
        return true;
    }

    public static String getCommonPrefix(Automaton a) {
        boolean done;
        if (a.isSingleton()) {
            return a._singleton;
        }
        StringBuilder b = new StringBuilder();
        HashSet<State> visited = new HashSet<State>();
        State s = a._initial;
        do {
            done = true;
            visited.add(s);
            if (s._accept || s._transitionSet.size() != 1) continue;
            Transition t = s._transitionSet.iterator().next();
            if (t._min != t._max || visited.contains(t._to)) continue;
            b.append(t._min);
            s = t._to;
            done = false;
        } while (!done);
        return b.toString();
    }
}

