/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.automaton;

import java.util.regex.MatchResult;
import org.apache.pinot.segment.local.utils.nativefst.automaton.RunAutomaton;

public class AutomatonMatcher
implements MatchResult {
    private final RunAutomaton _automaton;
    private final CharSequence _chars;
    private int _matchStart = -1;
    private int _matchEnd = -1;

    AutomatonMatcher(CharSequence chars, RunAutomaton automaton) {
        this._chars = chars;
        this._automaton = automaton;
    }

    private static void onlyZero(int group) throws IndexOutOfBoundsException {
        if (group != 0) {
            throw new IndexOutOfBoundsException("The only group supported is 0.");
        }
    }

    public boolean find() {
        int matchEnd;
        int matchStart;
        int begin;
        switch (this.getMatchStart()) {
            case -2: {
                return false;
            }
            case -1: {
                begin = 0;
                break;
            }
            default: {
                begin = this.getMatchEnd();
                if (begin != this.getMatchStart() || ++begin <= this.getChars().length()) break;
                this.setMatch(-2, -2);
                return false;
            }
        }
        if (this._automaton.isAccept(this._automaton.getInitialState())) {
            matchStart = begin;
            matchEnd = begin;
        } else {
            matchStart = -1;
            matchEnd = -1;
        }
        int l = this.getChars().length();
        while (begin < l) {
            int newState;
            int p = this._automaton.getInitialState();
            for (int i = begin; i < l && (newState = this._automaton.step(p, this.getChars().charAt(i))) != -1; ++i) {
                if (this._automaton.isAccept(newState)) {
                    matchStart = begin;
                    matchEnd = i + 1;
                }
                p = newState;
            }
            if (matchStart != -1) {
                this.setMatch(matchStart, matchEnd);
                return true;
            }
            ++begin;
        }
        if (matchStart != -1) {
            this.setMatch(matchStart, matchEnd);
            return true;
        }
        this.setMatch(-2, -2);
        return false;
    }

    private void setMatch(int matchStart, int matchEnd) throws IllegalArgumentException {
        if (matchStart > matchEnd) {
            throw new IllegalArgumentException("Start must be less than or equal to end: " + matchStart + ", " + matchEnd);
        }
        this._matchStart = matchStart;
        this._matchEnd = matchEnd;
    }

    private int getMatchStart() {
        return this._matchStart;
    }

    private int getMatchEnd() {
        return this._matchEnd;
    }

    private CharSequence getChars() {
        return this._chars;
    }

    @Override
    public int end() throws IllegalStateException {
        this.matchGood();
        return this._matchEnd;
    }

    @Override
    public int end(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.end();
    }

    @Override
    public String group() throws IllegalStateException {
        this.matchGood();
        return this._chars.subSequence(this._matchStart, this._matchEnd).toString();
    }

    @Override
    public String group(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.group();
    }

    @Override
    public int groupCount() {
        return 0;
    }

    @Override
    public int start() throws IllegalStateException {
        this.matchGood();
        return this._matchStart;
    }

    @Override
    public int start(int group) throws IndexOutOfBoundsException, IllegalStateException {
        AutomatonMatcher.onlyZero(group);
        return this.start();
    }

    private void matchGood() throws IllegalStateException {
        if (this._matchStart < 0 || this._matchEnd < 0) {
            throw new IllegalStateException("There was no available match.");
        }
    }
}

