/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils;

public enum GeometryType {
    POINT(false, 0, "ST_Point"),
    MULTI_POINT(true, 1, "ST_MultiPoint"),
    LINE_STRING(false, 2, "ST_LineString"),
    MULTI_LINE_STRING(true, 3, "ST_MultiLineString"),
    POLYGON(false, 4, "ST_Polygon"),
    MULTI_POLYGON(true, 5, "ST_MultiPolygon"),
    GEOMETRY_COLLECTION(true, 6, "ST_GeomCollection");

    private static final GeometryType[] ID_TO_TYPE_MAP;
    private final boolean _multiType;
    private final int _id;
    private final String _name;

    private GeometryType(boolean multiType, int id, String name) {
        this._multiType = multiType;
        this._id = id;
        this._name = name;
    }

    public boolean isMultiType() {
        return this._multiType;
    }

    public String getName() {
        return this._name;
    }

    public int id() {
        return this._id;
    }

    public static GeometryType fromID(int id) {
        if (id > ID_TO_TYPE_MAP.length) {
            throw new IllegalArgumentException("Invalid type id: " + id);
        }
        return ID_TO_TYPE_MAP[id];
    }

    static {
        ID_TO_TYPE_MAP = new GeometryType[]{POINT, MULTI_POINT, LINE_STRING, MULTI_LINE_STRING, POLYGON, MULTI_POLYGON, GEOMETRY_COLLECTION};
    }
}

