/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.upsert.ComparisonColumns;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class UpsertUtils {
    private UpsertUtils() {
    }

    public static Iterator<RecordInfo> getRecordInfoIterator(final RecordInfoReader recordInfoReader, final int numDocs) {
        return new Iterator<RecordInfo>(){
            private int _docId = 0;

            @Override
            public boolean hasNext() {
                return this._docId < numDocs;
            }

            @Override
            public RecordInfo next() {
                return recordInfoReader.getRecordInfo(this._docId++);
            }
        };
    }

    public static Iterator<RecordInfo> getRecordInfoIterator(final RecordInfoReader recordInfoReader, final MutableRoaringBitmap validDocIds) {
        return new Iterator<RecordInfo>(){
            private final PeekableIntIterator _docIdIterator;
            {
                this._docIdIterator = validDocIds.getIntIterator();
            }

            @Override
            public boolean hasNext() {
                return this._docIdIterator.hasNext();
            }

            @Override
            public RecordInfo next() {
                return recordInfoReader.getRecordInfo(this._docIdIterator.next());
            }
        };
    }

    static Object getValue(PinotSegmentColumnReader columnReader, int docId) {
        Object value = columnReader.getValue(docId);
        return value instanceof byte[] ? new ByteArray((byte[])value) : value;
    }

    public static class MultiComparisonColumnReader
    implements ComparisonColumnReader {
        private final PinotSegmentColumnReader[] _comparisonColumnReaders;

        public MultiComparisonColumnReader(IndexSegment segment, List<String> comparisonColumns) {
            this._comparisonColumnReaders = new PinotSegmentColumnReader[comparisonColumns.size()];
            for (int i = 0; i < comparisonColumns.size(); ++i) {
                this._comparisonColumnReaders[i] = new PinotSegmentColumnReader(segment, comparisonColumns.get(i));
            }
        }

        @Override
        public Comparable getComparisonValue(int docId) {
            Comparable[] comparisonColumns = new Comparable[this._comparisonColumnReaders.length];
            for (int i = 0; i < this._comparisonColumnReaders.length; ++i) {
                PinotSegmentColumnReader columnReader = this._comparisonColumnReaders[i];
                Comparable comparisonValue = null;
                if (!columnReader.isNull(docId)) {
                    comparisonValue = (Comparable)UpsertUtils.getValue(columnReader, docId);
                }
                comparisonColumns[i] = comparisonValue;
            }
            return new ComparisonColumns(comparisonColumns, -1);
        }

        @Override
        public void close() throws IOException {
            for (PinotSegmentColumnReader comparisonColumnReader : this._comparisonColumnReaders) {
                comparisonColumnReader.close();
            }
        }
    }

    public static class SingleComparisonColumnReader
    implements ComparisonColumnReader {
        private final PinotSegmentColumnReader _comparisonColumnReader;

        public SingleComparisonColumnReader(IndexSegment segment, String comparisonColumn) {
            this._comparisonColumnReader = new PinotSegmentColumnReader(segment, comparisonColumn);
        }

        @Override
        public Comparable getComparisonValue(int docId) {
            return (Comparable)this._comparisonColumnReader.getValue(docId);
        }

        @Override
        public void close() throws IOException {
            this._comparisonColumnReader.close();
        }
    }

    public static interface ComparisonColumnReader
    extends Closeable {
        public Comparable getComparisonValue(int var1);
    }

    public static class PrimaryKeyReader
    implements Closeable {
        public final List<PinotSegmentColumnReader> _primaryKeyColumnReaders;

        public PrimaryKeyReader(IndexSegment segment, List<String> primaryKeyColumns) {
            this._primaryKeyColumnReaders = new ArrayList<PinotSegmentColumnReader>(primaryKeyColumns.size());
            for (String primaryKeyColumn : primaryKeyColumns) {
                this._primaryKeyColumnReaders.add(new PinotSegmentColumnReader(segment, primaryKeyColumn));
            }
        }

        public PrimaryKey getPrimaryKey(int docId) {
            int numPrimaryKeys = this._primaryKeyColumnReaders.size();
            Object[] values = new Object[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                values[i] = UpsertUtils.getValue(this._primaryKeyColumnReaders.get(i), docId);
            }
            return new PrimaryKey(values);
        }

        public void getPrimaryKey(int docId, PrimaryKey buffer) {
            Object[] values = buffer.getValues();
            int numPrimaryKeys = values.length;
            for (int i = 0; i < numPrimaryKeys; ++i) {
                values[i] = UpsertUtils.getValue(this._primaryKeyColumnReaders.get(i), docId);
            }
        }

        @Override
        public void close() throws IOException {
            for (PinotSegmentColumnReader primaryKeyColumnReader : this._primaryKeyColumnReaders) {
                primaryKeyColumnReader.close();
            }
        }
    }

    public static class RecordInfoReader
    implements Closeable {
        private final PrimaryKeyReader _primaryKeyReader;
        private final ComparisonColumnReader _comparisonColumnReader;
        private final PinotSegmentColumnReader _deleteRecordColumnReader;

        public RecordInfoReader(IndexSegment segment, List<String> primaryKeyColumns, List<String> comparisonColumns, @Nullable String deleteRecordColumn) {
            this._primaryKeyReader = new PrimaryKeyReader(segment, primaryKeyColumns);
            this._comparisonColumnReader = comparisonColumns.size() == 1 ? new SingleComparisonColumnReader(segment, comparisonColumns.get(0)) : new MultiComparisonColumnReader(segment, comparisonColumns);
            this._deleteRecordColumnReader = deleteRecordColumn != null ? new PinotSegmentColumnReader(segment, deleteRecordColumn) : null;
        }

        public RecordInfo getRecordInfo(int docId) {
            PrimaryKey primaryKey = this._primaryKeyReader.getPrimaryKey(docId);
            Comparable comparisonValue = this._comparisonColumnReader.getComparisonValue(docId);
            boolean deleteRecord = this._deleteRecordColumnReader != null && BooleanUtils.toBoolean((Object)this._deleteRecordColumnReader.getValue(docId));
            return new RecordInfo(primaryKey, docId, comparisonValue, deleteRecord);
        }

        @Override
        public void close() throws IOException {
            this._primaryKeyReader.close();
            this._comparisonColumnReader.close();
        }
    }
}

