/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.collections.CollectionUtils;
import org.apache.helix.HelixManager;
import org.apache.helix.model.IdealState;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.metadata.ZKMetadataProvider;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.common.metrics.ServerMetrics;
import org.apache.pinot.common.utils.helix.HelixHelper;
import org.apache.pinot.segment.local.data.manager.TableDataManager;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.upsert.PartialUpsertHandler;
import org.apache.pinot.segment.local.upsert.TableUpsertMetadataManager;
import org.apache.pinot.segment.local.utils.SegmentLocks;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.HashFunction;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class BaseTableUpsertMetadataManager
implements TableUpsertMetadataManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseTableUpsertMetadataManager.class);
    protected TableConfig _tableConfig;
    protected Schema _schema;
    protected TableDataManager _tableDataManager;
    protected String _tableNameWithType;
    protected List<String> _primaryKeyColumns;
    protected List<String> _comparisonColumns;
    protected String _deleteRecordColumn;
    protected HashFunction _hashFunction;
    protected PartialUpsertHandler _partialUpsertHandler;
    protected boolean _enableSnapshot;
    protected double _metadataTTL;
    protected File _tableIndexDir;
    protected ServerMetrics _serverMetrics;
    protected HelixManager _helixManager;
    protected ExecutorService _segmentPreloadExecutor;
    private volatile boolean _isPreloading = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(TableConfig tableConfig, Schema schema, TableDataManager tableDataManager, ServerMetrics serverMetrics, HelixManager helixManager, @Nullable ExecutorService segmentPreloadExecutor) {
        this._tableConfig = tableConfig;
        this._schema = schema;
        this._tableDataManager = tableDataManager;
        this._tableNameWithType = tableConfig.getTableName();
        UpsertConfig upsertConfig = tableConfig.getUpsertConfig();
        Preconditions.checkArgument((upsertConfig != null && upsertConfig.getMode() != UpsertConfig.Mode.NONE ? 1 : 0) != 0, (String)"Upsert must be enabled for table: %s", (Object)this._tableNameWithType);
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        Preconditions.checkArgument((!CollectionUtils.isEmpty(this._primaryKeyColumns) ? 1 : 0) != 0, (String)"Primary key columns must be configured for upsert enabled table: %s", (Object)this._tableNameWithType);
        this._comparisonColumns = upsertConfig.getComparisonColumns();
        if (this._comparisonColumns == null) {
            this._comparisonColumns = Collections.singletonList(tableConfig.getValidationConfig().getTimeColumnName());
        }
        this._deleteRecordColumn = upsertConfig.getDeleteRecordColumn();
        this._hashFunction = upsertConfig.getHashFunction();
        if (upsertConfig.getMode() == UpsertConfig.Mode.PARTIAL) {
            Map partialUpsertStrategies = upsertConfig.getPartialUpsertStrategies();
            Preconditions.checkArgument((partialUpsertStrategies != null ? 1 : 0) != 0, (String)"Partial-upsert strategies must be configured for partial-upsert enabled table: %s", (Object)this._tableNameWithType);
            this._partialUpsertHandler = new PartialUpsertHandler(schema, partialUpsertStrategies, upsertConfig.getDefaultPartialUpsertStrategy(), this._comparisonColumns);
        }
        this._enableSnapshot = upsertConfig.isEnableSnapshot();
        this._metadataTTL = upsertConfig.getMetadataTTL();
        this._tableIndexDir = tableDataManager.getTableDataDir();
        this._serverMetrics = serverMetrics;
        this._helixManager = helixManager;
        this._segmentPreloadExecutor = segmentPreloadExecutor;
        this.initCustomVariables();
        if (this._enableSnapshot && segmentPreloadExecutor != null && upsertConfig.isEnablePreload()) {
            try {
                this._isPreloading = true;
                this.preloadSegments();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to preload segments from table: {}, skipping", (Object)this._tableNameWithType, (Object)e);
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                this._isPreloading = false;
            }
        }
    }

    protected void initCustomVariables() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadSegments() throws Exception {
        LOGGER.info("Preload segments from table: {} for fast upsert metadata recovery", (Object)this._tableNameWithType);
        this.onPreloadStart();
        IdealState idealState = HelixHelper.getTableIdealState((HelixManager)this._helixManager, (String)this._tableNameWithType);
        ZkHelixPropertyStore propertyStore = this._helixManager.getHelixPropertyStore();
        String instanceId = this.getInstanceId();
        IndexLoadingConfig indexLoadingConfig = this.createIndexLoadingConfig();
        ArrayList futures = new ArrayList();
        for (String string : idealState.getPartitionSet()) {
            Map instanceStateMap = idealState.getInstanceStateMap(string);
            String state = (String)instanceStateMap.get(instanceId);
            if (!"ONLINE".equals(state)) {
                LOGGER.info("Skip segment: {} as its ideal state: {} is not ONLINE", (Object)string, (Object)state);
                continue;
            }
            futures.add(this._segmentPreloadExecutor.submit(() -> {
                try {
                    this.preloadSegment(segmentName, indexLoadingConfig, (ZkHelixPropertyStore<ZNRecord>)propertyStore);
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to preload segment: {} from table: {}, skipping", new Object[]{segmentName, this._tableNameWithType, e});
                }
            }));
        }
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        finally {
            for (Future future : futures) {
                if (future.isDone()) continue;
                future.cancel(true);
            }
        }
        this.onPreloadFinish();
        LOGGER.info("Preloaded segments from table: {} for fast upsert metadata recovery", (Object)this._tableNameWithType);
    }

    protected void onPreloadStart() {
    }

    protected void onPreloadFinish() {
    }

    private String getInstanceId() {
        InstanceDataManagerConfig instanceDataManagerConfig = this._tableDataManager.getTableDataManagerConfig().getInstanceDataManagerConfig();
        return instanceDataManagerConfig.getInstanceId();
    }

    @VisibleForTesting
    protected IndexLoadingConfig createIndexLoadingConfig() {
        return new IndexLoadingConfig(this._tableDataManager.getTableDataManagerConfig().getInstanceDataManagerConfig(), this._tableConfig, this._schema);
    }

    private void preloadSegment(String segmentName, IndexLoadingConfig indexLoadingConfig, ZkHelixPropertyStore<ZNRecord> propertyStore) {
        LOGGER.info("Preload segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
        SegmentZKMetadata zkMetadata = ZKMetadataProvider.getSegmentZKMetadata(propertyStore, (String)this._tableNameWithType, (String)segmentName);
        Preconditions.checkState((zkMetadata != null ? 1 : 0) != 0, (String)"Failed to find ZK metadata for segment: %s, table: %s", (Object)segmentName, (Object)this._tableNameWithType);
        File snapshotFile = this.getValidDocIdsSnapshotFile(segmentName, zkMetadata.getTier());
        if (!snapshotFile.exists()) {
            LOGGER.info("Skip segment: {} as no validDocIds snapshot at: {}", (Object)segmentName, (Object)snapshotFile);
            return;
        }
        this.preloadSegmentWithSnapshot(segmentName, indexLoadingConfig, zkMetadata);
        LOGGER.info("Preloaded segment: {} from table: {}", (Object)segmentName, (Object)this._tableNameWithType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    protected void preloadSegmentWithSnapshot(String segmentName, IndexLoadingConfig indexLoadingConfig, SegmentZKMetadata zkMetadata) {
        Lock segmentLock = SegmentLocks.getSegmentLock(this._tableNameWithType, segmentName);
        try {
            segmentLock.lock();
            this._tableDataManager.tryLoadExistingSegment(segmentName, indexLoadingConfig, zkMetadata);
        }
        finally {
            segmentLock.unlock();
        }
    }

    private File getValidDocIdsSnapshotFile(String segmentName, String segmentTier) {
        File indexDir = this._tableDataManager.getSegmentDataDir(segmentName, segmentTier, this._tableConfig);
        return new File(SegmentDirectoryPaths.findSegmentDirectory((File)indexDir), "validdocids.bitmap.snapshot");
    }

    @Override
    public boolean isPreloading() {
        return this._isPreloading;
    }

    @Override
    public UpsertConfig.Mode getUpsertMode() {
        return this._partialUpsertHandler == null ? UpsertConfig.Mode.FULL : UpsertConfig.Mode.PARTIAL;
    }
}

