/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.forward.BaseChunkForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedByteChunkMVForwardIndexReader
extends BaseChunkForwardIndexReader {
    private static final int ROW_OFFSET_SIZE = 4;
    private final int _maxChunkSize;

    public FixedByteChunkMVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType storedType) {
        super(dataBuffer, storedType, false);
        this._maxChunkSize = this._numDocsPerChunk * (4 + this._lengthOfLongestEntry);
    }

    @Nullable
    public ChunkReaderContext createContext() {
        if (this._isCompressed) {
            return new ChunkReaderContext(this._maxChunkSize);
        }
        return null;
    }

    public int getIntMV(int docId, int[] valueBuffer, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getInt();
        }
        return numValues;
    }

    public int[] getIntMV(int docId, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        int[] valueBuffer = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getInt();
        }
        return valueBuffer;
    }

    public int getLongMV(int docId, long[] valueBuffer, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getLong();
        }
        return numValues;
    }

    public long[] getLongMV(int docId, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        long[] valueBuffer = new long[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getLong();
        }
        return valueBuffer;
    }

    public int getFloatMV(int docId, float[] valueBuffer, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getFloat();
        }
        return numValues;
    }

    public float[] getFloatMV(int docId, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        float[] valueBuffer = new float[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getFloat();
        }
        return valueBuffer;
    }

    public int getDoubleMV(int docId, double[] valueBuffer, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getDouble();
        }
        return numValues;
    }

    public double[] getDoubleMV(int docId, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        int numValues = byteBuffer.getInt();
        double[] valueBuffer = new double[numValues];
        for (int i = 0; i < numValues; ++i) {
            valueBuffer[i] = byteBuffer.getDouble();
        }
        return valueBuffer;
    }

    public int getNumValuesMV(int docId, ChunkReaderContext context) {
        ByteBuffer byteBuffer = this.slice(docId, context);
        return byteBuffer.getInt();
    }

    private ByteBuffer slice(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            return this.sliceBytesCompressed(docId, context);
        }
        return this.sliceBytesUncompressed(docId);
    }

    private ByteBuffer sliceBytesCompressed(int docId, ChunkReaderContext context) {
        int chunkRowId = docId % this._numDocsPerChunk;
        ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
        int valueStartOffset = chunkBuffer.getInt(chunkRowId * 4);
        int valueEndOffset = this.getValueEndOffset(chunkRowId, chunkBuffer);
        return chunkBuffer.duplicate().position(valueStartOffset).limit(valueEndOffset);
    }

    private ByteBuffer sliceBytesUncompressed(int docId) {
        int chunkId = docId / this._numDocsPerChunk;
        int chunkRowId = docId % this._numDocsPerChunk;
        long chunkStartOffset = this.getChunkPosition(chunkId);
        long valueStartOffset = chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)chunkRowId * 4L);
        long valueEndOffset = this.getValueEndOffset(chunkId, chunkRowId, chunkStartOffset);
        return this._dataBuffer.toDirectByteBuffer(valueStartOffset, (int)(valueEndOffset - valueStartOffset));
    }

    private int getValueEndOffset(int rowId, ByteBuffer chunkBuffer) {
        if (rowId == this._numDocsPerChunk - 1) {
            return chunkBuffer.limit();
        }
        int valueEndOffset = chunkBuffer.getInt((rowId + 1) * 4);
        if (valueEndOffset == 0) {
            return chunkBuffer.limit();
        }
        return valueEndOffset;
    }

    private long getValueEndOffset(int chunkId, int chunkRowId, long chunkStartOffset) {
        if (chunkId == this._numChunks - 1) {
            if (chunkRowId == this._numDocsPerChunk - 1) {
                return this._dataBuffer.size();
            }
            int valueEndOffsetInChunk = this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
            if (valueEndOffsetInChunk == 0) {
                return this._dataBuffer.size();
            }
            return chunkStartOffset + (long)valueEndOffsetInChunk;
        }
        if (chunkRowId == this._numDocsPerChunk - 1) {
            return this.getChunkPosition(chunkId + 1);
        }
        return chunkStartOffset + (long)this._dataBuffer.getInt(chunkStartOffset + (long)(chunkRowId + 1) * 4L);
    }
}

