/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import org.apache.pinot.segment.local.io.util.FixedBitIntReaderWriter;
import org.apache.pinot.segment.local.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBitMVForwardIndexReader
implements ForwardIndexReader<Context> {
    private static final int PREFERRED_NUM_VALUES_PER_CHUNK = 2048;
    private final FixedByteValueReaderWriter _chunkOffsetReader;
    private final PinotDataBitSet _bitmapReader;
    private final FixedBitIntReaderWriter _rawDataReader;
    private final int _numDocs;
    private final int _numValues;
    private final int _numDocsPerChunk;

    public FixedBitMVForwardIndexReader(PinotDataBuffer dataBuffer, int numDocs, int numValues, int numBitsPerValue) {
        this._numDocs = numDocs;
        this._numValues = numValues;
        this._numDocsPerChunk = (int)Math.ceil(2048.0f / (float)(numValues / numDocs));
        int numChunks = (numDocs + this._numDocsPerChunk - 1) / this._numDocsPerChunk;
        long endOffset = numChunks * 4;
        this._chunkOffsetReader = new FixedByteValueReaderWriter(dataBuffer.view(0L, endOffset));
        int bitmapSize = (numValues + 8 - 1) / 8;
        this._bitmapReader = new PinotDataBitSet(dataBuffer.view(endOffset, endOffset + (long)bitmapSize));
        int rawDataSize = (int)(((long)numValues * (long)numBitsPerValue + 8L - 1L) / 8L);
        this._rawDataReader = new FixedBitIntReaderWriter(dataBuffer.view(endOffset += (long)bitmapSize, endOffset + (long)rawDataSize), numValues, numBitsPerValue);
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return false;
    }

    public FieldSpec.DataType getStoredType() {
        return FieldSpec.DataType.INT;
    }

    public Context createContext() {
        return new Context();
    }

    public int getDictIdMV(int docId, int[] dictIdBuffer, Context context) {
        int startIndex;
        int contextDocId = context._docId;
        int contextEndOffset = context._endOffset;
        if (docId == contextDocId + 1) {
            startIndex = contextEndOffset;
        } else {
            int chunkId = docId / this._numDocsPerChunk;
            if (docId > contextDocId && chunkId == contextDocId / this._numDocsPerChunk) {
                startIndex = this._bitmapReader.getNextNthSetBitOffset(contextEndOffset + 1, docId - contextDocId - 1);
            } else {
                int chunkOffset = this._chunkOffsetReader.getInt(chunkId);
                int indexInChunk = docId % this._numDocsPerChunk;
                startIndex = indexInChunk == 0 ? chunkOffset : this._bitmapReader.getNextNthSetBitOffset(chunkOffset + 1, indexInChunk);
            }
        }
        int endIndex = docId == this._numDocs - 1 ? this._numValues : this._bitmapReader.getNextSetBitOffset(startIndex + 1);
        int numValues = endIndex - startIndex;
        this._rawDataReader.readInt(startIndex, numValues, dictIdBuffer);
        context._docId = docId;
        context._endOffset = endIndex;
        return numValues;
    }

    public int[] getDictIdMV(int docId, Context context) {
        int startIndex;
        int contextDocId = context._docId;
        int contextEndOffset = context._endOffset;
        if (docId == contextDocId + 1) {
            startIndex = contextEndOffset;
        } else {
            int chunkId = docId / this._numDocsPerChunk;
            if (docId > contextDocId && chunkId == contextDocId / this._numDocsPerChunk) {
                startIndex = this._bitmapReader.getNextNthSetBitOffset(contextEndOffset + 1, docId - contextDocId - 1);
            } else {
                int chunkOffset = this._chunkOffsetReader.getInt(chunkId);
                int indexInChunk = docId % this._numDocsPerChunk;
                startIndex = indexInChunk == 0 ? chunkOffset : this._bitmapReader.getNextNthSetBitOffset(chunkOffset + 1, indexInChunk);
            }
        }
        int endIndex = docId == this._numDocs - 1 ? this._numValues : this._bitmapReader.getNextSetBitOffset(startIndex + 1);
        int numValues = endIndex - startIndex;
        int[] dictIdBuffer = new int[numValues];
        this._rawDataReader.readInt(startIndex, numValues, dictIdBuffer);
        context._docId = docId;
        context._endOffset = endIndex;
        return dictIdBuffer;
    }

    public int getNumValuesMV(int docId, Context context) {
        int startIndex;
        int contextDocId = context._docId;
        int contextEndOffset = context._endOffset;
        if (docId == contextDocId + 1) {
            startIndex = contextEndOffset;
        } else {
            int chunkId = docId / this._numDocsPerChunk;
            if (docId > contextDocId && chunkId == contextDocId / this._numDocsPerChunk) {
                startIndex = this._bitmapReader.getNextNthSetBitOffset(contextEndOffset + 1, docId - contextDocId - 1);
            } else {
                int chunkOffset = this._chunkOffsetReader.getInt(chunkId);
                int indexInChunk = docId % this._numDocsPerChunk;
                startIndex = indexInChunk == 0 ? chunkOffset : this._bitmapReader.getNextNthSetBitOffset(chunkOffset + 1, indexInChunk);
            }
        }
        int endIndex = docId == this._numDocs - 1 ? this._numValues : this._bitmapReader.getNextSetBitOffset(startIndex + 1);
        return endIndex - startIndex;
    }

    public void close() {
        this._chunkOffsetReader.close();
        this._bitmapReader.close();
        this._rawDataReader.close();
    }

    public static class Context
    implements ForwardIndexReaderContext {
        private int _docId = -1;
        private int _endOffset = 0;

        public void close() {
        }
    }
}

