/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public class FloatDictionary
extends BaseImmutableDictionary {
    public FloatDictionary(PinotDataBuffer dataBuffer, int length) {
        super(dataBuffer, length, 4);
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.FLOAT;
    }

    public int indexOf(float floatValue) {
        return this.normalizeIndex(this.binarySearch(floatValue));
    }

    public int insertionIndexOf(String stringValue) {
        return this.binarySearch(Float.parseFloat(stringValue));
    }

    public Float get(int dictId) {
        return Float.valueOf(this.getFloat(dictId));
    }

    public int getIntValue(int dictId) {
        return (int)this.getFloat(dictId);
    }

    public long getLongValue(int dictId) {
        return (long)this.getFloat(dictId);
    }

    public float getFloatValue(int dictId) {
        return this.getFloat(dictId);
    }

    public double getDoubleValue(int dictId) {
        return this.getFloat(dictId);
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimal.valueOf(this.getFloat(dictId));
    }

    public String getStringValue(int dictId) {
        return Float.toString(this.getFloat(dictId));
    }
}

