/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class ConstantValueBigDecimalDictionary
extends BaseImmutableDictionary {
    private final BigDecimal _value;

    public ConstantValueBigDecimalDictionary(BigDecimal value) {
        super(1);
        this._value = value;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BIG_DECIMAL;
    }

    @Override
    public int indexOf(String stringValue) {
        return new BigDecimal(stringValue).compareTo(this._value) == 0 ? 0 : -1;
    }

    public int indexOf(BigDecimal bigDecimalValue) {
        return bigDecimalValue.compareTo(this._value) == 0 ? 0 : -1;
    }

    public int insertionIndexOf(String stringValue) {
        int compareResult = new BigDecimal(stringValue).compareTo(this._value);
        if (compareResult < 0) {
            return -1;
        }
        if (compareResult > 0) {
            return -2;
        }
        return 0;
    }

    @Override
    public BigDecimal getMinVal() {
        return this._value;
    }

    @Override
    public BigDecimal getMaxVal() {
        return this._value;
    }

    public BigDecimal[] getSortedValues() {
        return new BigDecimal[]{this._value};
    }

    public BigDecimal get(int dictId) {
        return this._value;
    }

    public int getIntValue(int dictId) {
        return this._value.intValue();
    }

    public long getLongValue(int dictId) {
        return this._value.longValue();
    }

    public float getFloatValue(int dictId) {
        return this._value.floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this._value.doubleValue();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return this._value;
    }

    public String getStringValue(int dictId) {
        return this._value.toPlainString();
    }
}

