/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.local.utils.FPOrdering;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.roaringbitmap.RangeBitmap;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class BitSlicedRangeIndexReader
implements RangeIndexReader<ImmutableRoaringBitmap> {
    private final PinotDataBuffer _dataBuffer;
    private final long _offset;
    private final long _min;
    private final long _max;
    private final int _numDocs;

    public BitSlicedRangeIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata) {
        Number maxValue;
        this._dataBuffer = dataBuffer;
        long offset = 0L;
        int version = dataBuffer.getInt(offset);
        assert (version == 2) : "invalid version";
        this._min = dataBuffer.getLong(offset += 4L);
        this._offset = offset += 8L;
        this._max = metadata.hasDictionary() ? (long)(metadata.getCardinality() - 1) : ((maxValue = (Number)((Object)metadata.getMaxValue())) != null ? maxValue.longValue() : Long.MAX_VALUE);
        this._numDocs = metadata.getTotalDocs();
    }

    public int getNumMatchingDocs(int min, int max) {
        if (min > max || (long)min > this._max || (long)max < this._min) {
            return 0;
        }
        return this.queryRangeBitmapCardinality(Math.max((long)min, this._min) - this._min, (long)max - this._min, this._max - this._min);
    }

    public int getNumMatchingDocs(long min, long max) {
        if (min > max || min > this._max || max < this._min) {
            return 0;
        }
        return this.queryRangeBitmapCardinality(Math.max(min, this._min) - this._min, max - this._min, this._max - this._min);
    }

    public int getNumMatchingDocs(float min, float max) {
        if (min > max) {
            return 0;
        }
        return this.queryRangeBitmapCardinality(FPOrdering.ordinalOf(min), FPOrdering.ordinalOf(max), 0xFFFFFFFFL);
    }

    public int getNumMatchingDocs(double min, double max) {
        if (min > max) {
            return 0;
        }
        return this.queryRangeBitmapCardinality(FPOrdering.ordinalOf(min), FPOrdering.ordinalOf(max), -1L);
    }

    public int getNumMatchingDocs(int value) {
        if ((long)value < this._min) {
            return 0;
        }
        return this.queryRangeBitmapCardinality((long)value - this._min, this._max - this._min);
    }

    public int getNumMatchingDocs(long value) {
        if (value < this._min) {
            return 0;
        }
        return this.queryRangeBitmapCardinality(value - this._min, this._max - this._min);
    }

    public int getNumMatchingDocs(float value) {
        return this.queryRangeBitmapCardinality(FPOrdering.ordinalOf(value), 0xFFFFFFFFL);
    }

    public int getNumMatchingDocs(double value) {
        return this.queryRangeBitmapCardinality(FPOrdering.ordinalOf(value), -1L);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(int min, int max) {
        if (min > max || (long)min > this._max || (long)max < this._min) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap(Math.max((long)min, this._min) - this._min, (long)max - this._min, this._max - this._min);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(long min, long max) {
        if (min > max || min > this._max || max < this._min) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap(Math.max(min, this._min) - this._min, max - this._min, this._max - this._min);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(float min, float max) {
        if (min > max) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap(FPOrdering.ordinalOf(min), FPOrdering.ordinalOf(max), 0xFFFFFFFFL);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(double min, double max) {
        if (min > max) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap(FPOrdering.ordinalOf(min), FPOrdering.ordinalOf(max), -1L);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(int value) {
        if ((long)value < this._min) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap((long)value - this._min, this._max - this._min);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(long value) {
        if (value < this._min) {
            return new MutableRoaringBitmap();
        }
        return this.queryRangeBitmap(value - this._min, this._max - this._min);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(float value) {
        return this.queryRangeBitmap(FPOrdering.ordinalOf(value), 0xFFFFFFFFL);
    }

    public ImmutableRoaringBitmap getMatchingDocIds(double value) {
        return this.queryRangeBitmap(FPOrdering.ordinalOf(value), -1L);
    }

    private ImmutableRoaringBitmap queryRangeBitmap(long min, long max, long columnMax) {
        RangeBitmap rangeBitmap = this.mapRangeBitmap();
        if (Long.compareUnsigned(max, columnMax) < 0) {
            if (Long.compareUnsigned(min, 0L) > 0) {
                if (min == max) {
                    return rangeBitmap.eq(min).toMutableRoaringBitmap();
                }
                return rangeBitmap.between(min, max).toMutableRoaringBitmap();
            }
            return rangeBitmap.lte(max).toMutableRoaringBitmap();
        }
        if (Long.compareUnsigned(min, 0L) > 0) {
            return rangeBitmap.gte(min).toMutableRoaringBitmap();
        }
        MutableRoaringBitmap all = new MutableRoaringBitmap();
        all.add(0L, (long)this._numDocs);
        return all;
    }

    private ImmutableRoaringBitmap queryRangeBitmap(long value, long columnMax) {
        RangeBitmap rangeBitmap = this.mapRangeBitmap();
        if (Long.compareUnsigned(value, columnMax) <= 0) {
            return rangeBitmap.eq(value).toMutableRoaringBitmap();
        }
        return new MutableRoaringBitmap();
    }

    private int queryRangeBitmapCardinality(long min, long max, long columnMax) {
        RangeBitmap rangeBitmap = this.mapRangeBitmap();
        if (Long.compareUnsigned(max, columnMax) < 0) {
            if (Long.compareUnsigned(min, 0L) > 0) {
                if (min == max) {
                    return (int)rangeBitmap.eqCardinality(min);
                }
                return (int)rangeBitmap.betweenCardinality(min, max);
            }
            return (int)rangeBitmap.lteCardinality(max);
        }
        if (Long.compareUnsigned(min, 0L) > 0) {
            return (int)rangeBitmap.gteCardinality(min);
        }
        return this._numDocs;
    }

    private int queryRangeBitmapCardinality(long value, long columnMax) {
        RangeBitmap rangeBitmap = this.mapRangeBitmap();
        if (Long.compareUnsigned(value, columnMax) <= 0) {
            return (int)rangeBitmap.eqCardinality(value);
        }
        return 0;
    }

    private RangeBitmap mapRangeBitmap() {
        ByteBuffer buffer = this._dataBuffer.toDirectByteBuffer(this._offset, (int)(this._dataBuffer.size() - this._offset));
        return RangeBitmap.map((ByteBuffer)buffer);
    }

    public void close() throws IOException {
    }
}

