/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import com.google.common.base.Preconditions;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.pinot.segment.local.io.util.FixedByteValueReaderWriter;
import org.apache.pinot.segment.local.io.util.ValueReader;
import org.apache.pinot.segment.local.io.util.VarLengthValueReader;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public abstract class BaseImmutableDictionary
implements Dictionary {
    private final ValueReader _valueReader;
    private final int _length;
    private final int _numBytesPerValue;

    protected BaseImmutableDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        if (VarLengthValueReader.isVarLengthValueBuffer(dataBuffer)) {
            VarLengthValueReader valueReader = new VarLengthValueReader(dataBuffer);
            this._valueReader = valueReader;
            this._length = valueReader.getNumValues();
        } else {
            Preconditions.checkState((dataBuffer.size() == (long)length * (long)numBytesPerValue ? 1 : 0) != 0, (String)"Buffer size mismatch: bufferSize = %s, numValues = %s, numByesPerValue = %s", (Object)dataBuffer.size(), (Object)length, (Object)numBytesPerValue);
            this._valueReader = new FixedByteValueReaderWriter(dataBuffer);
            this._length = length;
        }
        this._numBytesPerValue = numBytesPerValue;
    }

    protected BaseImmutableDictionary(int length) {
        this._valueReader = null;
        this._length = length;
        this._numBytesPerValue = -1;
    }

    public boolean isSorted() {
        return true;
    }

    public int length() {
        return this._length;
    }

    public int indexOf(String stringValue) {
        return this.normalizeIndex(this.insertionIndexOf(stringValue));
    }

    protected final int normalizeIndex(int index) {
        return index >= 0 ? index : -1;
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        throw new UnsupportedOperationException();
    }

    public int compare(int dictId1, int dictId2) {
        return Integer.compare(dictId1, dictId2);
    }

    public Comparable getMinVal() {
        return (Comparable)this.get(0);
    }

    public Comparable getMaxVal() {
        return (Comparable)this.get(this._length - 1);
    }

    public Object getSortedValues() {
        throw new UnsupportedOperationException();
    }

    public void close() throws IOException {
        if (this._valueReader != null) {
            this._valueReader.close();
        }
    }

    protected int binarySearch(int value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int midValue = this._valueReader.getInt(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(long value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            long midValue = this._valueReader.getLong(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(float value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            float midValue = this._valueReader.getFloat(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(double value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            double midValue = this._valueReader.getDouble(mid);
            if (midValue < value) {
                low = mid + 1;
                continue;
            }
            if (midValue > value) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(BigDecimal value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            BigDecimal midValue = this._valueReader.getBigDecimal(mid, this._numBytesPerValue);
            int compareResult = midValue.compareTo(value);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(String value) {
        int low = 0;
        int high = this._length - 1;
        byte[] utf8 = value.getBytes(StandardCharsets.UTF_8);
        while (low <= high) {
            int mid = low + high >>> 1;
            int compareResult = this._valueReader.compareUtf8Bytes(mid, this._numBytesPerValue, utf8);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int binarySearch(byte[] value) {
        int low = 0;
        int high = this._length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int compareResult = this._valueReader.compareBytes(mid, this._numBytesPerValue, value);
            if (compareResult < 0) {
                low = mid + 1;
                continue;
            }
            if (compareResult > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    protected int getInt(int dictId) {
        return this._valueReader.getInt(dictId);
    }

    protected long getLong(int dictId) {
        return this._valueReader.getLong(dictId);
    }

    protected float getFloat(int dictId) {
        return this._valueReader.getFloat(dictId);
    }

    protected double getDouble(int dictId) {
        return this._valueReader.getDouble(dictId);
    }

    protected BigDecimal getBigDecimal(int dictId) {
        return this._valueReader.getBigDecimal(dictId, this._numBytesPerValue);
    }

    protected byte[] getUnpaddedBytes(int dictId, byte[] buffer) {
        return this._valueReader.getUnpaddedBytes(dictId, this._numBytesPerValue, buffer);
    }

    protected String getUnpaddedString(int dictId, byte[] buffer) {
        return this._valueReader.getUnpaddedString(dictId, this._numBytesPerValue, buffer);
    }

    protected String getPaddedString(int dictId, byte[] buffer) {
        return this._valueReader.getPaddedString(dictId, this._numBytesPerValue, buffer);
    }

    protected byte[] getBytes(int dictId) {
        return this._valueReader.getBytes(dictId, this._numBytesPerValue);
    }

    protected byte[] getBuffer() {
        return new byte[this._numBytesPerValue];
    }

    public void getDictIds(List<String> sortedValues, IntSet dictIds) {
        int valueIdx = 0;
        int dictIdx = 0;
        byte[] utf8 = null;
        boolean needNewUtf8 = true;
        int sortedValuesSize = sortedValues.size();
        int dictLength = this.length();
        while (valueIdx < sortedValuesSize && dictIdx < dictLength) {
            int comparison;
            if (needNewUtf8) {
                utf8 = sortedValues.get(valueIdx).getBytes(StandardCharsets.UTF_8);
            }
            if ((comparison = this._valueReader.compareUtf8Bytes(dictIdx, this._numBytesPerValue, utf8)) == 0) {
                dictIds.add(dictIdx);
                ++dictIdx;
                ++valueIdx;
                needNewUtf8 = true;
                continue;
            }
            if (comparison > 0) {
                ++valueIdx;
                needNewUtf8 = true;
                continue;
            }
            ++dictIdx;
            needNewUtf8 = false;
        }
    }
}

