/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.nullvalue;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.nullvalue.NullValueVectorCreator;
import org.apache.pinot.segment.local.segment.index.readers.NullValueVectorReaderImpl;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.reader.NullValueVectorReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class NullValueIndexType
extends AbstractIndexType<IndexConfig, NullValueVectorReader, NullValueVectorCreator> {
    public static final String INDEX_DISPLAY_NAME = "null";

    protected NullValueIndexType() {
        super("nullvalue_vector");
    }

    public Class<IndexConfig> getIndexConfigClass() {
        return IndexConfig.class;
    }

    public NullValueVectorCreator createIndexCreator(IndexCreationContext context, IndexConfig indexConfig) throws Exception {
        return new NullValueVectorCreator(context.getIndexDir(), context.getFieldSpec().getName());
    }

    public IndexConfig getDefaultConfig() {
        return IndexConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<IndexConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withFallbackAlternative(IndexConfigDeserializer.ifIndexingConfig((ColumnConfigDeserializer)IndexConfigDeserializer.alwaysCall((tableConfig, schema) -> tableConfig.getIndexingConfig().isNullHandlingEnabled() ? IndexConfig.ENABLED : IndexConfig.DISABLED)));
    }

    public NullValueVectorCreator createIndexCreator(File indexDir, String columnName) {
        return new NullValueVectorCreator(indexDir, columnName);
    }

    protected IndexReaderFactory<NullValueVectorReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return IndexHandler.NoOp.INSTANCE;
    }

    public String getFileExtension(ColumnMetadata columnMetadata) {
        return ".bitmap.nullvalue";
    }

    public void convertToNewFormat(TableConfig tableConfig, Schema schema) {
    }

    private static class ReaderFactory
    implements IndexReaderFactory<NullValueVectorReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        @Nullable
        public NullValueVectorReader createIndexReader(SegmentDirectory.Reader segmentReader, FieldIndexConfigs fieldIndexConfigs, ColumnMetadata metadata) throws IOException {
            if (!segmentReader.hasIndexFor(metadata.getColumnName(), StandardIndexes.nullValueVector())) {
                return null;
            }
            PinotDataBuffer buffer = segmentReader.getIndexFor(metadata.getColumnName(), StandardIndexes.nullValueVector());
            return new NullValueVectorReaderImpl(buffer);
        }
    }
}

