/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.bloomfilter;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.dictionary.DictionaryIndexType;
import org.apache.pinot.segment.local.segment.index.forward.ForwardIndexType;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.FieldIndexConfigsUtil;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.IndexConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BytesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BloomFilterHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BloomFilterHandler.class);
    private final Map<String, BloomFilterConfig> _bloomFilterConfigs;

    public BloomFilterHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        super(segmentDirectory, fieldIndexConfigs, tableConfig);
        this._bloomFilterConfigs = FieldIndexConfigsUtil.enableConfigByColumn((IndexType)StandardIndexes.bloomFilter(), fieldIndexConfigs);
    }

    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        HashSet<String> columnsToAddBF = new HashSet<String>(this._bloomFilterConfigs.keySet());
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.bloomFilter());
        for (String column : existingColumns) {
            if (columnsToAddBF.remove(column)) continue;
            LOGGER.info("Need to remove existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddBF) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateBloomFilter(columnMetadata)) continue;
            LOGGER.info("Need to create new bloom filter for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    public void updateIndices(SegmentDirectory.Writer segmentWriter) throws Exception {
        HashSet<String> columnsToAddBF = new HashSet<String>(this._bloomFilterConfigs.keySet());
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(StandardIndexes.bloomFilter());
        for (String column : existingColumns) {
            if (columnsToAddBF.remove(column)) continue;
            LOGGER.info("Removing existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, StandardIndexes.bloomFilter());
            LOGGER.info("Removed existing bloom filter from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddBF) {
            ColumnMetadata columnMetadata = this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(column);
            if (!this.shouldCreateBloomFilter(columnMetadata)) continue;
            this.createBloomFilterForColumn(segmentWriter, columnMetadata);
        }
    }

    private boolean shouldCreateBloomFilter(ColumnMetadata columnMetadata) {
        return columnMetadata != null;
    }

    private void createAndSealBloomFilterForDictionaryColumn(File indexDir, ColumnMetadata columnMetadata, BloomFilterConfig bloomFilterConfig, SegmentDirectory.Writer segmentWriter) throws Exception {
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        try (BloomFilterCreator bloomFilterCreator = (BloomFilterCreator)StandardIndexes.bloomFilter().createIndexCreator((IndexCreationContext)context, (IndexConfig)bloomFilterConfig);
             Dictionary dictionary = this.getDictionaryReader(columnMetadata, segmentWriter);){
            int length = dictionary.length();
            for (int i = 0; i < length; ++i) {
                bloomFilterCreator.add(dictionary.getStringValue(i));
            }
            bloomFilterCreator.seal();
        }
    }

    private void createAndSealBloomFilterForNonDictionaryColumn(File indexDir, ColumnMetadata columnMetadata, BloomFilterConfig bloomFilterConfig, SegmentDirectory.Writer segmentWriter) throws Exception {
        int numDocs = columnMetadata.getTotalDocs();
        IndexCreationContext.Common context = IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build();
        try (BloomFilterCreator bloomFilterCreator = (BloomFilterCreator)StandardIndexes.bloomFilter().createIndexCreator((IndexCreationContext)context, (IndexConfig)bloomFilterConfig);
             ForwardIndexReader<?> forwardIndexReader = ForwardIndexType.read((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();){
            if (columnMetadata.isSingleValue()) {
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Integer.toString(forwardIndexReader.getInt(i, readerContext)));
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Long.toString(forwardIndexReader.getLong(i, readerContext)));
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Float.toString(forwardIndexReader.getFloat(i, readerContext)));
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(Double.toString(forwardIndexReader.getDouble(i, readerContext)));
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(forwardIndexReader.getString(i, readerContext));
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < numDocs; ++i) {
                            bloomFilterCreator.add(BytesUtils.toHexString((byte[])forwardIndexReader.getBytes(i, readerContext)));
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType() + " for column: " + columnMetadata.getColumnName());
                    }
                }
                bloomFilterCreator.seal();
            } else {
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        for (int i = 0; i < numDocs; ++i) {
                            int[] buffer = new int[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getIntMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Integer.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case LONG: {
                        for (int i = 0; i < numDocs; ++i) {
                            long[] buffer = new long[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getLongMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Long.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case FLOAT: {
                        for (int i = 0; i < numDocs; ++i) {
                            float[] buffer = new float[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getFloatMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Float.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case DOUBLE: {
                        for (int i = 0; i < numDocs; ++i) {
                            double[] buffer = new double[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getDoubleMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(Double.toString(buffer[j]));
                            }
                        }
                        break;
                    }
                    case STRING: {
                        for (int i = 0; i < numDocs; ++i) {
                            String[] buffer = new String[columnMetadata.getMaxNumberOfMultiValues()];
                            int length = forwardIndexReader.getStringMV(i, buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(buffer[j]);
                            }
                        }
                        break;
                    }
                    case BYTES: {
                        for (int i = 0; i < numDocs; ++i) {
                            byte[][] buffer = new byte[columnMetadata.getMaxNumberOfMultiValues()][];
                            int length = forwardIndexReader.getBytesMV(i, (byte[][])buffer, readerContext);
                            for (int j = 0; j < length; ++j) {
                                bloomFilterCreator.add(BytesUtils.toHexString((byte[])buffer[j]));
                            }
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType() + " for column: " + columnMetadata.getColumnName());
                    }
                }
                bloomFilterCreator.seal();
            }
        }
    }

    private void createBloomFilterForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata) throws Exception {
        File indexDir = this._segmentDirectory.getSegmentMetadata().getIndexDir();
        String segmentName = this._segmentDirectory.getSegmentMetadata().getName();
        String columnName = columnMetadata.getColumnName();
        File bloomFilterFileInProgress = new File(indexDir, columnName + ".bloom.inprogress");
        File bloomFilterFile = new File(indexDir, columnName + ".bloom");
        if (!bloomFilterFileInProgress.exists()) {
            FileUtils.touch((File)bloomFilterFileInProgress);
        } else {
            FileUtils.deleteQuietly((File)bloomFilterFile);
        }
        if (!columnMetadata.hasDictionary()) {
            columnMetadata = this.createForwardIndexIfNeeded(segmentWriter, columnName, true);
        }
        BloomFilterConfig bloomFilterConfig = this._bloomFilterConfigs.get(columnName);
        LOGGER.info("Creating new bloom filter for segment: {}, column: {} with config: {}", new Object[]{segmentName, columnName, bloomFilterConfig});
        if (columnMetadata.hasDictionary()) {
            this.createAndSealBloomFilterForDictionaryColumn(indexDir, columnMetadata, bloomFilterConfig, segmentWriter);
        } else {
            this.createAndSealBloomFilterForNonDictionaryColumn(indexDir, columnMetadata, bloomFilterConfig, segmentWriter);
        }
        if (this._segmentDirectory.getSegmentMetadata().getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, bloomFilterFile, StandardIndexes.bloomFilter());
        }
        FileUtils.deleteQuietly((File)bloomFilterFileInProgress);
        LOGGER.info("Created bloom filter for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private Dictionary getDictionaryReader(ColumnMetadata columnMetadata, SegmentDirectory.Writer segmentWriter) throws IOException {
        FieldSpec.DataType dataType = columnMetadata.getDataType();
        switch (dataType) {
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BYTES: {
                PinotDataBuffer buf = segmentWriter.getIndexFor(columnMetadata.getColumnName(), StandardIndexes.dictionary());
                return DictionaryIndexType.read(buf, columnMetadata, DictionaryIndexConfig.DEFAULT);
            }
        }
        throw new IllegalStateException("Unsupported data type: " + dataType + " for column: " + columnMetadata.getColumnName());
    }
}

