/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.InvertedIndexAndDictionaryBasedForwardIndexCreator;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.DictionaryIndexConfig;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.ForwardIndexConfig;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.TableConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseIndexHandler.class);
    protected final Set<String> _tmpForwardIndexColumns;
    protected final SegmentDirectory _segmentDirectory;
    protected final Map<String, FieldIndexConfigs> _fieldIndexConfigs;
    @Nullable
    protected final TableConfig _tableConfig;

    public BaseIndexHandler(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig) {
        this(segmentDirectory, indexLoadingConfig.getFieldIndexConfigByColName(), indexLoadingConfig.getTableConfig());
    }

    public BaseIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> fieldIndexConfigs, @Nullable TableConfig tableConfig) {
        this._segmentDirectory = segmentDirectory;
        SegmentMetadataImpl segmentMetadata = segmentDirectory.getSegmentMetadata();
        if (fieldIndexConfigs.keySet().equals(segmentMetadata.getAllColumns())) {
            this._fieldIndexConfigs = fieldIndexConfigs;
        } else {
            this._fieldIndexConfigs = new HashMap<String, FieldIndexConfigs>(fieldIndexConfigs);
            for (String column : segmentMetadata.getAllColumns()) {
                if (this._fieldIndexConfigs.containsKey(column)) continue;
                this._fieldIndexConfigs.put(column, FieldIndexConfigs.EMPTY);
            }
        }
        this._tableConfig = tableConfig;
        this._tmpForwardIndexColumns = new HashSet<String>();
    }

    public void postUpdateIndicesCleanup(SegmentDirectory.Writer segmentWriter) throws Exception {
        for (String column : this._tmpForwardIndexColumns) {
            segmentWriter.removeIndex(column, StandardIndexes.forward());
        }
    }

    protected ColumnMetadata createForwardIndexIfNeeded(SegmentDirectory.Writer segmentWriter, String columnName, boolean isTemporaryForwardIndex) throws IOException {
        if (segmentWriter.hasIndexFor(columnName, StandardIndexes.forward())) {
            LOGGER.info("Forward index already exists for column: {}, skip trying to create it", (Object)columnName);
            return this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(columnName);
        }
        Preconditions.checkState((boolean)segmentWriter.hasIndexFor(columnName, StandardIndexes.dictionary()), (Object)String.format("Forward index disabled column %s must have a dictionary to regenerate the forward index. Regeneration of the forward index is required to create new indexes as well. Please refresh or back-fill the forward index", columnName));
        Preconditions.checkState((boolean)segmentWriter.hasIndexFor(columnName, StandardIndexes.inverted()), (Object)String.format("Forward index disabled column %s must have an inverted index to regenerate the forward index. Regeneration of the forward index is required to create new indexes as well. Please refresh or back-fill the forward index", columnName));
        LOGGER.info("Rebuilding the forward index for column: {}, is temporary: {}", (Object)columnName, (Object)isTemporaryForwardIndex);
        FieldIndexConfigs fieldIndexConfig = this._fieldIndexConfigs.get(columnName);
        boolean dictionaryEnabled = ((DictionaryIndexConfig)fieldIndexConfig.getConfig(StandardIndexes.dictionary())).isEnabled();
        ForwardIndexConfig forwardIndexConfig = (ForwardIndexConfig)fieldIndexConfig.getConfig(StandardIndexes.forward());
        InvertedIndexAndDictionaryBasedForwardIndexCreator invertedIndexAndDictionaryBasedForwardIndexCreator = new InvertedIndexAndDictionaryBasedForwardIndexCreator(columnName, this._segmentDirectory, dictionaryEnabled, forwardIndexConfig, segmentWriter, isTemporaryForwardIndex);
        invertedIndexAndDictionaryBasedForwardIndexCreator.regenerateForwardIndex();
        if (!segmentWriter.hasIndexFor(columnName, StandardIndexes.forward())) {
            throw new IOException(String.format("Forward index was not created for column: %s, is temporary: %s", columnName, isTemporaryForwardIndex ? "true" : "false"));
        }
        if (isTemporaryForwardIndex) {
            this._tmpForwardIndexColumns.add(columnName);
        }
        LOGGER.info("Rebuilt the forward index for column: {}, is temporary: {}", (Object)columnName, (Object)isTemporaryForwardIndex);
        return this._segmentDirectory.getSegmentMetadata().getColumnMetadataFor(columnName);
    }
}

