/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.column;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexReader;
import org.apache.pinot.segment.spi.index.IndexReaderConstraintException;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexService;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.column.ColumnIndexContainer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PhysicalColumnIndexContainer
implements ColumnIndexContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PhysicalColumnIndexContainer.class);
    private final Map<IndexType, IndexReader> _readersByIndex;

    public PhysicalColumnIndexContainer(SegmentDirectory.Reader segmentReader, ColumnMetadata metadata, IndexLoadingConfig indexLoadingConfig) throws IOException {
        String columnName = metadata.getColumnName();
        FieldIndexConfigs fieldIndexConfigs = indexLoadingConfig.getFieldIndexConfig(columnName);
        if (fieldIndexConfigs == null) {
            fieldIndexConfigs = FieldIndexConfigs.EMPTY;
        }
        this._readersByIndex = new HashMap<IndexType, IndexReader>();
        for (IndexType indexType : IndexService.getInstance().getAllIndexes()) {
            if (!segmentReader.hasIndexFor(columnName, indexType)) continue;
            IndexReaderFactory readerProvider = indexType.getReaderFactory();
            try {
                IndexReader reader = readerProvider.createIndexReader(segmentReader, fieldIndexConfigs, metadata);
                if (reader == null) continue;
                this._readersByIndex.put(indexType, reader);
            }
            catch (IndexReaderConstraintException ex) {
                LOGGER.warn("Constraint violation when indexing " + columnName + " with " + indexType + " index", (Throwable)ex);
            }
        }
    }

    @Nullable
    public <I extends IndexReader, T extends IndexType<?, I, ?>> I getIndex(T indexType) {
        IndexReader reader = this._readersByIndex.get(indexType);
        return (I)reader;
    }

    public void close() throws IOException {
        for (IndexReader index : this._readersByIndex.values()) {
            index.close();
        }
    }
}

