/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.bloom;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.creator.impl.bloom.OnHeapGuavaBloomFilterCreator;
import org.apache.pinot.segment.local.segment.index.loader.ConfigurableFromIndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.bloomfilter.BloomFilterHandler;
import org.apache.pinot.segment.local.segment.index.readers.bloom.BloomFilterReaderFactory;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.index.AbstractIndexType;
import org.apache.pinot.segment.spi.index.ColumnConfigDeserializer;
import org.apache.pinot.segment.spi.index.FieldIndexConfigs;
import org.apache.pinot.segment.spi.index.IndexConfigDeserializer;
import org.apache.pinot.segment.spi.index.IndexHandler;
import org.apache.pinot.segment.spi.index.IndexReaderFactory;
import org.apache.pinot.segment.spi.index.IndexType;
import org.apache.pinot.segment.spi.index.StandardIndexes;
import org.apache.pinot.segment.spi.index.creator.BloomFilterCreator;
import org.apache.pinot.segment.spi.index.reader.BloomFilterReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.BloomFilterConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;

public class BloomIndexType
extends AbstractIndexType<BloomFilterConfig, BloomFilterReader, BloomFilterCreator>
implements ConfigurableFromIndexLoadingConfig<BloomFilterConfig> {
    public static final String INDEX_DISPLAY_NAME = "bloom";

    protected BloomIndexType() {
        super("bloom_filter");
    }

    public Class<BloomFilterConfig> getIndexConfigClass() {
        return BloomFilterConfig.class;
    }

    @Override
    public Map<String, BloomFilterConfig> fromIndexLoadingConfig(IndexLoadingConfig indexLoadingConfig) {
        return indexLoadingConfig.getBloomFilterConfigs();
    }

    public BloomFilterConfig getDefaultConfig() {
        return BloomFilterConfig.DISABLED;
    }

    public String getPrettyName() {
        return INDEX_DISPLAY_NAME;
    }

    public ColumnConfigDeserializer<BloomFilterConfig> createDeserializer() {
        return IndexConfigDeserializer.fromIndexes((String)this.getPrettyName(), this.getIndexConfigClass()).withExclusiveAlternative(IndexConfigDeserializer.ifIndexingConfig((ColumnConfigDeserializer)IndexConfigDeserializer.fromMap(tableConfig -> tableConfig.getIndexingConfig().getBloomFilterConfigs()).withFallbackAlternative(IndexConfigDeserializer.fromCollection(tableConfig -> tableConfig.getIndexingConfig().getBloomFilterColumns(), (accum, column) -> accum.put(column, BloomFilterConfig.DEFAULT)))));
    }

    public BloomFilterCreator createIndexCreator(IndexCreationContext context, BloomFilterConfig indexConfig) {
        int cardinality = context.getCardinality();
        if (cardinality == Integer.MIN_VALUE) {
            cardinality = context.getTotalNumberOfEntries();
        }
        return new OnHeapGuavaBloomFilterCreator(context.getIndexDir(), context.getFieldSpec().getName(), cardinality, indexConfig, context.getFieldSpec().getDataType());
    }

    public IndexReaderFactory<BloomFilterReader> getReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    public IndexHandler createIndexHandler(SegmentDirectory segmentDirectory, Map<String, FieldIndexConfigs> configsByCol, @Nullable Schema schema, @Nullable TableConfig tableConfig) {
        return new BloomFilterHandler(segmentDirectory, configsByCol, tableConfig);
    }

    public String getFileExtension(ColumnMetadata columnMetadata) {
        return ".bloom";
    }

    protected IndexReaderFactory<BloomFilterReader> createReaderFactory() {
        return ReaderFactory.INSTANCE;
    }

    protected void handleIndexSpecificCleanup(TableConfig tableConfig) {
        tableConfig.getIndexingConfig().setBloomFilterColumns(null);
        tableConfig.getIndexingConfig().setBloomFilterConfigs(null);
    }

    private static class ReaderFactory
    extends IndexReaderFactory.Default<BloomFilterConfig, BloomFilterReader> {
        public static final ReaderFactory INSTANCE = new ReaderFactory();

        private ReaderFactory() {
        }

        protected IndexType<BloomFilterConfig, BloomFilterReader, ?> getIndexType() {
            return StandardIndexes.bloomFilter();
        }

        protected BloomFilterReader createIndexReader(PinotDataBuffer dataBuffer, ColumnMetadata metadata, BloomFilterConfig indexConfig) {
            return BloomFilterReaderFactory.getBloomFilterReader(dataBuffer, indexConfig.isLoadOnHeap());
        }
    }
}

