/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.text;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitmapInvertedIndexWriter;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.segment.index.text.AbstractTextIndexCreator;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.builder.FSTBuilder;
import org.roaringbitmap.Container;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public class NativeTextIndexCreator
extends AbstractTextIndexCreator {
    private static final String TEMP_DIR_SUFFIX = ".nativetext.idx.tmp";
    private static final String FST_FILE_NAME = "native.fst";
    private static final String INVERTED_INDEX_FILE_NAME = "inverted.index.buf";
    public static final int HEADER_LENGTH = 24;
    public static final int VERSION = 1;
    private final String _columnName;
    private final FSTBuilder _fstBuilder;
    private final File _indexFile;
    private final File _tempDir;
    private final File _fstIndexFile;
    private final File _invertedIndexFile;
    private final Analyzer _analyzer;
    private final Map<String, RoaringBitmapWriter<RoaringBitmap>> _postingListMap = new TreeMap<String, RoaringBitmapWriter<RoaringBitmap>>();
    private final RoaringBitmapWriter.Wizard<Container, RoaringBitmap> _bitmapWriterWizard = RoaringBitmapWriter.writer();
    private int _nextDocId = 0;
    private int _fstDataSize;
    private int _numBitMaps;

    public NativeTextIndexCreator(String column, File indexDir) throws IOException {
        this._columnName = column;
        this._fstBuilder = new FSTBuilder();
        this._indexFile = new File(indexDir, column + ".nativetext.idx");
        this._tempDir = new File(indexDir, column + TEMP_DIR_SUFFIX);
        if (this._tempDir.exists()) {
            FileUtils.cleanDirectory((File)this._tempDir);
        } else {
            FileUtils.forceMkdir((File)this._tempDir);
        }
        this._fstIndexFile = new File(this._tempDir, FST_FILE_NAME);
        this._invertedIndexFile = new File(this._tempDir, INVERTED_INDEX_FILE_NAME);
        this._analyzer = new StandardAnalyzer(LuceneTextIndexCreator.ENGLISH_STOP_WORDS_SET);
    }

    public void add(String document) {
        this.addHelper(document);
        ++this._nextDocId;
    }

    public void add(String[] documents, int length) {
        for (int i = 0; i < length; ++i) {
            this.addHelper(documents[i]);
        }
        ++this._nextDocId;
    }

    private void addHelper(String document) {
        List<String> tokens;
        try {
            tokens = this.analyze(document);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        for (String token : tokens) {
            this.addToPostingList(token);
        }
    }

    public void seal() throws IOException {
        int dictId = 0;
        int numPostingLists = this._postingListMap.size();
        try (BitmapInvertedIndexWriter invertedIndexWriter = new BitmapInvertedIndexWriter(this._invertedIndexFile, numPostingLists);){
            for (Map.Entry<String, RoaringBitmapWriter<RoaringBitmap>> entry : this._postingListMap.entrySet()) {
                byte[] byteArray = entry.getKey().getBytes(StandardCharsets.UTF_8);
                this._fstBuilder.add(byteArray, 0, byteArray.length, dictId++);
                invertedIndexWriter.add((RoaringBitmap)entry.getValue().get());
            }
        }
        FST fst = this._fstBuilder.complete();
        this._fstDataSize = fst.save(new FileOutputStream(this._fstIndexFile));
        this.generateIndexFile();
    }

    public void close() throws IOException {
        this._analyzer.close();
        FileUtils.deleteDirectory((File)this._tempDir);
    }

    public List<String> analyze(String text) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (TokenStream tokenStream = this._analyzer.tokenStream(this._columnName, text);){
            CharTermAttribute attr = (CharTermAttribute)tokenStream.addAttribute(CharTermAttribute.class);
            tokenStream.reset();
            while (tokenStream.incrementToken()) {
                result.add(attr.toString());
            }
            tokenStream.end();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught exception while tokenizing the document for column: " + this._columnName, e);
        }
        return result;
    }

    void addToPostingList(String value) {
        RoaringBitmapWriter bitmapWriter = this._postingListMap.get(value);
        if (bitmapWriter == null) {
            bitmapWriter = this._bitmapWriterWizard.get();
            this._postingListMap.put(value, (RoaringBitmapWriter<RoaringBitmap>)bitmapWriter);
            ++this._numBitMaps;
        }
        bitmapWriter.add(this._nextDocId);
    }

    private void generateIndexFile() throws IOException {
        ByteBuffer headerBuffer = ByteBuffer.allocate(24);
        headerBuffer.putInt(1550218081);
        headerBuffer.putInt(1);
        headerBuffer.putInt(this._fstDataSize);
        long invertedIndexFileLength = this._invertedIndexFile.length();
        headerBuffer.putLong(invertedIndexFileLength);
        headerBuffer.putInt(this._numBitMaps);
        headerBuffer.position(0);
        try (FileChannel indexFileChannel = new RandomAccessFile(this._indexFile, "rw").getChannel();
             FileChannel invertedIndexFileChannel = new RandomAccessFile(this._invertedIndexFile, "r").getChannel();
             FileChannel fstFileChannel = new RandomAccessFile(this._fstIndexFile, "rw").getChannel();){
            indexFileChannel.write(headerBuffer);
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)fstFileChannel, (long)0L, (long)this._fstDataSize, (FileChannel)indexFileChannel);
            org.apache.pinot.common.utils.FileUtils.transferBytes((FileChannel)invertedIndexFileChannel, (long)0L, (long)invertedIndexFileLength, (FileChannel)indexFileChannel);
        }
    }
}

