/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.util;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;

public final class FixedBitIntReaderWriter
implements Closeable {
    private final PinotDataBitSet _dataBitSet;
    private final int _numBitsPerValue;

    public FixedBitIntReaderWriter(PinotDataBuffer dataBuffer, int numValues, int numBitsPerValue) {
        Preconditions.checkState((dataBuffer.size() == (long)((int)(((long)numValues * (long)numBitsPerValue + 8L - 1L) / 8L)) ? 1 : 0) != 0);
        this._dataBitSet = new PinotDataBitSet(dataBuffer);
        this._numBitsPerValue = numBitsPerValue;
    }

    public int readInt(int index) {
        return this._dataBitSet.readInt(index, this._numBitsPerValue);
    }

    public void readInt(int startIndex, int length, int[] buffer) {
        this._dataBitSet.readInt(startIndex, this._numBitsPerValue, length, buffer);
    }

    public void writeInt(int index, int value) {
        this._dataBitSet.writeInt(index, this._numBitsPerValue, value);
    }

    public void writeInt(int startIndex, int length, int[] values) {
        this._dataBitSet.writeInt(startIndex, this._numBitsPerValue, length, values);
    }

    @Override
    public void close() {
        this._dataBitSet.close();
    }
}

