/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;

class PassThroughCompressor
implements ChunkCompressor {
    static final PassThroughCompressor INSTANCE = new PassThroughCompressor();

    private PassThroughCompressor() {
    }

    public int compress(ByteBuffer inUncompressed, ByteBuffer outCompressed) throws IOException {
        outCompressed.put(inUncompressed);
        outCompressed.flip();
        return outCompressed.limit();
    }

    public int maxCompressedSize(int uncompressedSize) {
        return uncompressedSize;
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.PASS_THROUGH;
    }
}

