/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.data.manager;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.spi.config.instance.InstanceDataManagerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.env.PinotConfiguration;

public class TableDataManagerConfig {
    public static final String AUTH_CONFIG_PREFIX = "auth";
    public static final String TIER_CONFIGS_PREFIX = "tierConfigs";
    public static final String TIER_NAMES = "tierNames";
    private final InstanceDataManagerConfig _instanceDataManagerConfig;
    private final TableConfig _tableConfig;

    public TableDataManagerConfig(InstanceDataManagerConfig instanceDataManagerConfig, TableConfig tableConfig) {
        this._instanceDataManagerConfig = instanceDataManagerConfig;
        this._tableConfig = tableConfig;
    }

    public InstanceDataManagerConfig getInstanceDataManagerConfig() {
        return this._instanceDataManagerConfig;
    }

    public TableConfig getTableConfig() {
        return this._tableConfig;
    }

    public String getTableName() {
        return this._tableConfig.getTableName();
    }

    public TableType getTableType() {
        return this._tableConfig.getTableType();
    }

    public boolean isDimTable() {
        return this._tableConfig.isDimTable();
    }

    public String getDataDir() {
        return this._instanceDataManagerConfig.getInstanceDataDir() + "/" + this.getTableName();
    }

    public String getConsumerDir() {
        return this._instanceDataManagerConfig.getConsumerDir();
    }

    public String getTablePeerDownloadScheme() {
        String peerSegmentDownloadScheme = this._tableConfig.getValidationConfig().getPeerSegmentDownloadScheme();
        if (peerSegmentDownloadScheme != null) {
            return peerSegmentDownloadScheme;
        }
        return this._instanceDataManagerConfig.getSegmentPeerDownloadScheme();
    }

    public int getTableDeletedSegmentsCacheSize() {
        return this._instanceDataManagerConfig.getDeletedSegmentsCacheSize();
    }

    public int getTableDeletedSegmentsCacheTtlMinutes() {
        return this._instanceDataManagerConfig.getDeletedSegmentsCacheTtlMinutes();
    }

    public Configuration getAuthConfig() {
        PropertiesConfiguration authConfig = new PropertiesConfiguration();
        this._instanceDataManagerConfig.getConfig().subset(AUTH_CONFIG_PREFIX).toMap().forEach((arg_0, arg_1) -> ((Configuration)authConfig).addProperty(arg_0, arg_1));
        return authConfig;
    }

    public Map<String, Map<String, String>> getInstanceTierConfigs() {
        PinotConfiguration tierConfigs = this._instanceDataManagerConfig.getConfig().subset(TIER_CONFIGS_PREFIX);
        List tierNames = tierConfigs.getProperty(TIER_NAMES, Collections.emptyList());
        if (tierNames.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, Map<String, String>> instanceTierConfigs = new HashMap<String, Map<String, String>>();
        for (String tierName : tierNames) {
            HashMap tierConfigMap = new HashMap();
            tierConfigs.subset(tierName).toMap().forEach((k, v) -> tierConfigMap.put(k, String.valueOf(v)));
            instanceTierConfigs.put(tierName, tierConfigMap);
        }
        return instanceTierConfigs;
    }
}

