/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class MinValueAggregator
implements ValueAggregator<Number, Double> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.DOUBLE;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.MIN;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public Double getInitialAggregatedValue(Number rawValue) {
        return rawValue.doubleValue();
    }

    @Override
    public Double applyRawValue(Double value, Number rawValue) {
        return Math.min(value, rawValue.doubleValue());
    }

    @Override
    public Double applyAggregatedValue(Double value, Double aggregatedValue) {
        return Math.min(value, aggregatedValue);
    }

    @Override
    public Double cloneAggregatedValue(Double value) {
        return value;
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return 8;
    }

    @Override
    public byte[] serializeAggregatedValue(Double value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Double deserializeAggregatedValue(byte[] bytes) {
        throw new UnsupportedOperationException();
    }
}

