/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.upsert.RecordInfo;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.spi.data.readers.PrimaryKey;
import org.apache.pinot.spi.utils.ByteArray;
import org.roaringbitmap.PeekableIntIterator;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class UpsertUtils {
    private UpsertUtils() {
    }

    public static Iterator<RecordInfo> getRecordInfoIterator(final RecordInfoReader recordInfoReader, final int numDocs) {
        return new Iterator<RecordInfo>(){
            private int _docId = 0;

            @Override
            public boolean hasNext() {
                return this._docId < numDocs;
            }

            @Override
            public RecordInfo next() {
                return recordInfoReader.getRecordInfo(this._docId++);
            }
        };
    }

    public static Iterator<RecordInfo> getRecordInfoIterator(final RecordInfoReader recordInfoReader, final MutableRoaringBitmap validDocIds) {
        return new Iterator<RecordInfo>(){
            private final PeekableIntIterator _docIdIterator;
            {
                this._docIdIterator = validDocIds.getIntIterator();
            }

            @Override
            public boolean hasNext() {
                return this._docIdIterator.hasNext();
            }

            @Override
            public RecordInfo next() {
                return recordInfoReader.getRecordInfo(this._docIdIterator.next());
            }
        };
    }

    private static Object getValue(PinotSegmentColumnReader columnReader, int docId) {
        Object value = columnReader.getValue(docId);
        return value instanceof byte[] ? new ByteArray((byte[])value) : value;
    }

    public static class PrimaryKeyReader
    implements Closeable {
        public final List<PinotSegmentColumnReader> _primaryKeyColumnReaders;

        public PrimaryKeyReader(IndexSegment segment, List<String> primaryKeyColumns) {
            this._primaryKeyColumnReaders = new ArrayList<PinotSegmentColumnReader>(primaryKeyColumns.size());
            for (String primaryKeyColumn : primaryKeyColumns) {
                this._primaryKeyColumnReaders.add(new PinotSegmentColumnReader(segment, primaryKeyColumn));
            }
        }

        public PrimaryKey getPrimaryKey(int docId) {
            int numPrimaryKeys = this._primaryKeyColumnReaders.size();
            Object[] values = new Object[numPrimaryKeys];
            for (int i = 0; i < numPrimaryKeys; ++i) {
                values[i] = UpsertUtils.getValue(this._primaryKeyColumnReaders.get(i), docId);
            }
            return new PrimaryKey(values);
        }

        public void getPrimaryKey(int docId, PrimaryKey buffer) {
            Object[] values = buffer.getValues();
            int numPrimaryKeys = values.length;
            for (int i = 0; i < numPrimaryKeys; ++i) {
                values[i] = UpsertUtils.getValue(this._primaryKeyColumnReaders.get(i), docId);
            }
        }

        @Override
        public void close() throws IOException {
            for (PinotSegmentColumnReader primaryKeyColumnReader : this._primaryKeyColumnReaders) {
                primaryKeyColumnReader.close();
            }
        }
    }

    public static class RecordInfoReader
    implements Closeable {
        public final PrimaryKeyReader _primaryKeyReader;
        public final PinotSegmentColumnReader _comparisonColumnReader;

        public RecordInfoReader(IndexSegment segment, List<String> primaryKeyColumns, String comparisonColumn) {
            this._primaryKeyReader = new PrimaryKeyReader(segment, primaryKeyColumns);
            this._comparisonColumnReader = new PinotSegmentColumnReader(segment, comparisonColumn);
        }

        public RecordInfo getRecordInfo(int docId) {
            PrimaryKey primaryKey = this._primaryKeyReader.getPrimaryKey(docId);
            Comparable comparisonValue = (Comparable)UpsertUtils.getValue(this._comparisonColumnReader, docId);
            return new RecordInfo(primaryKey, docId, comparisonValue);
        }

        @Override
        public void close() throws IOException {
            this._primaryKeyReader.close();
            this._comparisonColumnReader.close();
        }
    }
}

