/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.upsert;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMerger;
import org.apache.pinot.segment.local.upsert.merger.PartialUpsertMergerFactory;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class PartialUpsertHandler {
    private final Map<String, PartialUpsertMerger> _column2Mergers = new HashMap<String, PartialUpsertMerger>();
    private final PartialUpsertMerger _defaultPartialUpsertMerger;
    private final String _comparisonColumn;
    private final List<String> _primaryKeyColumns;

    public PartialUpsertHandler(Schema schema, Map<String, UpsertConfig.Strategy> partialUpsertStrategies, UpsertConfig.Strategy defaultPartialUpsertStrategy, String comparisonColumn) {
        this._defaultPartialUpsertMerger = PartialUpsertMergerFactory.getMerger(defaultPartialUpsertStrategy);
        this._comparisonColumn = comparisonColumn;
        this._primaryKeyColumns = schema.getPrimaryKeyColumns();
        for (Map.Entry<String, UpsertConfig.Strategy> entry : partialUpsertStrategies.entrySet()) {
            this._column2Mergers.put(entry.getKey(), PartialUpsertMergerFactory.getMerger(entry.getValue()));
        }
    }

    public GenericRow merge(GenericRow previousRecord, GenericRow newRecord) {
        for (String column : previousRecord.getFieldToValueMap().keySet()) {
            if (this._primaryKeyColumns.contains(column) || this._comparisonColumn.equals(column) || previousRecord.isNullValue(column)) continue;
            if (newRecord.isNullValue(column)) {
                newRecord.putValue(column, previousRecord.getValue(column));
                newRecord.removeNullValueField(column);
                continue;
            }
            PartialUpsertMerger merger = this._column2Mergers.getOrDefault(column, this._defaultPartialUpsertMerger);
            newRecord.putValue(column, merger.merge(previousRecord.getValue(column), newRecord.getValue(column)));
        }
        return newRecord;
    }
}

