/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.store;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.store.IndexKey;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.segment.spi.store.ColumnIndexDirectory;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.spi.utils.ReadMode;

class FilePerIndexDirectory
extends ColumnIndexDirectory {
    private final File _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;
    private final ReadMode _readMode;
    private final Map<IndexKey, PinotDataBuffer> _indexBuffers = new HashMap<IndexKey, PinotDataBuffer>();
    private PinotDataBuffer _starTreeIndexDataBuffer;

    protected FilePerIndexDirectory(File segmentDirectory, SegmentMetadataImpl segmentMetadata, ReadMode readMode) {
        Preconditions.checkNotNull((Object)segmentDirectory);
        Preconditions.checkNotNull((Object)readMode);
        Preconditions.checkNotNull((Object)segmentMetadata);
        Preconditions.checkArgument((boolean)segmentDirectory.exists(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " does not exist"));
        Preconditions.checkArgument((boolean)segmentDirectory.isDirectory(), (Object)("SegmentDirectory: " + segmentDirectory.toString() + " is not a directory"));
        this._segmentDirectory = segmentDirectory;
        this._segmentMetadata = segmentMetadata;
        this._readMode = readMode;
    }

    public void setSegmentMetadata(SegmentMetadataImpl segmentMetadata) {
        this._segmentMetadata = segmentMetadata;
    }

    public PinotDataBuffer getBuffer(String column, ColumnIndexType type) throws IOException {
        IndexKey key = new IndexKey(column, type);
        return this.getReadBufferFor(key);
    }

    public PinotDataBuffer getStarTreeIndex() throws IOException {
        if (this._starTreeIndexDataBuffer != null) {
            return this._starTreeIndexDataBuffer;
        }
        File indexFile = new File(this._segmentDirectory, "star_tree_index");
        this._starTreeIndexDataBuffer = this._readMode == ReadMode.heap ? PinotDataBuffer.loadFile((File)indexFile, (long)0L, (long)indexFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"Star-tree V2 data buffer") : PinotDataBuffer.mapFile((File)indexFile, (boolean)true, (long)0L, (long)indexFile.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)"Star-tree V2 data buffer");
        return this._starTreeIndexDataBuffer;
    }

    public InputStream getStarTreeIndexMap() throws IOException {
        return new FileInputStream(new File(this._segmentDirectory, "star_tree_index_map"));
    }

    public PinotDataBuffer newBuffer(String column, ColumnIndexType type, long sizeBytes) throws IOException {
        IndexKey key = new IndexKey(column, type);
        return this.getWriteBufferFor(key, sizeBytes);
    }

    public boolean hasIndexFor(String column, ColumnIndexType type) {
        File indexFile = this.getFileFor(column, type);
        return indexFile.exists();
    }

    public void close() throws IOException {
        for (PinotDataBuffer dataBuffer : this._indexBuffers.values()) {
            dataBuffer.close();
        }
        if (this._starTreeIndexDataBuffer != null) {
            this._starTreeIndexDataBuffer.close();
        }
    }

    public void removeIndex(String columnName, ColumnIndexType indexType) {
        this._indexBuffers.remove(new IndexKey(columnName, indexType));
        if (indexType == ColumnIndexType.TEXT_INDEX) {
            TextIndexUtils.cleanupTextIndex(this._segmentDirectory, columnName);
        } else {
            FileUtils.deleteQuietly((File)this.getFileFor(columnName, indexType));
        }
    }

    public Set<String> getColumnsWithIndex(ColumnIndexType type) {
        HashSet<String> columns = new HashSet<String>();
        for (String column : this._segmentMetadata.getAllColumns()) {
            if (!this.hasIndexFor(column, type)) continue;
            columns.add(column);
        }
        return columns;
    }

    private PinotDataBuffer getReadBufferFor(IndexKey key) throws IOException {
        if (this._indexBuffers.containsKey(key)) {
            return this._indexBuffers.get(key);
        }
        File file = this.getFileFor(key._name, key._type);
        if (!file.exists()) {
            throw new RuntimeException("Could not find index for column: " + key._name + ", type: " + key._type + ", segment: " + this._segmentDirectory.toString());
        }
        PinotDataBuffer buffer = this.mapForReads(file, key._type.toString() + ".reader");
        this._indexBuffers.put(key, buffer);
        return buffer;
    }

    private PinotDataBuffer getWriteBufferFor(IndexKey key, long sizeBytes) throws IOException {
        if (this._indexBuffers.containsKey(key)) {
            return this._indexBuffers.get(key);
        }
        File filename = this.getFileFor(key._name, key._type);
        PinotDataBuffer buffer = this.mapForWrites(filename, sizeBytes, key._type.toString() + ".writer");
        this._indexBuffers.put(key, buffer);
        return buffer;
    }

    @VisibleForTesting
    File getFileFor(String column, ColumnIndexType indexType) {
        String fileExtension;
        switch (indexType) {
            case DICTIONARY: {
                fileExtension = ".dict";
                break;
            }
            case FORWARD_INDEX: {
                ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
                if (columnMetadata.isSingleValue()) {
                    if (!columnMetadata.hasDictionary()) {
                        fileExtension = ".sv.raw.fwd";
                        break;
                    }
                    if (columnMetadata.isSorted()) {
                        fileExtension = ".sv.sorted.fwd";
                        break;
                    }
                    fileExtension = ".sv.unsorted.fwd";
                    break;
                }
                if (!columnMetadata.hasDictionary()) {
                    fileExtension = ".mv.raw.fwd";
                    break;
                }
                fileExtension = ".mv.fwd";
                break;
            }
            case INVERTED_INDEX: {
                fileExtension = ".bitmap.inv";
                break;
            }
            case RANGE_INDEX: {
                fileExtension = ".bitmap.range";
                break;
            }
            case BLOOM_FILTER: {
                fileExtension = ".bloom";
                break;
            }
            case NULLVALUE_VECTOR: {
                fileExtension = ".bitmap.nullvalue";
                break;
            }
            case TEXT_INDEX: {
                fileExtension = ".lucene.index";
                break;
            }
            case FST_INDEX: {
                fileExtension = ".lucene.fst";
                break;
            }
            case JSON_INDEX: {
                fileExtension = ".json.idx";
                break;
            }
            case H3_INDEX: {
                fileExtension = ".h3.idx";
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported index type: " + indexType);
            }
        }
        return new File(this._segmentDirectory, column + fileExtension);
    }

    private PinotDataBuffer mapForWrites(File file, long sizeBytes, String context) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkArgument((sizeBytes >= 0L && sizeBytes < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)("File size must be less than 2GB, file: " + file));
        Preconditions.checkState((!file.exists() ? 1 : 0) != 0, (Object)("File: " + file + " already exists"));
        String allocationContext = this.allocationContext(file, context);
        return PinotDataBuffer.mapFile((File)file, (boolean)false, (long)0L, (long)sizeBytes, (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
    }

    private PinotDataBuffer mapForReads(File file, String context) throws IOException {
        Preconditions.checkNotNull((Object)file);
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkArgument((boolean)file.exists(), (Object)("File: " + file + " must exist"));
        Preconditions.checkArgument((boolean)file.isFile(), (Object)("File: " + file + " must be a regular file"));
        String allocationContext = this.allocationContext(file, context);
        if (this._readMode == ReadMode.heap) {
            return PinotDataBuffer.loadFile((File)file, (long)0L, (long)file.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
        }
        return PinotDataBuffer.mapFile((File)file, (boolean)true, (long)0L, (long)file.length(), (ByteOrder)ByteOrder.BIG_ENDIAN, (String)allocationContext);
    }
}

