/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.forward;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.segment.index.readers.forward.BaseChunkForwardIndexReader;
import org.apache.pinot.segment.local.segment.index.readers.forward.ChunkReaderContext;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;

public final class FixedBytePower2ChunkSVForwardIndexReader
extends BaseChunkForwardIndexReader {
    public static final int VERSION = 4;
    private final int _shift;

    public FixedBytePower2ChunkSVForwardIndexReader(PinotDataBuffer dataBuffer, FieldSpec.DataType valueType) {
        super(dataBuffer, valueType, true);
        this._shift = Integer.numberOfTrailingZeros(this._numDocsPerChunk);
    }

    @Nullable
    public ChunkReaderContext createContext() {
        if (this._isCompressed) {
            return new ChunkReaderContext(this._numDocsPerChunk * this._storedType.size());
        }
        return null;
    }

    public int getInt(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId & this._numDocsPerChunk - 1;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getInt(chunkRowId * 4);
        }
        return this._rawData.getInt(docId * 4);
    }

    public long getLong(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId & this._numDocsPerChunk - 1;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getLong(chunkRowId * 8);
        }
        return this._rawData.getLong(docId * 8);
    }

    public float getFloat(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId & this._numDocsPerChunk - 1;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getFloat(chunkRowId * 4);
        }
        return this._rawData.getFloat(docId * 4);
    }

    public double getDouble(int docId, ChunkReaderContext context) {
        if (this._isCompressed) {
            int chunkRowId = docId & this._numDocsPerChunk - 1;
            ByteBuffer chunkBuffer = this.getChunkBuffer(docId, context);
            return chunkBuffer.getDouble(chunkRowId * 8);
        }
        return this._rawData.getDouble(docId * 8);
    }

    @Override
    protected ByteBuffer getChunkBuffer(int docId, ChunkReaderContext context) {
        int chunkId = docId >>> this._shift;
        if (context.getChunkId() == chunkId) {
            return context.getChunkBuffer();
        }
        return this.decompressChunk(chunkId, context);
    }
}

