/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers.bloom;

import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Longs;
import java.nio.charset.StandardCharsets;

public class GuavaBloomFilterReaderUtils {
    private static final HashFunction HASH_FUNCTION = Hashing.murmur3_128();

    private GuavaBloomFilterReaderUtils() {
    }

    public static byte[] hash(String value) {
        return HASH_FUNCTION.hashBytes(value.getBytes(StandardCharsets.UTF_8)).asBytes();
    }

    public static Hash128AsLongs hashAsLongs(String value) {
        byte[] hash = GuavaBloomFilterReaderUtils.hash(value);
        return new Hash128AsLongs(Longs.fromBytes((byte)hash[7], (byte)hash[6], (byte)hash[5], (byte)hash[4], (byte)hash[3], (byte)hash[2], (byte)hash[1], (byte)hash[0]), Longs.fromBytes((byte)hash[15], (byte)hash[14], (byte)hash[13], (byte)hash[12], (byte)hash[11], (byte)hash[10], (byte)hash[9], (byte)hash[8]));
    }

    public static double computeFPP(int sizeInBytes, int numInsertions) {
        double b = (double)sizeInBytes * 8.0 / (double)numInsertions;
        double k = b * Math.log(2.0);
        return Math.pow(2.0, -k);
    }

    public static class Hash128AsLongs {
        private final long _hash1;
        private final long _hash2;

        private Hash128AsLongs(long hash1, long hash2) {
            this._hash1 = hash1;
            this._hash2 = hash2;
        }

        public long getHash1() {
            return this._hash1;
        }

        public long getHash2() {
            return this._hash2;
        }
    }
}

