/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class OnHeapBigDecimalDictionary
extends BaseImmutableDictionary {
    private final BigDecimal[] _dictIdToVal;

    public OnHeapBigDecimalDictionary(PinotDataBuffer dataBuffer, int length, int numBytesPerValue) {
        super(dataBuffer, length, numBytesPerValue, (byte)0);
        this._dictIdToVal = new BigDecimal[length];
        for (int dictId = 0; dictId < length; ++dictId) {
            this._dictIdToVal[dictId] = this.getBigDecimal(dictId);
        }
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BIG_DECIMAL;
    }

    public int indexOf(BigDecimal bigDecimalValue) {
        return this.normalizeIndex(Arrays.binarySearch(this._dictIdToVal, bigDecimalValue));
    }

    public int insertionIndexOf(String stringValue) {
        return Arrays.binarySearch(this._dictIdToVal, new BigDecimal(stringValue));
    }

    public BigDecimal get(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public int getIntValue(int dictId) {
        return this._dictIdToVal[dictId].intValue();
    }

    public long getLongValue(int dictId) {
        return this._dictIdToVal[dictId].longValue();
    }

    public float getFloatValue(int dictId) {
        return this._dictIdToVal[dictId].floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this._dictIdToVal[dictId].doubleValue();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return this._dictIdToVal[dictId];
    }

    public String getStringValue(int dictId) {
        return this._dictIdToVal[dictId].toPlainString();
    }

    public byte[] getBytesValue(int dictId) {
        return BigDecimalUtils.serialize((BigDecimal)this._dictIdToVal[dictId]);
    }
}

