/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.RangeIndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.creator.CombinedInvertedIndexCreator;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexHandler.class);
    private final Set<String> _columnsToAddIdx;
    private final int _rangeIndexVersion;

    public RangeIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        super(segmentMetadata, indexLoadingConfig);
        this._columnsToAddIdx = indexLoadingConfig.getRangeIndexColumns();
        this._rangeIndexVersion = indexLoadingConfig.getRangeIndexVersion();
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.RANGE_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateRangeIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new range index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws IOException {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.RANGE_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.RANGE_INDEX);
            LOGGER.info("Removed existing range index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateRangeIndex(columnMetadata)) continue;
            this.createRangeIndexForColumn(segmentWriter, columnMetadata, (RangeIndexCreatorProvider)indexCreatorProvider, indexCreatorProvider);
        }
    }

    private boolean shouldCreateRangeIndex(ColumnMetadata columnMetadata) {
        return columnMetadata != null && !columnMetadata.isSorted();
    }

    private void createRangeIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, RangeIndexCreatorProvider rangeIndexCreatorProvider, IndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".range.inprogress");
        File rangeIndexFile = new File(indexDir, columnName + ".bitmap.range");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)rangeIndexFile);
        }
        this.createForwardIndexIfNeeded(segmentWriter, columnMetadata, indexCreatorProvider, true);
        LOGGER.info("Creating new range index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
        if (columnMetadata.hasDictionary()) {
            this.handleDictionaryBasedColumn(segmentWriter, columnMetadata, rangeIndexCreatorProvider);
        } else {
            this.handleNonDictionaryBasedColumn(segmentWriter, columnMetadata, rangeIndexCreatorProvider);
        }
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, rangeIndexFile, ColumnIndexType.RANGE_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created range index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }

    private void handleDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, RangeIndexCreatorProvider indexCreatorProvider) throws IOException {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             CombinedInvertedIndexCreator rangeIndexCreator = this.newRangeIndexCreator(columnMetadata, indexCreatorProvider);){
            if (columnMetadata.isSingleValue()) {
                for (int i = 0; i < numDocs; ++i) {
                    rangeIndexCreator.add(forwardIndexReader.getDictId(i, readerContext));
                }
            } else {
                int[] dictIds = new int[columnMetadata.getMaxNumberOfMultiValues()];
                for (int i = 0; i < numDocs; ++i) {
                    int length = forwardIndexReader.getDictIdMV(i, dictIds, readerContext);
                    rangeIndexCreator.add(dictIds, length);
                }
            }
            rangeIndexCreator.seal();
        }
    }

    private void handleNonDictionaryBasedColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, RangeIndexCreatorProvider indexCreatorProvider) throws IOException {
        int numDocs = columnMetadata.getTotalDocs();
        try (ForwardIndexReader<?> forwardIndexReader = LoaderUtils.getForwardIndexReader((SegmentDirectory.Reader)segmentWriter, columnMetadata);
             ForwardIndexReaderContext readerContext = forwardIndexReader.createContext();
             CombinedInvertedIndexCreator rangeIndexCreator = this.newRangeIndexCreator(columnMetadata, indexCreatorProvider);){
            block40: {
                block39: {
                    if (!columnMetadata.isSingleValue()) break block39;
                    switch (columnMetadata.getDataType()) {
                        case INT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getInt(i, readerContext));
                            }
                            break block40;
                        }
                        case LONG: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getLong(i, readerContext));
                            }
                            break block40;
                        }
                        case FLOAT: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getFloat(i, readerContext));
                            }
                            break block40;
                        }
                        case DOUBLE: {
                            for (int i = 0; i < numDocs; ++i) {
                                rangeIndexCreator.add(forwardIndexReader.getDouble(i, readerContext));
                            }
                            break block40;
                        }
                        default: {
                            throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                        }
                    }
                }
                int maxNumValuesPerMVEntry = columnMetadata.getMaxNumberOfMultiValues();
                switch (columnMetadata.getDataType()) {
                    case INT: {
                        int[] intValues = new int[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getIntMV(i, intValues, readerContext);
                            rangeIndexCreator.add(intValues, length);
                        }
                        break;
                    }
                    case LONG: {
                        long[] longValues = new long[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getLongMV(i, longValues, readerContext);
                            rangeIndexCreator.add(longValues, length);
                        }
                        break;
                    }
                    case FLOAT: {
                        float[] floatValues = new float[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getFloatMV(i, floatValues, readerContext);
                            rangeIndexCreator.add(floatValues, length);
                        }
                        break;
                    }
                    case DOUBLE: {
                        double[] doubleValues = new double[maxNumValuesPerMVEntry];
                        for (int i = 0; i < numDocs; ++i) {
                            int length = forwardIndexReader.getDoubleMV(i, doubleValues, readerContext);
                            rangeIndexCreator.add(doubleValues, length);
                        }
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported data type: " + columnMetadata.getDataType());
                    }
                }
            }
            rangeIndexCreator.seal();
        }
    }

    private CombinedInvertedIndexCreator newRangeIndexCreator(ColumnMetadata columnMetadata, RangeIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        return indexCreatorProvider.newRangeIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forRangeIndex(this._rangeIndexVersion));
    }
}

