/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader.invertedindex;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.BaseIndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.LoaderUtils;
import org.apache.pinot.segment.local.segment.index.readers.BaseImmutableDictionary;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreationContext;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.creator.TextIndexCreatorProvider;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.config.table.FSTType;
import org.apache.pinot.spi.data.FieldSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FSTIndexHandler
extends BaseIndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(FSTIndexHandler.class);
    private final Set<String> _columnsToAddIdx;
    private final FSTType _fstType;

    public FSTIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        super(segmentMetadata, indexLoadingConfig);
        this._fstType = indexLoadingConfig.getFSTIndexType();
        this._columnsToAddIdx = indexLoadingConfig.getFSTIndexColumns();
    }

    @Override
    public boolean needUpdateIndices(SegmentDirectory.Reader segmentReader) {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentReader.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.FST_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Need to remove existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateFSTIndex(columnMetadata)) continue;
            LOGGER.info("Need to create new FST index for segment: {}, column: {}", (Object)segmentName, (Object)column);
            return true;
        }
        return false;
    }

    @Override
    public void updateIndices(SegmentDirectory.Writer segmentWriter, IndexCreatorProvider indexCreatorProvider) throws Exception {
        String segmentName = this._segmentMetadata.getName();
        HashSet<String> columnsToAddIdx = new HashSet<String>(this._columnsToAddIdx);
        Set existingColumns = segmentWriter.toSegmentDirectory().getColumnsWithIndex(ColumnIndexType.FST_INDEX);
        for (String column : existingColumns) {
            if (columnsToAddIdx.remove(column)) continue;
            LOGGER.info("Removing existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
            segmentWriter.removeIndex(column, ColumnIndexType.FST_INDEX);
            LOGGER.info("Removed existing FST index from segment: {}, column: {}", (Object)segmentName, (Object)column);
        }
        for (String column : columnsToAddIdx) {
            ColumnMetadata columnMetadata = this._segmentMetadata.getColumnMetadataFor(column);
            if (!this.shouldCreateFSTIndex(columnMetadata)) continue;
            this.createFSTIndexForColumn(segmentWriter, columnMetadata, (TextIndexCreatorProvider)indexCreatorProvider);
        }
    }

    @Override
    public void postUpdateIndicesCleanup(SegmentDirectory.Writer segmentWriter) throws Exception {
    }

    private boolean shouldCreateFSTIndex(ColumnMetadata columnMetadata) {
        if (columnMetadata != null) {
            this.checkUnsupportedOperationsForFSTIndex(columnMetadata);
            return true;
        }
        return false;
    }

    private void checkUnsupportedOperationsForFSTIndex(ColumnMetadata columnMetadata) {
        String column = columnMetadata.getColumnName();
        if (columnMetadata.getDataType() != FieldSpec.DataType.STRING) {
            throw new UnsupportedOperationException("FST index is currently only supported on STRING columns: " + column);
        }
        if (!columnMetadata.hasDictionary()) {
            throw new UnsupportedOperationException("FST index is currently only supported on dictionary encoded columns: " + column);
        }
        if (!columnMetadata.isSingleValue()) {
            throw new UnsupportedOperationException("FST index is currently not supported on multi-value columns: " + column);
        }
    }

    private void createFSTIndexForColumn(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, TextIndexCreatorProvider indexCreatorProvider) throws IOException {
        File indexDir = this._segmentMetadata.getIndexDir();
        String segmentName = this._segmentMetadata.getName();
        String columnName = columnMetadata.getColumnName();
        File inProgress = new File(indexDir, columnName + ".fst.inprogress");
        File fstIndexFile = new File(indexDir, columnName + ".lucene.fst");
        if (!inProgress.exists()) {
            FileUtils.touch((File)inProgress);
        } else {
            FileUtils.deleteQuietly((File)fstIndexFile);
        }
        LOGGER.info("Creating new FST index for column: {} in segment: {}, cardinality: {}", new Object[]{columnName, segmentName, columnMetadata.getCardinality()});
        TextIndexCreator fstIndexCreator = indexCreatorProvider.newTextIndexCreator(IndexCreationContext.builder().withIndexDir(indexDir).withColumnMetadata(columnMetadata).build().forFSTIndex(this._fstType, null));
        try (BaseImmutableDictionary dictionary = LoaderUtils.getDictionary((SegmentDirectory.Reader)segmentWriter, columnMetadata);){
            for (int dictId = 0; dictId < dictionary.length(); ++dictId) {
                fstIndexCreator.add(dictionary.getStringValue(dictId));
            }
        }
        fstIndexCreator.seal();
        if (this._segmentMetadata.getVersion() == SegmentVersion.v3) {
            LoaderUtils.writeIndexToV3Format(segmentWriter, columnName, fstIndexFile, ColumnIndexType.FST_INDEX);
        }
        FileUtils.deleteQuietly((File)inProgress);
        LOGGER.info("Created FST index for segment: {}, column: {}", (Object)segmentName, (Object)columnName);
    }
}

