/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandlerFactory;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGenerator;
import org.apache.pinot.segment.local.segment.index.loader.columnminmaxvalue.ColumnMinMaxValueGeneratorMode;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandler;
import org.apache.pinot.segment.local.segment.index.loader.defaultcolumn.DefaultColumnHandlerFactory;
import org.apache.pinot.segment.local.startree.StarTreeBuilderUtils;
import org.apache.pinot.segment.local.startree.v2.builder.MultipleTreesBuilder;
import org.apache.pinot.segment.local.startree.v2.builder.StarTreeV2BuilderConfig;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.index.IndexingOverrides;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.apache.pinot.spi.data.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentPreProcessor
implements AutoCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentPreProcessor.class);
    private final URI _indexDirURI;
    private final IndexLoadingConfig _indexLoadingConfig;
    private final Schema _schema;
    private final SegmentDirectory _segmentDirectory;
    private SegmentMetadataImpl _segmentMetadata;

    public SegmentPreProcessor(SegmentDirectory segmentDirectory, IndexLoadingConfig indexLoadingConfig, @Nullable Schema schema) {
        this._segmentDirectory = segmentDirectory;
        this._indexDirURI = segmentDirectory.getIndexDir();
        this._indexLoadingConfig = indexLoadingConfig;
        this._schema = schema;
        this._segmentMetadata = segmentDirectory.getSegmentMetadata();
    }

    @Override
    public void close() throws Exception {
        this._segmentDirectory.close();
    }

    public void process() throws Exception {
        if (this._segmentMetadata.getTotalDocs() == 0) {
            LOGGER.info("Skip preprocessing empty segment: {}", (Object)this._segmentMetadata.getName());
            return;
        }
        File indexDir = new File(this._indexDirURI);
        this.removeInvertedIndexTempFiles(indexDir);
        try (SegmentDirectory.Writer segmentWriter = this._segmentDirectory.createWriter();){
            if (this._schema != null) {
                DefaultColumnHandler defaultColumnHandler = DefaultColumnHandlerFactory.getDefaultColumnHandler(indexDir, this._segmentMetadata, this._indexLoadingConfig, this._schema, segmentWriter);
                defaultColumnHandler.updateDefaultColumns();
                this._segmentMetadata = new SegmentMetadataImpl(indexDir);
                this._segmentDirectory.reloadMetadata();
            } else {
                LOGGER.warn("Skip creating default columns for segment: {} without schema", (Object)this._segmentMetadata.getName());
            }
            IndexCreatorProvider indexCreatorProvider = IndexingOverrides.getIndexCreatorProvider();
            ArrayList<IndexHandler> indexHandlers = new ArrayList<IndexHandler>();
            for (ColumnIndexType type : ColumnIndexType.values()) {
                IndexHandler handler = IndexHandlerFactory.getIndexHandler(type, this._segmentMetadata, this._indexLoadingConfig, this._schema);
                indexHandlers.add(handler);
                handler.updateIndices(segmentWriter, indexCreatorProvider);
                if (type != ColumnIndexType.FORWARD_INDEX) continue;
                this._segmentMetadata = new SegmentMetadataImpl(indexDir);
                this._segmentDirectory.reloadMetadata();
            }
            this.processStarTrees(indexDir);
            for (IndexHandler handler : indexHandlers) {
                handler.postUpdateIndicesCleanup(segmentWriter);
            }
            ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode = this._indexLoadingConfig.getColumnMinMaxValueGeneratorMode();
            if (columnMinMaxValueGeneratorMode != ColumnMinMaxValueGeneratorMode.NONE) {
                ColumnMinMaxValueGenerator columnMinMaxValueGenerator = new ColumnMinMaxValueGenerator((SegmentMetadata)this._segmentMetadata, segmentWriter, columnMinMaxValueGeneratorMode);
                columnMinMaxValueGenerator.addColumnMinMaxValue();
            }
            segmentWriter.save();
        }
    }

    public boolean needProcess() throws Exception {
        if (this._segmentMetadata.getTotalDocs() == 0) {
            return false;
        }
        try (SegmentDirectory.Reader segmentReader = this._segmentDirectory.createReader();){
            DefaultColumnHandler defaultColumnHandler;
            if (this._schema != null && (defaultColumnHandler = DefaultColumnHandlerFactory.getDefaultColumnHandler(null, this._segmentMetadata, this._indexLoadingConfig, this._schema, null)).needUpdateDefaultColumns()) {
                LOGGER.info("Found default columns need updates");
                boolean bl = true;
                return bl;
            }
            for (ColumnIndexType type : ColumnIndexType.values()) {
                if (!IndexHandlerFactory.getIndexHandler(type, this._segmentMetadata, this._indexLoadingConfig, this._schema).needUpdateIndices(segmentReader)) continue;
                LOGGER.info("Found index type: {} needs updates", (Object)type);
                boolean bl = true;
                return bl;
            }
            if (this.needProcessStarTrees()) {
                LOGGER.info("Found startree index needs updates");
                boolean bl = true;
                return bl;
            }
            if (this.needUpdateColumnMinMaxValue()) {
                LOGGER.info("Found min max values need updates");
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean needUpdateColumnMinMaxValue() {
        ColumnMinMaxValueGeneratorMode columnMinMaxValueGeneratorMode = this._indexLoadingConfig.getColumnMinMaxValueGeneratorMode();
        if (columnMinMaxValueGeneratorMode == ColumnMinMaxValueGeneratorMode.NONE) {
            return false;
        }
        ColumnMinMaxValueGenerator columnMinMaxValueGenerator = new ColumnMinMaxValueGenerator((SegmentMetadata)this._segmentMetadata, null, columnMinMaxValueGeneratorMode);
        return columnMinMaxValueGenerator.needAddColumnMinMaxValue();
    }

    private boolean needProcessStarTrees() {
        if (!this._indexLoadingConfig.isEnableDynamicStarTreeCreation()) {
            return false;
        }
        List<StarTreeV2BuilderConfig> starTreeBuilderConfigs = StarTreeBuilderUtils.generateBuilderConfigs(this._indexLoadingConfig.getStarTreeIndexConfigs(), this._indexLoadingConfig.isEnableDefaultStarTree(), (SegmentMetadata)this._segmentMetadata);
        List starTreeMetadataList = this._segmentMetadata.getStarTreeV2MetadataList();
        if (starTreeMetadataList != null && !StarTreeBuilderUtils.shouldRemoveExistingStarTrees(starTreeBuilderConfigs, starTreeMetadataList)) {
            return false;
        }
        return !starTreeBuilderConfigs.isEmpty();
    }

    private void processStarTrees(File indexDir) throws Exception {
        if (this._indexLoadingConfig.isEnableDynamicStarTreeCreation()) {
            List<StarTreeV2BuilderConfig> starTreeBuilderConfigs = StarTreeBuilderUtils.generateBuilderConfigs(this._indexLoadingConfig.getStarTreeIndexConfigs(), this._indexLoadingConfig.isEnableDefaultStarTree(), (SegmentMetadata)this._segmentMetadata);
            boolean shouldGenerateStarTree = !starTreeBuilderConfigs.isEmpty();
            List starTreeMetadataList = this._segmentMetadata.getStarTreeV2MetadataList();
            if (starTreeMetadataList != null) {
                if (StarTreeBuilderUtils.shouldRemoveExistingStarTrees(starTreeBuilderConfigs, starTreeMetadataList)) {
                    LOGGER.info("Removing star-trees from segment: {}", (Object)this._segmentMetadata.getName());
                    StarTreeBuilderUtils.removeStarTrees(indexDir);
                    this._segmentMetadata = new SegmentMetadataImpl(indexDir);
                } else {
                    shouldGenerateStarTree = false;
                }
            }
            if (shouldGenerateStarTree) {
                try (MultipleTreesBuilder builder = new MultipleTreesBuilder(starTreeBuilderConfigs, indexDir, MultipleTreesBuilder.BuildMode.OFF_HEAP);){
                    builder.build();
                }
                this._segmentMetadata = new SegmentMetadataImpl(indexDir);
            }
        }
    }

    private void removeInvertedIndexTempFiles(File indexDir) {
        File[] directoryListing = indexDir.listFiles();
        if (directoryListing == null) {
            return;
        }
        String tempFileExtension = ".bitmap.inv.tmp";
        for (File child : directoryListing) {
            if (!child.getName().endsWith(tempFileExtension)) continue;
            FileUtils.deleteQuietly((File)child);
        }
    }
}

