/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.text;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.pinot.segment.local.segment.store.TextIndexUtils;
import org.apache.pinot.segment.spi.index.creator.TextIndexCreator;

public class LuceneTextIndexCreator
implements TextIndexCreator {
    private static final int LUCENE_INDEX_MAX_BUFFER_SIZE_MB = 500;
    public static final String LUCENE_INDEX_DOC_ID_COLUMN_NAME = "DocID";
    private final String _textColumn;
    private final Directory _indexDirectory;
    private final IndexWriter _indexWriter;
    private int _nextDocId = 0;
    public static final CharArraySet ENGLISH_STOP_WORDS_SET = new CharArraySet(LuceneTextIndexCreator.getDefaultEnglishStopWordsSet(), true);

    public static HashSet<String> getDefaultEnglishStopWordsSet() {
        return new HashSet<String>(Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "than", "there", "these", "they", "this", "to", "was", "will", "with", "those"));
    }

    public LuceneTextIndexCreator(String column, File segmentIndexDir, boolean commit, @Nullable List<String> stopWordsInclude, @Nullable List<String> stopWordsExclude) {
        this._textColumn = column;
        try {
            File indexFile = this.getV1TextIndexFile(segmentIndexDir);
            this._indexDirectory = FSDirectory.open((Path)indexFile.toPath());
            StandardAnalyzer standardAnalyzer = TextIndexUtils.getStandardAnalyzerWithCustomizedStopWords(stopWordsInclude, stopWordsExclude);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig((Analyzer)standardAnalyzer);
            indexWriterConfig.setRAMBufferSizeMB(500.0);
            indexWriterConfig.setCommitOnClose(commit);
            this._indexWriter = new IndexWriter(this._indexDirectory, indexWriterConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while instantiating the LuceneTextIndexCreator for column: " + column, e);
        }
    }

    public IndexWriter getIndexWriter() {
        return this._indexWriter;
    }

    public void add(String document) {
        Document docToIndex = new Document();
        docToIndex.add((IndexableField)new TextField(this._textColumn, document, Field.Store.NO));
        docToIndex.add((IndexableField)new StoredField(LUCENE_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void add(String[] documents, int length) {
        Document docToIndex = new Document();
        for (int i = 0; i < length; ++i) {
            docToIndex.add((IndexableField)new TextField(this._textColumn, documents[i], Field.Store.NO));
        }
        docToIndex.add((IndexableField)new StoredField(LUCENE_INDEX_DOC_ID_COLUMN_NAME, this._nextDocId++));
        try {
            this._indexWriter.addDocument((Iterable)docToIndex);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while adding a new document to the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void seal() {
        try {
            this._indexWriter.forceMerge(1);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while sealing the Lucene index for column: " + this._textColumn, e);
        }
    }

    public void close() throws IOException {
        try {
            this._indexWriter.close();
            this._indexDirectory.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while closing the Lucene index for column: " + this._textColumn, e);
        }
    }

    private File getV1TextIndexFile(File indexDir) {
        String luceneIndexDirectory = this._textColumn + ".lucene.index";
        return new File(indexDir, luceneIndexDirectory);
    }
}

