/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv.json;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.pinot.segment.local.io.util.VarLengthValueWriter;
import org.apache.pinot.segment.local.segment.creator.impl.inv.BitmapInvertedIndexWriter;
import org.apache.pinot.segment.local.segment.creator.impl.inv.json.BaseJsonIndexCreator;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.roaringbitmap.RoaringBitmap;
import org.roaringbitmap.RoaringBitmapWriter;

public class OnHeapJsonIndexCreator
extends BaseJsonIndexCreator {
    public OnHeapJsonIndexCreator(File indexDir, String columnName, JsonIndexConfig jsonIndexConfig) throws IOException {
        super(indexDir, columnName, jsonIndexConfig);
    }

    public void seal() throws IOException {
        int numPostingLists = this._postingListMap.size();
        try (VarLengthValueWriter dictionaryWriter = new VarLengthValueWriter(this._dictionaryFile, numPostingLists);
             BitmapInvertedIndexWriter invertedIndexWriter = new BitmapInvertedIndexWriter(this._invertedIndexFile, numPostingLists);){
            for (Map.Entry entry : this._postingListMap.entrySet()) {
                byte[] valueBytes = ((String)entry.getKey()).getBytes(StandardCharsets.UTF_8);
                this._maxValueLength = Integer.max(this._maxValueLength, valueBytes.length);
                dictionaryWriter.add(valueBytes);
                invertedIndexWriter.add((RoaringBitmap)((RoaringBitmapWriter)entry.getValue()).get());
            }
        }
        this.generateIndexFile();
    }
}

