/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.inv;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import org.apache.pinot.segment.spi.memory.CleanerUtil;
import org.roaringbitmap.RoaringBitmap;

public final class BitmapInvertedIndexWriter
implements Closeable {
    private static final long MAX_INITIAL_BUFFER_SIZE = 0x10000000L;
    private static final long PESSIMISTIC_BITMAP_SIZE_ESTIMATE = 131072L;
    private final FileChannel _fileChannel;
    private final ByteBuffer _offsetBuffer;
    private ByteBuffer _bitmapBuffer;
    private long _bytesWritten;

    public BitmapInvertedIndexWriter(File outputFile, int numBitmaps) throws IOException {
        int sizeForOffsets = (numBitmaps + 1) * 4;
        long bitmapBufferEstimate = Math.min(131072L * (long)numBitmaps, 0x10000000L);
        this._fileChannel = new RandomAccessFile(outputFile, "rw").getChannel();
        this._offsetBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, 0L, sizeForOffsets);
        this._bytesWritten = sizeForOffsets;
        this.mapBitmapBuffer(bitmapBufferEstimate);
    }

    public void add(RoaringBitmap bitmap) throws IOException {
        int length = bitmap.serializedSizeInBytes();
        this.resizeIfNecessary(length);
        this._offsetBuffer.putInt(this.asUnsignedInt(this._bytesWritten));
        bitmap.serialize(this._bitmapBuffer);
        this._bytesWritten += (long)length;
    }

    public void add(byte[] bitmapBytes) throws IOException {
        this.add(bitmapBytes, bitmapBytes.length);
    }

    public void add(byte[] bitmapBytes, int length) throws IOException {
        this.resizeIfNecessary(length);
        this._offsetBuffer.putInt(this.asUnsignedInt(this._bytesWritten));
        this._bitmapBuffer.put(bitmapBytes, 0, length);
        this._bytesWritten += (long)length;
    }

    private void resizeIfNecessary(int required) throws IOException {
        if (this._bitmapBuffer.capacity() - required < this._bitmapBuffer.position()) {
            this.mapBitmapBuffer(Math.max(0x10000000L, (long)required));
        }
    }

    private void mapBitmapBuffer(long size) throws IOException {
        this.cleanBitmapBuffer();
        this._bitmapBuffer = this._fileChannel.map(FileChannel.MapMode.READ_WRITE, this._bytesWritten, size).order(ByteOrder.LITTLE_ENDIAN);
    }

    private void cleanBitmapBuffer() throws IOException {
        if (this._bitmapBuffer != null && CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.getCleaner().freeBuffer(this._bitmapBuffer);
        }
    }

    @Override
    public void close() throws IOException {
        long fileLength = this._bytesWritten;
        this._offsetBuffer.putInt(this.asUnsignedInt(fileLength));
        this._fileChannel.truncate(fileLength);
        this._fileChannel.close();
        if (CleanerUtil.UNMAP_SUPPORTED) {
            CleanerUtil.BufferCleaner cleaner = CleanerUtil.getCleaner();
            cleaner.freeBuffer(this._offsetBuffer);
            this.cleanBitmapBuffer();
        }
    }

    private int asUnsignedInt(long value) {
        Preconditions.checkArgument((value >>> 32 == 0L ? 1 : 0) != 0, (Object)"overflowed 4GB");
        return (int)(value & 0xFFFFFFFFL);
    }
}

