/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.StringUtil;

public class SanitizationTransformer
implements RecordTransformer {
    private final Map<String, Integer> _stringColumnMaxLengthMap = new HashMap<String, Integer>();

    public SanitizationTransformer(Schema schema) {
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getDataType() != FieldSpec.DataType.STRING) continue;
            this._stringColumnMaxLengthMap.put(fieldSpec.getName(), fieldSpec.getMaxLength());
        }
    }

    @Override
    public boolean isNoOp() {
        return this._stringColumnMaxLengthMap.isEmpty();
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, Integer> entry : this._stringColumnMaxLengthMap.entrySet()) {
            String stringColumn = entry.getKey();
            int maxLength = entry.getValue();
            Object value = record.getValue(stringColumn);
            if (value instanceof String) {
                String stringValue = (String)value;
                String sanitizedValue = StringUtil.sanitizeStringValue((String)stringValue, (int)maxLength);
                if (sanitizedValue == stringValue) continue;
                record.putValue(stringColumn, (Object)sanitizedValue);
                continue;
            }
            Object[] values = (Object[])value;
            int numValues = values.length;
            for (int i = 0; i < numValues; ++i) {
                values[i] = StringUtil.sanitizeStringValue((String)values[i].toString(), (int)maxLength);
            }
        }
        return record;
    }
}

