/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.common.metadata.segment.SegmentZKMetadata;
import org.apache.pinot.segment.local.dedup.PartitionDedupMetadataManager;
import org.apache.pinot.segment.local.realtime.impl.RealtimeSegmentStatsHistory;
import org.apache.pinot.segment.local.upsert.PartitionUpsertMetadataManager;
import org.apache.pinot.segment.spi.index.creator.H3IndexConfig;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.JsonIndexConfig;
import org.apache.pinot.spi.config.table.UpsertConfig;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.data.Schema;

public class RealtimeSegmentConfig {
    private final String _tableNameWithType;
    private final String _segmentName;
    private final String _streamName;
    private final Schema _schema;
    private final String _timeColumnName;
    private final int _capacity;
    private final int _avgNumMultiValues;
    private final Set<String> _noDictionaryColumns;
    private final Set<String> _varLengthDictionaryColumns;
    private final Set<String> _invertedIndexColumns;
    private final Set<String> _textIndexColumns;
    private final Set<String> _fstIndexColumns;
    private final Map<String, JsonIndexConfig> _jsonIndexConfigs;
    private final Map<String, H3IndexConfig> _h3IndexConfigs;
    private final SegmentZKMetadata _segmentZKMetadata;
    private final boolean _offHeap;
    private final PinotDataBufferMemoryManager _memoryManager;
    private final RealtimeSegmentStatsHistory _statsHistory;
    private final String _partitionColumn;
    private final PartitionFunction _partitionFunction;
    private final int _partitionId;
    private final boolean _aggregateMetrics;
    private final boolean _nullHandlingEnabled;
    private final UpsertConfig.Mode _upsertMode;
    private final String _upsertComparisonColumn;
    private final PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
    private final PartitionDedupMetadataManager _partitionDedupMetadataManager;
    private final String _consumerDir;
    private final List<FieldConfig> _fieldConfigList;
    private final List<AggregationConfig> _ingestionAggregationConfigs;

    private RealtimeSegmentConfig(String tableNameWithType, String segmentName, String streamName, Schema schema, String timeColumnName, int capacity, int avgNumMultiValues, Set<String> noDictionaryColumns, Set<String> varLengthDictionaryColumns, Set<String> invertedIndexColumns, Set<String> textIndexColumns, Set<String> fstIndexColumns, Map<String, JsonIndexConfig> jsonIndexConfigs, Map<String, H3IndexConfig> h3IndexConfigs, SegmentZKMetadata segmentZKMetadata, boolean offHeap, PinotDataBufferMemoryManager memoryManager, RealtimeSegmentStatsHistory statsHistory, String partitionColumn, PartitionFunction partitionFunction, int partitionId, boolean aggregateMetrics, boolean nullHandlingEnabled, String consumerDir, UpsertConfig.Mode upsertMode, String upsertComparisonColumn, PartitionUpsertMetadataManager partitionUpsertMetadataManager, PartitionDedupMetadataManager partitionDedupMetadataManager, List<FieldConfig> fieldConfigList, List<AggregationConfig> ingestionAggregationConfigs) {
        this._tableNameWithType = tableNameWithType;
        this._segmentName = segmentName;
        this._streamName = streamName;
        this._schema = schema;
        this._timeColumnName = timeColumnName;
        this._capacity = capacity;
        this._avgNumMultiValues = avgNumMultiValues;
        this._noDictionaryColumns = noDictionaryColumns;
        this._varLengthDictionaryColumns = varLengthDictionaryColumns;
        this._invertedIndexColumns = invertedIndexColumns;
        this._textIndexColumns = textIndexColumns;
        this._fstIndexColumns = fstIndexColumns;
        this._jsonIndexConfigs = jsonIndexConfigs;
        this._h3IndexConfigs = h3IndexConfigs;
        this._segmentZKMetadata = segmentZKMetadata;
        this._offHeap = offHeap;
        this._memoryManager = memoryManager;
        this._statsHistory = statsHistory;
        this._partitionColumn = partitionColumn;
        this._partitionFunction = partitionFunction;
        this._partitionId = partitionId;
        this._aggregateMetrics = aggregateMetrics;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._consumerDir = consumerDir;
        this._upsertMode = upsertMode != null ? upsertMode : UpsertConfig.Mode.NONE;
        this._upsertComparisonColumn = upsertComparisonColumn;
        this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
        this._partitionDedupMetadataManager = partitionDedupMetadataManager;
        this._fieldConfigList = fieldConfigList;
        this._ingestionAggregationConfigs = ingestionAggregationConfigs;
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public String getStreamName() {
        return this._streamName;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getTimeColumnName() {
        return this._timeColumnName;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public int getAvgNumMultiValues() {
        return this._avgNumMultiValues;
    }

    public Set<String> getNoDictionaryColumns() {
        return this._noDictionaryColumns;
    }

    public Set<String> getVarLengthDictionaryColumns() {
        return this._varLengthDictionaryColumns;
    }

    public Set<String> getInvertedIndexColumns() {
        return this._invertedIndexColumns;
    }

    public Set<String> getTextIndexColumns() {
        return this._textIndexColumns;
    }

    public Set<String> getFSTIndexColumns() {
        return this._fstIndexColumns;
    }

    public Map<String, JsonIndexConfig> getJsonIndexConfigs() {
        return this._jsonIndexConfigs;
    }

    public Map<String, H3IndexConfig> getH3IndexConfigs() {
        return this._h3IndexConfigs;
    }

    public SegmentZKMetadata getSegmentZKMetadata() {
        return this._segmentZKMetadata;
    }

    public boolean isOffHeap() {
        return this._offHeap;
    }

    public PinotDataBufferMemoryManager getMemoryManager() {
        return this._memoryManager;
    }

    public RealtimeSegmentStatsHistory getStatsHistory() {
        return this._statsHistory;
    }

    public String getPartitionColumn() {
        return this._partitionColumn;
    }

    public PartitionFunction getPartitionFunction() {
        return this._partitionFunction;
    }

    public int getPartitionId() {
        return this._partitionId;
    }

    public boolean aggregateMetrics() {
        return this._aggregateMetrics;
    }

    public boolean isNullHandlingEnabled() {
        return this._nullHandlingEnabled;
    }

    public String getConsumerDir() {
        return this._consumerDir;
    }

    public UpsertConfig.Mode getUpsertMode() {
        return this._upsertMode;
    }

    public boolean isDedupEnabled() {
        return this._partitionDedupMetadataManager != null;
    }

    public String getUpsertComparisonColumn() {
        return this._upsertComparisonColumn;
    }

    public PartitionUpsertMetadataManager getPartitionUpsertMetadataManager() {
        return this._partitionUpsertMetadataManager;
    }

    public PartitionDedupMetadataManager getPartitionDedupMetadataManager() {
        return this._partitionDedupMetadataManager;
    }

    public List<FieldConfig> getFieldConfigList() {
        return this._fieldConfigList;
    }

    public List<AggregationConfig> getIngestionAggregationConfigs() {
        return this._ingestionAggregationConfigs;
    }

    public static class Builder {
        private String _tableNameWithType;
        private String _segmentName;
        private String _streamName;
        private Schema _schema;
        private String _timeColumnName;
        private int _capacity;
        private int _avgNumMultiValues;
        private Set<String> _noDictionaryColumns;
        private Set<String> _varLengthDictionaryColumns;
        private Set<String> _invertedIndexColumns;
        private Set<String> _textIndexColumns = new HashSet<String>();
        private Set<String> _fstIndexColumns = new HashSet<String>();
        private Map<String, JsonIndexConfig> _jsonIndexConfigs = new HashMap<String, JsonIndexConfig>();
        private Map<String, H3IndexConfig> _h3IndexConfigs = new HashMap<String, H3IndexConfig>();
        private SegmentZKMetadata _segmentZKMetadata;
        private boolean _offHeap;
        private PinotDataBufferMemoryManager _memoryManager;
        private RealtimeSegmentStatsHistory _statsHistory;
        private String _partitionColumn;
        private PartitionFunction _partitionFunction;
        private int _partitionId;
        private boolean _aggregateMetrics = false;
        private boolean _nullHandlingEnabled = false;
        private String _consumerDir;
        private UpsertConfig.Mode _upsertMode;
        private String _upsertComparisonColumn;
        private PartitionUpsertMetadataManager _partitionUpsertMetadataManager;
        private PartitionDedupMetadataManager _partitionDedupMetadataManager;
        private List<FieldConfig> _fieldConfigList;
        private List<AggregationConfig> _ingestionAggregationConfigs;

        public Builder setTableNameWithType(String tableNameWithType) {
            this._tableNameWithType = tableNameWithType;
            return this;
        }

        public Builder setSegmentName(String segmentName) {
            this._segmentName = segmentName;
            return this;
        }

        public Builder setStreamName(String streamName) {
            this._streamName = streamName;
            return this;
        }

        public Builder setSchema(Schema schema) {
            this._schema = schema;
            return this;
        }

        public Builder setTimeColumnName(String timeColumnName) {
            this._timeColumnName = timeColumnName;
            return this;
        }

        public Builder setCapacity(int capacity) {
            this._capacity = capacity;
            return this;
        }

        public Builder setAvgNumMultiValues(int avgNumMultiValues) {
            this._avgNumMultiValues = avgNumMultiValues;
            return this;
        }

        public Builder setNoDictionaryColumns(Set<String> noDictionaryColumns) {
            this._noDictionaryColumns = noDictionaryColumns;
            return this;
        }

        public Builder setVarLengthDictionaryColumns(Set<String> varLengthDictionaryColumns) {
            this._varLengthDictionaryColumns = varLengthDictionaryColumns;
            return this;
        }

        public Builder setInvertedIndexColumns(Set<String> invertedIndexColumns) {
            this._invertedIndexColumns = invertedIndexColumns;
            return this;
        }

        public Builder setTextIndexColumns(Set<String> textIndexColumns) {
            this._textIndexColumns = textIndexColumns;
            return this;
        }

        public Builder setFSTIndexColumns(Set<String> fstIndexColumns) {
            this._fstIndexColumns = fstIndexColumns;
            return this;
        }

        public Builder setJsonIndexConfigs(Map<String, JsonIndexConfig> jsonIndexConfigs) {
            this._jsonIndexConfigs = jsonIndexConfigs;
            return this;
        }

        public Builder setH3IndexConfigs(Map<String, H3IndexConfig> h3IndexConfigs) {
            this._h3IndexConfigs = h3IndexConfigs;
            return this;
        }

        public Builder setSegmentZKMetadata(SegmentZKMetadata segmentZKMetadata) {
            this._segmentZKMetadata = segmentZKMetadata;
            return this;
        }

        public Builder setOffHeap(boolean offHeap) {
            this._offHeap = offHeap;
            return this;
        }

        public Builder setMemoryManager(PinotDataBufferMemoryManager memoryManager) {
            this._memoryManager = memoryManager;
            return this;
        }

        public Builder setStatsHistory(RealtimeSegmentStatsHistory statsHistory) {
            this._statsHistory = statsHistory;
            return this;
        }

        public Builder setPartitionColumn(String partitionColumn) {
            this._partitionColumn = partitionColumn;
            return this;
        }

        public Builder setPartitionFunction(PartitionFunction partitionFunction) {
            this._partitionFunction = partitionFunction;
            return this;
        }

        public Builder setPartitionId(int partitionId) {
            this._partitionId = partitionId;
            return this;
        }

        public Builder setAggregateMetrics(boolean aggregateMetrics) {
            this._aggregateMetrics = aggregateMetrics;
            return this;
        }

        public Builder setNullHandlingEnabled(boolean nullHandlingEnabled) {
            this._nullHandlingEnabled = nullHandlingEnabled;
            return this;
        }

        public Builder setConsumerDir(String consumerDir) {
            this._consumerDir = consumerDir;
            return this;
        }

        public Builder setUpsertMode(UpsertConfig.Mode upsertMode) {
            this._upsertMode = upsertMode;
            return this;
        }

        public Builder setUpsertComparisonColumn(String upsertComparisonColumn) {
            this._upsertComparisonColumn = upsertComparisonColumn;
            return this;
        }

        public Builder setPartitionUpsertMetadataManager(PartitionUpsertMetadataManager partitionUpsertMetadataManager) {
            this._partitionUpsertMetadataManager = partitionUpsertMetadataManager;
            return this;
        }

        public Builder setPartitionDedupMetadataManager(PartitionDedupMetadataManager partitionDedupMetadataManager) {
            this._partitionDedupMetadataManager = partitionDedupMetadataManager;
            return this;
        }

        public Builder setFieldConfigList(List<FieldConfig> fieldConfigList) {
            this._fieldConfigList = fieldConfigList;
            return this;
        }

        public Builder setIngestionAggregationConfigs(List<AggregationConfig> ingestionAggregationConfigs) {
            this._ingestionAggregationConfigs = ingestionAggregationConfigs;
            return this;
        }

        public RealtimeSegmentConfig build() {
            return new RealtimeSegmentConfig(this._tableNameWithType, this._segmentName, this._streamName, this._schema, this._timeColumnName, this._capacity, this._avgNumMultiValues, this._noDictionaryColumns, this._varLengthDictionaryColumns, this._invertedIndexColumns, this._textIndexColumns, this._fstIndexColumns, this._jsonIndexConfigs, this._h3IndexConfigs, this._segmentZKMetadata, this._offHeap, this._memoryManager, this._statsHistory, this._partitionColumn, this._partitionFunction, this._partitionId, this._aggregateMetrics, this._nullHandlingEnabled, this._consumerDir, this._upsertMode, this._upsertComparisonColumn, this._partitionUpsertMetadataManager, this._partitionDedupMetadataManager, this._fieldConfigList, this._ingestionAggregationConfigs);
        }
    }
}

