/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import org.apache.pinot.segment.local.io.compression.LZ4Compressor;
import org.apache.pinot.segment.local.io.compression.LZ4Decompressor;
import org.apache.pinot.segment.local.io.compression.LZ4WithLengthCompressor;
import org.apache.pinot.segment.local.io.compression.LZ4WithLengthDecompressor;
import org.apache.pinot.segment.local.io.compression.PassThroughCompressor;
import org.apache.pinot.segment.local.io.compression.PassThroughDecompressor;
import org.apache.pinot.segment.local.io.compression.SnappyCompressor;
import org.apache.pinot.segment.local.io.compression.SnappyDecompressor;
import org.apache.pinot.segment.local.io.compression.ZstandardCompressor;
import org.apache.pinot.segment.local.io.compression.ZstandardDecompressor;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;
import org.apache.pinot.segment.spi.compression.ChunkDecompressor;

public class ChunkCompressorFactory {
    private ChunkCompressorFactory() {
    }

    public static ChunkCompressor getCompressor(ChunkCompressionType compressionType) {
        return ChunkCompressorFactory.getCompressor(compressionType, false);
    }

    public static ChunkCompressor getCompressor(ChunkCompressionType compressionType, boolean upgradeToLengthPrefixed) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return PassThroughCompressor.INSTANCE;
            }
            case SNAPPY: {
                return SnappyCompressor.INSTANCE;
            }
            case ZSTANDARD: {
                return ZstandardCompressor.INSTANCE;
            }
            case LZ4: {
                return upgradeToLengthPrefixed ? LZ4WithLengthCompressor.INSTANCE : LZ4Compressor.INSTANCE;
            }
            case LZ4_LENGTH_PREFIXED: {
                return LZ4WithLengthCompressor.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + compressionType);
    }

    public static ChunkDecompressor getDecompressor(ChunkCompressionType compressionType) {
        switch (compressionType) {
            case PASS_THROUGH: {
                return PassThroughDecompressor.INSTANCE;
            }
            case SNAPPY: {
                return SnappyDecompressor.INSTANCE;
            }
            case ZSTANDARD: {
                return ZstandardDecompressor.INSTANCE;
            }
            case LZ4: {
                return LZ4Decompressor.INSTANCE;
            }
            case LZ4_LENGTH_PREFIXED: {
                return LZ4WithLengthDecompressor.INSTANCE;
            }
        }
        throw new IllegalArgumentException("Illegal compressor name " + compressionType);
    }
}

