/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class StringLongPair
extends ValueLongPair<String> {
    public StringLongPair(String value, long time) {
        super(value, time);
    }

    public static StringLongPair fromBytes(byte[] bytes) {
        return StringLongPair.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static StringLongPair fromByteBuffer(ByteBuffer byteBuffer) {
        byte[] stringBytes = new byte[byteBuffer.getInt()];
        byteBuffer.get(stringBytes);
        return new StringLongPair(new String(stringBytes, StandardCharsets.UTF_8), byteBuffer.getLong());
    }

    @Override
    public byte[] toBytes() {
        byte[] stringBytes = ((String)((Object)this._value)).getBytes(StandardCharsets.UTF_8);
        ByteBuffer byteBuffer = ByteBuffer.allocate(4 + stringBytes.length + 8);
        byteBuffer.putInt(stringBytes.length);
        byteBuffer.put(stringBytes);
        byteBuffer.putLong(this._time);
        return byteBuffer.array();
    }
}

