/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;

public class BrokerSelectorUtils {
    private BrokerSelectorUtils() {
    }

    @Nullable
    @Deprecated
    public static List<String> getTablesCommonBrokers(@Nullable List<String> tableNames, Map<String, List<String>> brokerData) {
        Set<String> tablesCommonBrokersSet = BrokerSelectorUtils.getTablesCommonBrokersSet(tableNames, brokerData);
        if (tablesCommonBrokersSet == null || tablesCommonBrokersSet.isEmpty()) {
            return null;
        }
        return new ArrayList<String>(tablesCommonBrokersSet);
    }

    @Nullable
    public static String getRandomBroker(@Nullable List<String> tableNames, Map<String, List<String>> brokerData) {
        Set<String> tablesCommonBrokersSet = BrokerSelectorUtils.getTablesCommonBrokersSet(tableNames, brokerData);
        if (tablesCommonBrokersSet.isEmpty()) {
            return null;
        }
        return (String)tablesCommonBrokersSet.stream().skip(ThreadLocalRandom.current().nextInt(tablesCommonBrokersSet.size())).findFirst().orElseThrow(() -> new IllegalStateException("No broker found"));
    }

    public static Set<String> getTablesCommonBrokersSet(@Nullable List<String> tableNames, Map<String, List<String>> brokerData) {
        if (tableNames == null || tableNames.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> commonBrokers = BrokerSelectorUtils.getBrokers(tableNames.get(0), brokerData);
        for (int i = 1; i < tableNames.size() && !commonBrokers.isEmpty(); ++i) {
            commonBrokers.retainAll(BrokerSelectorUtils.getBrokers(tableNames.get(i), brokerData));
        }
        return commonBrokers;
    }

    private static String getTableNameWithoutSuffix(String tableName) {
        return tableName.replace("_OFFLINE", "").replace("_REALTIME", "");
    }

    private static HashSet<String> getBrokers(String tableName, Map<String, List<String>> brokerData) {
        List<String> brokersWithoutDb;
        String tableNameWithoutSuffix = BrokerSelectorUtils.getTableNameWithoutSuffix(tableName);
        int idx = tableNameWithoutSuffix.indexOf(46);
        List<String> brokers = brokerData.get(tableNameWithoutSuffix);
        if (brokers != null) {
            return new HashSet<String>(brokers);
        }
        if (idx > 0 && (brokersWithoutDb = brokerData.get(tableNameWithoutSuffix = tableNameWithoutSuffix.substring(idx + 1))) != null) {
            return new HashSet<String>(brokersWithoutDb);
        }
        return new HashSet<String>();
    }
}

