/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.client;

import com.fasterxml.jackson.databind.JsonNode;
import org.apache.pinot.client.AbstractResultSet;
import org.apache.pinot.client.TextTable;

class SelectionResultSet
extends AbstractResultSet {
    private JsonNode _resultsArray;
    private JsonNode _columnsArray;

    public SelectionResultSet(JsonNode selectionResults) {
        this._resultsArray = selectionResults.get("results");
        this._columnsArray = selectionResults.get("columns");
    }

    @Override
    public int getRowCount() {
        return this._resultsArray.size();
    }

    @Override
    public int getColumnCount() {
        return this._columnsArray.size();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this._columnsArray.get(columnIndex).asText();
    }

    @Override
    public String getString(int rowIndex, int columnIndex) {
        JsonNode jsonValue = this._resultsArray.get(rowIndex).get(columnIndex);
        if (jsonValue.isTextual()) {
            return jsonValue.textValue();
        }
        return jsonValue.toString();
    }

    @Override
    public int getGroupKeyLength() {
        return 0;
    }

    @Override
    public String getGroupKeyString(int rowIndex, int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No group key string for selection results");
    }

    @Override
    public String getGroupKeyColumnName(int groupKeyColumnIndex) {
        throw new AssertionError((Object)"No group key column name for selection results");
    }

    public String toString() {
        int numColumns = this.getColumnCount();
        TextTable table = new TextTable();
        String[] columnNames = new String[numColumns];
        for (int c = 0; c < numColumns; ++c) {
            columnNames[c] = this._columnsArray.get(c).asText();
        }
        table.addHeader(columnNames);
        int numRows = this.getRowCount();
        for (int r = 0; r < numRows; ++r) {
            String[] columnValues = new String[numColumns];
            for (int c = 0; c < numColumns; ++c) {
                try {
                    columnValues[c] = this.getString(r, c);
                    continue;
                }
                catch (Exception e) {
                    columnNames[c] = "ERROR";
                }
            }
            table.addRow(columnValues);
        }
        return table.toString();
    }
}

